/*
 * Decompiled with CFR 0.152.
 */
package net.wordrider.core;

import java.util.Collection;
import java.util.LinkedList;
import java.util.logging.Logger;
import net.wordrider.core.AppPrefs;
import net.wordrider.core.MainAppFrame;
import net.wordrider.core.OneInstanceClient;
import net.wordrider.core.actions.CheckForNewVersion;
import net.wordrider.utilities.LogUtils;
import net.wordrider.utilities.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MainApp {
    private MainAppFrame mainAppFrame;
    private static final MainApp ourInstance = new MainApp();
    private static Logger logger;
    private static boolean debug;

    public static void makeProgress() {
        System.out.println("Loading ... please wait");
    }

    public static MainApp getInstance() {
        return ourInstance;
    }

    private MainApp() {
    }

    private static Collection<String> processArguments(String[] stringArray) {
        LinkedList<String> linkedList = null;
        for (String string : stringArray) {
            if (string.startsWith("-")) {
                if (string.equals("-d") || string.equals("-debug") || string.equals("--debug")) {
                    debug = true;
                    continue;
                }
                if (string.equals("-h") || string.endsWith("-help")) {
                    MainApp.showHelp();
                    continue;
                }
                if (!string.equals("-v") && !string.equals("--version")) continue;
                MainApp.showVersion();
                continue;
            }
            if (linkedList == null) {
                linkedList = new LinkedList<String>();
            }
            linkedList.add(string);
        }
        return linkedList;
    }

    private static void showVersion() {
        System.out.println("WordRider 0.8 alpha 3 preview");
        System.out.printf("created by VitySoft(c) 2004-2006 %s%n", "http://wordrider.net");
        System.exit(0);
    }

    public static void main(String[] stringArray) {
        Collection<String> collection = MainApp.processArguments(stringArray);
        if (!Utils.isJVMVersion(1.5)) {
            System.err.println("Whooops. Application requires a 1.5 version or later of the Java platform.");
            System.err.println("Please upgrade to a newer version. Read 'readme.txt' file for available URLs.");
            System.exit(-1);
        }
        LogUtils.initLogging(debug);
        logger = Logger.getLogger(MainApp.class.getName());
        if (OneInstanceClient.checkInstance(collection)) {
            return;
        }
        try {
            MainApp.getInstance().start(collection);
        }
        catch (Exception exception) {
            LogUtils.processException(logger, exception);
        }
    }

    private static void showHelp() {
        System.out.println("Usage: wordrider [-options] [file(s)]");
        System.out.println("commands: -h, --help  - to view this message");
        System.out.println("          -v, --version - display version information and exit");
        System.out.println("          -d, -debug - enable debug log level\n");
        System.out.println("           file(s) - path to file(s) for opening");
        System.out.println("min. Java version required : 1.5");
        System.out.println("See the readme.txt for more information.\n");
        System.exit(0);
    }

    private void start(Collection<String> collection) {
        this.getMainAppFrame().init(collection);
        if (AppPrefs.getProperty("settings.newversion", false)) {
            this.startCheckNewVersion();
        }
    }

    private void startCheckNewVersion() {
        Thread thread = new Thread(){

            public void run() {
                try {
                    Thread.sleep(30000L);
                    CheckForNewVersion.check(false);
                }
                catch (InterruptedException interruptedException) {
                }
                catch (Exception exception) {
                    LogUtils.processException(logger, exception);
                }
            }
        };
        thread.setPriority(1);
        thread.start();
    }

    public final MainAppFrame getMainAppFrame() {
        if (this.mainAppFrame == null) {
            this.mainAppFrame = new MainAppFrame();
            return this.mainAppFrame;
        }
        return this.mainAppFrame;
    }

    static {
        debug = false;
    }
}

