/*
 * Decompiled with CFR 0.152.
 */
package net.wordrider.core.actions;

import java.awt.Cursor;
import java.io.File;
import java.io.IOException;
import net.wordrider.area.RiderArea;
import net.wordrider.core.AppPrefs;
import net.wordrider.core.Lng;
import net.wordrider.core.actions.AbstractFileProcessor;
import net.wordrider.core.actions.BatchPureTextReader;
import net.wordrider.core.managers.AreaManager;
import net.wordrider.core.managers.FileInstance;
import net.wordrider.files.miscformat.PureTextReader;
import net.wordrider.files.ti68kformat.TITextFileInfo;
import net.wordrider.utilities.LogUtils;
import net.wordrider.utilities.Swinger;

class PureTextFileProcessor
extends AbstractFileProcessor {
    public PureTextFileProcessor(File file) {
        super(file);
    }

    public boolean process() {
        super.process();
        AreaManager areaManager = AreaManager.getInstance();
        try {
            PureTextReader pureTextReader = new PureTextReader();
            File file = this.getFile();
            pureTextReader.openFromFile(file);
            FileInstance fileInstance = new FileInstance(null, new TITextFileInfo());
            fileInstance.getFileInfo().setOutputFormat(AppPrefs.getProperty("settings.inputFormatHibview", true) ? 0 : 1);
            areaManager.openFileInstance(fileInstance);
            RiderArea riderArea = fileInstance.getRiderArea();
            riderArea.setCursor(Cursor.getPredefinedCursor(3));
            fileInstance.setModified(true);
            boolean bl = this.loadDocument(riderArea, new BatchPureTextReader(fileInstance, pureTextReader.getContent()));
            fileInstance.setModified(true);
            return bl;
        }
        catch (IOException iOException) {
            LogUtils.processException(logger, iOException);
            Swinger.showErrorDialog(this.getMainFrame(), Lng.getLabel("message.error.reading", iOException.getMessage()));
            return false;
        }
        catch (Exception exception) {
            logger.warning(exception.getMessage());
            Swinger.showErrorDialog(this.getMainFrame(), exception.getMessage());
            return false;
        }
    }
}

