/*
 * Decompiled with CFR 0.152.
 */
package net.wordrider.dialogs.settings;

import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JLabel;
import net.wordrider.core.Lng;
import net.wordrider.core.MainApp;
import net.wordrider.core.swing.CustomLayoutConstraints;
import net.wordrider.dialogs.settings.CheckBoxOption;
import net.wordrider.dialogs.settings.ColorOptionsGroup;
import net.wordrider.dialogs.settings.ComboBoxOption;
import net.wordrider.dialogs.settings.DefaultOptionsGroup;
import net.wordrider.dialogs.settings.IOptionGroup;
import net.wordrider.dialogs.settings.SettingsDialog;
import net.wordrider.dialogs.settings.SettingsPanel;
import net.wordrider.gui.LaF;
import net.wordrider.gui.LookAndFeels;
import net.wordrider.utilities.LogUtils;
import net.wordrider.utilities.Swinger;

final class AppearanceSettingsPanel
extends SettingsPanel {
    private static final Logger logger = Logger.getLogger(AppearanceSettingsPanel.class.getName());

    public AppearanceSettingsPanel(SettingsDialog settingsDialog, String string) {
        super(settingsDialog, string);
    }

    protected final void init() {
        JLabel jLabel = Swinger.getLabel("settings.lookandfeel");
        final Vector<LaF> vector = LookAndFeels.getInstance().getAvailableLookAndFeels();
        DefaultComboBoxModel<LaF> defaultComboBoxModel = new DefaultComboBoxModel<LaF>(vector);
        int n = vector.indexOf(LookAndFeels.getInstance().getSelectedLaF());
        if (n != -1) {
            defaultComboBoxModel.setSelectedItem(vector.elementAt(n));
        }
        DefaultOptionsGroup defaultOptionsGroup = new DefaultOptionsGroup();
        ComboBoxOption comboBoxOption = new ComboBoxOption(this.manager, defaultComboBoxModel, defaultOptionsGroup){

            public void applyChange() {
                int n;
                super.applyChange();
                boolean bl = AppearanceSettingsPanel.changeLookAndFeel((LaF)this.getComponent().getSelectedItem());
                if (!bl && (n = vector.indexOf(LookAndFeels.getInstance().getSelectedLaF())) != -1) {
                    this.getComponent().setSelectedItem(vector.elementAt(n));
                }
            }
        };
        Dimension dimension = comboBoxOption.getComponent().getPreferredSize();
        dimension.height = 23;
        comboBoxOption.getComponent().setPreferredSize(dimension);
        comboBoxOption.getComponent().setMaximumSize(new Dimension(80, 23));
        jLabel.setLabelFor(comboBoxOption.getComponent());
        ColorOptionsGroup colorOptionsGroup = new ColorOptionsGroup();
        CheckBoxOption checkBoxOption = new CheckBoxOption(this.manager, "settings.antialiasing", Swinger.antialiasing, (IOptionGroup)colorOptionsGroup){

            public void applyChange() {
                super.applyChange();
                Swinger.setAntialiasing(this.getComponent().isSelected());
            }
        };
        CheckBoxOption checkBoxOption2 = new CheckBoxOption(this.manager, "settings.decoratedFrames", "settings.decorated", false, defaultOptionsGroup);
        CheckBoxOption checkBoxOption3 = new CheckBoxOption(this.manager, "settings.usescrollLayout", "settings.scrolllayout", true, defaultOptionsGroup){

            public void applyChange() {
                super.applyChange();
                MainApp.getInstance().getMainAppFrame().getManagerDirector().getAreaManager().applyTabLayout();
            }
        };
        TableLayout tableLayout = new TableLayout(new double[]{-2.0, -1.0}, new double[]{-2.0, -2.0, -2.0, -2.0});
        tableLayout.setHGap(10);
        tableLayout.setVGap(2);
        this.setLayout(tableLayout);
        this.add((Component)jLabel, new CustomLayoutConstraints(0, 0));
        this.add((Component)comboBoxOption.getComponent(), new CustomLayoutConstraints(1, 0, 1, 1, 0, 0));
        this.add((Component)checkBoxOption.getComponent(), new CustomLayoutConstraints(0, 1, 2, 1));
        this.add((Component)checkBoxOption2.getComponent(), new CustomLayoutConstraints(0, 2, 2, 1));
        this.add((Component)checkBoxOption3.getComponent(), new CustomLayoutConstraints(0, 3, 2, 1));
    }

    private static boolean changeLookAndFeel(LaF laF) {
        if (LookAndFeels.getInstance().getSelectedLaF().equals(laF)) {
            return true;
        }
        boolean bl = false;
        try {
            bl = LookAndFeels.getInstance().loadLookAndFeel(laF, true);
            if (bl) {
                LookAndFeels.getInstance().storeSelectedLaF(laF);
            }
        }
        catch (Exception exception) {
            LogUtils.processException(logger, exception);
        }
        if (bl) {
            try {
                Swinger.showInformationDialog(MainApp.getInstance().getMainAppFrame(), Lng.getLabel("ChangeLookAndFeelAction.set"));
            }
            catch (Exception exception) {
                LogUtils.processException(logger, exception);
            }
        } else {
            Swinger.showErrorDialog(MainApp.getInstance().getMainAppFrame(), Lng.getLabel("ChangeLookAndFeelAction.failed"));
        }
        return bl;
    }
}

