/*
 * Decompiled with CFR 0.152.
 */
package net.wordrider.files.ti68kformat;

import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import java.awt.image.IndexColorModel;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import java.util.logging.Logger;
import net.wordrider.files.ti68kformat.TIFileConstants;
import net.wordrider.files.ti68kformat.TIFileReader;
import net.wordrider.utilities.LogUtils;

public final class TIImageDecoder
extends TIFileReader
implements ImageProducer {
    private static final Logger logger = Logger.getLogger(TIImageDecoder.class.getName());
    private static final String TI_ORIGFILENAME = "TI_ORIGFILENAME";
    private ImageConsumer consumer;
    private int width = -1;
    private int height = -1;
    private byte[] store;
    private final Hashtable<String, File> props = new Hashtable(4);
    private char sum;
    private int widthExtension = 0;
    private static final int hints = 30;

    public final File getOriginalFile() {
        return this.props.get(TI_ORIGFILENAME);
    }

    public final void setOriginalFile(File file) {
        this.props.put(TI_ORIGFILENAME, file);
    }

    protected void storeFileInformation(File file) {
        this.setOriginalFile(file);
    }

    protected final void readContent(DataInputStream dataInputStream) throws IOException {
        dataInputStream.skip(4L);
        this.sum = (char)(dataInputStream.readUnsignedByte() + dataInputStream.readUnsignedByte());
        int n = dataInputStream.readUnsignedByte();
        int n2 = dataInputStream.readUnsignedByte();
        this.height = (n << 8) + n2;
        this.sum = (char)(this.sum + (n + n2));
        n = dataInputStream.readUnsignedByte();
        n2 = dataInputStream.readUnsignedByte();
        this.width = (n << 8) + n2;
        this.sum = (char)(this.sum + (n + n2));
        this.widthExtension = this.width % 8 != 0 ? this.width + (8 - this.width % 8) : this.width;
        byte[] byArray = new byte[this.height * (this.widthExtension / 8)];
        dataInputStream.readFully(byArray);
        int n3 = byArray.length;
        this.store = new byte[n3 * 8];
        int n4 = 0;
        for (int i = 0; i < n3; ++i) {
            byte by = byArray[i];
            this.sum = (char)(this.sum + (char)(by & 0xFF));
            int n5 = 7;
            do {
                int n6 = this.store[n4++] = (by & 1 << n5) != 0 ? -1 : 0;
            } while (--n5 >= 0);
        }
        this.sum = (char)(this.sum + dataInputStream.readUnsignedByte());
    }

    protected String[] getSupportedHeaders() {
        return TIFileConstants.SUPPORTED_FORMATS_TEXT;
    }

    public final byte getDataType() {
        return 16;
    }

    public final char getCheckSum() {
        return this.sum;
    }

    public final synchronized void addConsumer(ImageConsumer imageConsumer) {
        block2: {
            this.consumer = imageConsumer;
            try {
                this.produce();
            }
            catch (Exception exception) {
                LogUtils.processException(logger, exception);
                if (this.consumer == null) break block2;
                this.consumer.imageComplete(1);
            }
        }
        this.consumer = null;
    }

    public final synchronized boolean isConsumer(ImageConsumer imageConsumer) {
        return imageConsumer.equals(this.consumer);
    }

    public final synchronized void removeConsumer(ImageConsumer imageConsumer) {
        if (this.consumer != null && this.consumer.equals(imageConsumer)) {
            this.consumer = null;
        }
    }

    public final void startProduction(ImageConsumer imageConsumer) {
        this.addConsumer(imageConsumer);
    }

    public final void requestTopDownLeftRightResend(ImageConsumer imageConsumer) {
    }

    private void produce() {
        byte[] byArray = new byte[]{-1, 0};
        IndexColorModel indexColorModel = new IndexColorModel(1, 2, byArray, byArray, byArray);
        if (this.consumer != null) {
            this.consumer.setDimensions(this.width, this.height);
            this.consumer.setColorModel(indexColorModel);
            this.consumer.setHints(30);
            int n = 0;
            for (int i = 0; i < this.height; ++i) {
                this.consumer.setPixels(0, i, this.width, 1, (ColorModel)indexColorModel, this.store, n, this.width);
                n += this.widthExtension;
            }
            this.consumer.setProperties(this.props);
            this.consumer.imageComplete(3);
        }
    }

    public String getContent() {
        return null;
    }
}

