/*
 * Decompiled with CFR 0.152.
 */
package net.wordrider.dialogs.pictures.filters;

import java.awt.Color;
import net.wordrider.dialogs.pictures.filters.DitherRaster;

abstract class OrderedFilter
extends DitherRaster {
    private final int[] pattern;
    private final int level;
    private static final int whiteRGB = Color.WHITE.getRGB();
    private static final int blackRGB = Color.BLACK.getRGB();

    public OrderedFilter(int[] nArray, int n) {
        this.pattern = nArray;
        this.level = n;
        this.initPattern();
    }

    private void initPattern() {
        int n = this.pattern.length;
        for (int i = 0; i < n; ++i) {
            this.pattern[i] = 255 * this.pattern[i] / n;
        }
    }

    protected void performEffect() {
        for (int i = 0; i < this.height; ++i) {
            for (int j = 0; j < this.width; ++j) {
                int n = i * this.width + j;
                int n2 = this.pixels[n] & 0xFF;
                this.pixels[n] = n2 != 255 && this.pattern[i % this.level * this.level + j % this.level] >= n2 ? blackRGB : whiteRGB;
            }
        }
    }
}

