/*
 * Decompiled with CFR 0.152.
 */
package net.wordrider.area;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.logging.Logger;
import javax.swing.plaf.TextUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import net.wordrider.area.RiderCaret;
import net.wordrider.utilities.LogUtils;

final class OvertypeCaret
extends RiderCaret {
    private static final Logger logger = Logger.getLogger(OvertypeCaret.class.getName());

    OvertypeCaret() {
    }

    public final void paint(Graphics graphics) {
        if (this.isVisible()) {
            try {
                JTextComponent jTextComponent = this.getComponent();
                TextUI textUI = jTextComponent.getUI();
                Rectangle rectangle = textUI.modelToView(jTextComponent, this.getDot());
                Color color = jTextComponent.getCaretColor();
                graphics.setColor(color);
                int n = graphics.getFontMetrics().charWidth('w');
                int n2 = rectangle.y + rectangle.height - 2;
                graphics.drawLine(rectangle.x, n2, rectangle.x + n - 2, n2);
            }
            catch (BadLocationException badLocationException) {
                LogUtils.processException(logger, badLocationException);
            }
        }
    }

    protected final synchronized void damage(Rectangle rectangle) {
        if (rectangle != null) {
            JTextComponent jTextComponent = this.getComponent();
            this.x = rectangle.x;
            this.y = rectangle.y;
            this.width = jTextComponent.getFontMetrics(jTextComponent.getFont()).charWidth('w');
            this.height = rectangle.height;
            this.repaint();
        }
    }
}

