/*
 * Decompiled with CFR 0.152.
 */
package net.wordrider.area.actions;

import java.awt.event.ActionEvent;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Utilities;
import net.wordrider.area.RiderEditorKit;
import net.wordrider.area.actions.WordAction;
import net.wordrider.utilities.LogUtils;

public final class SelectWordAction
extends WordAction {
    private static final Logger logger = Logger.getLogger(SelectWordAction.class.getName());

    public SelectWordAction() {
        super("SelectWordAction");
    }

    private static char getCharAt(Document document, int n) {
        try {
            return document.getText(n, 1).charAt(0);
        }
        catch (BadLocationException badLocationException) {
            return '\u0000';
        }
    }

    private int getEndOfWord(Element element, Document document, int n) {
        try {
            int n2;
            String string = document.getText(n, element.getEndOffset() - n);
            int n3 = string.length();
            for (n2 = 0; n2 < n3 && !RiderEditorKit.WORD_SEPARATORS.get(string.charAt(n2)); ++n2) {
            }
            return n2 + n;
        }
        catch (BadLocationException badLocationException) {
            LogUtils.processException(logger, badLocationException);
            return element.getEndOffset();
        }
    }

    private int getBeginOfWord(Element element, Document document, int n) {
        try {
            int n2;
            String string = document.getText(element.getStartOffset(), n - element.getStartOffset());
            for (n2 = string.length() - 1; n2 >= 0 && !RiderEditorKit.WORD_SEPARATORS.get(string.charAt(n2)); --n2) {
            }
            return element.getStartOffset() + n2 + 1;
        }
        catch (BadLocationException badLocationException) {
            LogUtils.processException(logger, badLocationException);
            return element.getStartOffset();
        }
    }

    private int checkWord(Element element, Document document, int n, int n2) {
        try {
            int n3;
            String string = document.getText(n, n2 - n);
            int n4 = string.length();
            for (n3 = 0; n3 < n4 && !RiderEditorKit.WORD_SEPARATORS.get(string.charAt(n3)); ++n3) {
            }
            return n3 + n;
        }
        catch (BadLocationException badLocationException) {
            LogUtils.processException(logger, badLocationException);
            return element.getEndOffset();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        Document document = this.textArea.getDocument();
        int n = this.textArea.getSelectionStart();
        int n2 = this.textArea.getSelectionEnd();
        Element element = Utilities.getParagraphElement(this.textArea, this.caretPosition);
        int n3 = element.getEndOffset();
        int n4 = element.getStartOffset();
        if (n == n2) {
            char c;
            boolean bl = false;
            boolean bl2 = false;
            if (this.caretPosition > n4) {
                c = SelectWordAction.getCharAt(document, this.caretPosition - 1);
                boolean bl3 = bl2 = c != '\u0000' && !RiderEditorKit.WORD_SEPARATORS.get(c);
            }
            if (this.caretPosition < n3) {
                c = SelectWordAction.getCharAt(document, this.caretPosition);
                boolean bl4 = bl = c != '\u0000' && !RiderEditorKit.WORD_SEPARATORS.get(c);
            }
            if (bl2 && bl) {
                this.textArea.select(this.getWordInDirection(1), this.getEndOfWord(element, document, this.caretPosition));
            } else if (bl2) {
                this.textArea.moveCaretPosition(this.getWordInDirection(1));
            } else if (bl) {
                this.textArea.moveCaretPosition(this.getEndOfWord(element, document, this.caretPosition));
            } else {
                this.textArea.select(n4, n3 - 1);
            }
        } else {
            if (n >= n4 && n2 <= n3 && (n != n4 || n2 != n3 - 1)) {
                if (this.checkWord(element, document, n, n2) != n2) {
                    this.textArea.select(n4, n3 - 1);
                } else {
                    int n5 = this.getBeginOfWord(element, document, n);
                    int n6 = this.getEndOfWord(element, document, n2);
                    if (n5 == n && n6 == n2) {
                        this.textArea.select(n4, n3 - 1);
                    } else {
                        this.textArea.select(n5, n6);
                    }
                }
                return;
            }
            this.textArea.selectAll();
        }
    }
}

