/*
 * Decompiled with CFR 0.152.
 */
package net.wordrider.area.actions;

import java.awt.event.ActionEvent;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.KeyStroke;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.Utilities;
import net.wordrider.area.RiderArea;
import net.wordrider.area.RiderDocument;
import net.wordrider.area.RiderStyles;
import net.wordrider.area.SelectedElementsIterator;
import net.wordrider.area.actions.StyledAreaAction;
import net.wordrider.area.actions.TextToUpperCaseAction;
import net.wordrider.utilities.LogUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TextConversionAction
extends StyledAreaAction {
    private static final Logger logger = Logger.getLogger(TextToUpperCaseAction.class.getName());

    public TextConversionAction(String string, KeyStroke keyStroke, String string2) {
        super(string, keyStroke, string2);
    }

    @Override
    public final void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        RiderArea riderArea = this.getRiderArea(actionEvent);
        if (riderArea == null) {
            return;
        }
        try {
            this.process(riderArea);
        }
        catch (BadLocationException badLocationException) {
            LogUtils.processException(logger, badLocationException);
        }
    }

    private void process(RiderArea riderArea) throws BadLocationException {
        int n;
        int n2;
        int n3;
        boolean bl;
        RiderDocument riderDocument = riderArea.getDoc();
        int n4 = riderArea.getCaret().getMark();
        boolean bl2 = bl = n4 != (n3 = riderArea.getCaret().getDot());
        if (bl) {
            n2 = riderArea.getSelectionStart();
            n = riderArea.getSelectionEnd();
        } else {
            int n5 = Utilities.getWordEnd(riderArea, n3);
            int n6 = Utilities.getWordStart(riderArea, n3);
            if (n3 >= n6 && n3 < n5) {
                n2 = n4 = n6;
                n = n3 = n5;
            } else {
                return;
            }
        }
        List<SimpleStyledContent> list = this.findAndReplace(riderDocument, n2, n);
        if (list.isEmpty()) {
            return;
        }
        this.doChanges(list, riderArea, riderDocument);
        riderArea.selectReverse(n4, n3);
        riderDocument.refresh(n2, n);
    }

    List<SimpleStyledContent> findAndReplace(RiderDocument riderDocument, int n, int n2) throws BadLocationException {
        Element element;
        Element element2 = riderDocument.getDefaultRootElement();
        SelectedElementsIterator selectedElementsIterator = new SelectedElementsIterator(element2, n, n2, 1);
        LinkedList<SimpleStyledContent> linkedList = new LinkedList<SimpleStyledContent>();
        while ((element = selectedElementsIterator.next()) != null) {
            String string;
            String string2;
            int n3;
            int n4;
            int n5 = element.getStartOffset();
            int n6 = element.getEndOffset();
            if (!RiderStyles.isText(element)) continue;
            AttributeSet attributeSet = element.getAttributes();
            if (selectedElementsIterator.isFirstLeafElement()) {
                n4 = n;
                n3 = selectedElementsIterator.isLastLeafElement() ? n2 - n : n6 - n;
            } else {
                n4 = n5;
                int n7 = n3 = selectedElementsIterator.isLastLeafElement() ? n2 - n5 : n6 - n5;
            }
            if ((string2 = riderDocument.getText(n4, n3)).length() == 0 || string2.length() == 1 && string2.equals("\n") || (string = this.doStringConversion(string2)).equals(string2)) continue;
            linkedList.add(new SimpleStyledContent(string, n4, n3, attributeSet.copyAttributes(), element.getParentElement().getAttributes().copyAttributes()));
        }
        return linkedList;
    }

    protected abstract String doStringConversion(String var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doChanges(List<SimpleStyledContent> list, RiderArea riderArea, RiderDocument riderDocument) throws BadLocationException {
        try {
            riderArea.makeGroupChange(true);
            for (SimpleStyledContent simpleStyledContent : list) {
                riderDocument.remove(simpleStyledContent.selStart, simpleStyledContent.selLength);
                riderDocument.insertString(simpleStyledContent.selStart, simpleStyledContent.text, simpleStyledContent.attributes);
                riderDocument.setParagraphAttributes(simpleStyledContent.selStart, simpleStyledContent.selLength, simpleStyledContent.paraAttributes, true);
            }
        }
        finally {
            riderArea.makeGroupChange(false);
        }
    }

    static class SimpleStyledContent {
        private AttributeSet attributes;
        private final AttributeSet paraAttributes;
        private String text;
        private int selStart;
        private int selLength;

        public SimpleStyledContent(String string, int n, int n2, AttributeSet attributeSet, AttributeSet attributeSet2) {
            this.text = string;
            this.selStart = n;
            this.selLength = n2;
            this.attributes = attributeSet;
            this.paraAttributes = attributeSet2;
        }
    }
}

