/*
 * Decompiled with CFR 0.152.
 */
package net.wordrider.core;

import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Collection;
import java.util.logging.Logger;
import net.wordrider.core.AppPrefs;
import net.wordrider.core.OneInstanceServer;
import net.wordrider.utilities.LogUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class OneInstanceClient {
    private static final Logger logger = Logger.getLogger(OneInstanceClient.class.getName());

    private OneInstanceClient() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkInstance(Collection<String> collection) {
        if (!AppPrefs.getProperty("settings.oneinstance", false)) {
            return false;
        }
        Socket socket = null;
        try {
            block20: {
                logger.info("Testing existing instance");
                socket = new Socket("localhost", 35139);
                if (collection != null && !collection.isEmpty()) {
                    OutputStream outputStream = null;
                    try {
                        outputStream = socket.getOutputStream();
                        if (outputStream != null) {
                            for (String string : collection) {
                                outputStream.write(string.getBytes());
                                outputStream.write(10);
                            }
                            outputStream.close();
                        }
                    }
                    catch (IOException iOException) {
                        LogUtils.processException(logger, iOException);
                        if (outputStream == null) break block20;
                        try {
                            outputStream.close();
                        }
                        catch (Exception exception) {
                            LogUtils.processException(logger, exception);
                        }
                    }
                }
            }
            logger.info("Application is already running. Exiting");
            boolean bl = true;
            return bl;
        }
        catch (IOException iOException) {
            logger.info("No other instance is running.");
            OneInstanceServer oneInstanceServer = new OneInstanceServer();
            oneInstanceServer.start();
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException iOException) {
                    LogUtils.processException(logger, iOException);
                }
            }
        }
        return false;
    }
}

