/*
 * Decompiled with CFR 0.152.
 */
package net.wordrider.plugintools;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.Utilities;
import net.wordrider.area.RiderDocument;
import net.wordrider.area.RiderStyles;
import net.wordrider.core.Lng;
import net.wordrider.core.managers.AreaManager;
import net.wordrider.core.managers.interfaces.IFileInstance;
import net.wordrider.plugintools.PluginTool;
import net.wordrider.utilities.LogUtils;
import net.wordrider.utilities.Swinger;

public final class BreakpointList
extends PluginTool
implements CaretListener,
PropertyChangeListener,
DocumentListener,
ListSelectionListener {
    private static JTextComponent editor;
    private static final Logger logger;
    private final JList list = new JList();
    private ListViewModel listModel;

    public BreakpointList() {
        try {
            this.list.addKeyListener(new UnsetBreakpointListener());
            this.list.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent mouseEvent) {
                    if (mouseEvent.getClickCount() == 2 && BreakpointList.this.list.getSelectedIndex() != -1) {
                        BreakpointList.getEditor().requestFocus();
                        mouseEvent.consume();
                    }
                }
            });
            this.list.setFont(RiderStyles.getAreaFont());
            this.list.addListSelectionListener(this);
            this.list.setCellRenderer(new MyCellRenderer());
            Container container = this.getContentPane();
            container.setLayout(new BorderLayout());
            this.list.setBorder(new EmptyBorder(2, 2, 2, 4));
            container.add((Component)new JScrollPane(this.list), "Center");
            this.getComponent().setPreferredSize(new Dimension(250, 300));
        }
        catch (Exception exception) {
            LogUtils.processException(logger, exception);
        }
    }

    public final String getName() {
        return Lng.getLabel("breakpoints.title");
    }

    public String getTabName() {
        return this.getName();
    }

    public final Icon getIcon() {
        return Swinger.getIcon("view_bookm.gif");
    }

    public final String getTip() {
        return Lng.getLabel("breakpoints.tooltip");
    }

    public void activate() {
        this.setFileInstance((IFileInstance)AreaManager.getInstance().getActiveInstance());
        logger.info("BreakpointList activated");
    }

    public void deactivate() {
        this.setFileInstance(null);
        logger.info("BreakpointList deactivated");
    }

    public void updateData() {
        if (editor != null && this.listModel != null) {
            this.listModel.updateDataList();
        }
    }

    public void setFileInstance(IFileInstance iFileInstance) {
        if (iFileInstance != null) {
            this.setEditor((JTextComponent)iFileInstance.getRiderArea());
        } else {
            this.setEditor(null);
        }
        this.getContentPane().setEnabled(editor != null);
    }

    private void setEditor(JTextComponent jTextComponent) {
        if (editor != null && editor.equals(jTextComponent)) {
            return;
        }
        if (editor != null) {
            editor.getDocument().removeDocumentListener(this);
            editor.removePropertyChangeListener(this);
            editor.removeCaretListener(this);
        }
        editor = jTextComponent;
        if (jTextComponent == null) {
            this.listModel = null;
            this.list.setModel(new DefaultListModel());
        } else {
            Document document = jTextComponent.getDocument();
            document.addDocumentListener(this);
            jTextComponent.addPropertyChangeListener(this);
            jTextComponent.addCaretListener(this);
            this.listModel = new ListViewModel(document);
            this.list.setModel(this.listModel);
        }
    }

    private static JTextComponent getEditor() {
        return editor;
    }

    public final void caretUpdate(CaretEvent caretEvent) {
        if (!this.list.hasFocus()) {
            Element element = editor.getDocument().getDefaultRootElement();
            if (this.listModel.contains(element = element.getElement(element.getElementIndex(caretEvent.getDot())))) {
                this.list.setSelectedValue(element, true);
            }
        }
    }

    public final void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getSource().equals(BreakpointList.getEditor()) && propertyChangeEvent.getPropertyName().equals("document")) {
            ((Document)propertyChangeEvent.getOldValue()).removeDocumentListener(this);
            Document document = (Document)propertyChangeEvent.getNewValue();
            document.addDocumentListener(this);
            this.listModel = new ListViewModel(document);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    BreakpointList.this.list.setModel(BreakpointList.this.listModel);
                }
            });
        }
    }

    public final void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (this.list.hasFocus() && this.list.getSelectedIndex() >= 0) {
            Rectangle rectangle;
            Element element = (Element)this.list.getSelectedValue();
            try {
                rectangle = editor.modelToView(element.getStartOffset());
            }
            catch (BadLocationException badLocationException) {
                LogUtils.processException(logger, badLocationException);
                return;
            }
            if (rectangle == null) {
                return;
            }
            rectangle.y += -10;
            rectangle.height = BreakpointList.editor.getVisibleRect().height;
            editor.setSelectionStart(element.getStartOffset());
            editor.setSelectionEnd(element.getStartOffset());
            editor.scrollRectToVisible(rectangle);
        }
    }

    public final void changedUpdate(DocumentEvent documentEvent) {
        this.updateList(documentEvent);
    }

    public final void insertUpdate(final DocumentEvent documentEvent) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                BreakpointList.this.updateList(documentEvent);
            }
        });
    }

    public final void removeUpdate(DocumentEvent documentEvent) {
        this.insertUpdate(documentEvent);
    }

    private void updateList(DocumentEvent documentEvent) {
        this.updateList(documentEvent, BreakpointList.getEditor().getDocument().getDefaultRootElement());
    }

    private void updateList(DocumentEvent documentEvent, Element element) {
        DocumentEvent.ElementChange elementChange = documentEvent.getChange(element);
        if (elementChange != null) {
            Element[] elementArray = elementChange.getChildrenRemoved();
            Element[] elementArray2 = elementChange.getChildrenAdded();
            if (elementArray != null && elementArray.length > 0) {
                for (Element element2 : elementArray) {
                    this.listModel.removeElement(element2);
                }
            }
            if (elementArray2 != null && elementArray2.length > 0) {
                for (Element element2 : elementArray2) {
                    this.listModel.addIfCan(element2);
                }
            }
        }
        this.listModel.checkValue(element.getElement(element.getElementIndex(documentEvent.getOffset())));
        this.listModel.updateData();
    }

    public boolean closeSoft() {
        return true;
    }

    public void closeHard() {
    }

    static {
        logger = Logger.getLogger(BreakpointList.class.getName());
    }

    private static final class ListViewModel
    extends AbstractListModel {
        private final Vector<Element> delegate = new Vector();
        private final Map<Element, String> stringsMap = new Hashtable<Element, String>();
        private final Document document;
        boolean wasChanged = false;

        public ListViewModel(Document document) {
            this.document = document;
            Element element = document.getDefaultRootElement();
            int n = element.getElementCount();
            for (int i = 0; i < n; ++i) {
                Element element2 = element.getElement(i);
                if (!RiderStyles.isBookmark(element2)) continue;
                this.delegate.addElement(element2);
                this.stringsMap.put(element2, this.convertValueToText(element2));
            }
            if (!this.delegate.isEmpty()) {
                this.fireContentsChanged(this, 0, this.delegate.size());
            }
        }

        public final synchronized void updateDataList() {
            Iterator<Element> iterator = new ArrayList<Element>(this.stringsMap.keySet()).iterator();
            while (iterator.hasNext()) {
                Element element;
                Element element2 = element = iterator.next();
                this.stringsMap.put(element2, this.convertValueToText(element2));
            }
            this.fireContentsChanged(this, 0, this.delegate.size());
        }

        public final void addIfCan(Element element) {
            if (RiderStyles.isBookmark(element)) {
                this.wasChanged = true;
                this.delegate.addElement(element);
                this.stringsMap.put(element, this.convertValueToText(element));
            }
        }

        public final int getSize() {
            return this.delegate.size();
        }

        public final Object getElementAt(int n) {
            return n < this.delegate.size() ? this.delegate.elementAt(n) : null;
        }

        public final void updateData() {
            if (this.wasChanged && !this.delegate.isEmpty()) {
                logger.info("update list refresh");
                TreeSet<Element> treeSet = new TreeSet<Element>(new MyComparator());
                treeSet.addAll(this.delegate);
                this.delegate.removeAllElements();
                this.delegate.addAll(treeSet);
                this.wasChanged = false;
                this.fireContentsChanged(this, 0, this.delegate.size());
            }
        }

        public final void checkValue(final Element element) {
            boolean bl = RiderStyles.isBookmark(element);
            if (this.contains(element)) {
                if (!bl) {
                    this.removeElement(element);
                } else {
                    final int n = this.delegate.indexOf(element);
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            String string = ListViewModel.this.convertValueToText(element);
                            if (!string.equals(ListViewModel.this.stringsMap.get(element))) {
                                ListViewModel.this.stringsMap.put(element, string);
                                ListViewModel.this.fireContentsChanged(this, n, n);
                            }
                        }
                    });
                }
            } else if (bl) {
                this.delegate.addElement(element);
                this.stringsMap.put(element, this.convertValueToText(element));
                this.wasChanged = true;
            }
        }

        public final boolean contains(Element element) {
            return this.delegate.contains(element);
        }

        public final void removeElement(Element element) {
            int n = this.delegate.indexOf(element);
            this.delegate.removeElement(element);
            this.stringsMap.remove(element);
            this.wasChanged = true;
            if (n >= 0) {
                this.fireContentsChanged(this, n, n);
            }
        }

        private String convertValueToText(Element element) {
            int n = element.getStartOffset();
            try {
                int n2 = Utilities.getRowEnd(BreakpointList.getEditor(), n);
                String string = this.document.getText(n, n2 != -1 ? n2 - n + 1 : element.getEndOffset() - n);
                return string == null || string.equals("\n") ? "-" : string;
            }
            catch (BadLocationException badLocationException) {
                LogUtils.processException(logger, badLocationException);
                return "";
            }
        }

        public String getStringValue(Object object) {
            return this.stringsMap.get(object);
        }

        private static final class MyComparator
        implements Comparator {
            private MyComparator() {
            }

            public final int compare(Object object, Object object2) {
                return ((Element)object).getStartOffset() - ((Element)object2).getStartOffset();
            }
        }
    }

    private final class MyCellRenderer
    extends DefaultListCellRenderer {
        private MyCellRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            return super.getListCellRendererComponent((JList<?>)jList, BreakpointList.this.listModel.getStringValue(object), n, bl, bl2);
        }

        public final Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            if (dimension != null) {
                dimension.width += 5;
            }
            return dimension;
        }
    }

    private final class UnsetBreakpointListener
    extends KeyAdapter {
        private UnsetBreakpointListener() {
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 127) {
                Object[] objectArray = BreakpointList.this.list.getSelectedValues();
                int n = objectArray.length;
                RiderDocument riderDocument = (RiderDocument)BreakpointList.getEditor().getDocument();
                for (int i = 0; i < n; ++i) {
                    riderDocument.toggleBookmark((Element)objectArray[i]);
                }
                keyEvent.consume();
                return;
            }
            if (keyEvent.getKeyCode() == 10) {
                BreakpointList.getEditor().requestFocus();
                keyEvent.consume();
            }
        }
    }
}

