/*
 * Decompiled with CFR 0.152.
 */
package net.wordrider.dialogs.settings;

import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;
import net.wordrider.core.AppPrefs;
import net.wordrider.dialogs.settings.IOptionGroup;
import net.wordrider.dialogs.settings.IOptionable;
import net.wordrider.dialogs.settings.OptionsGroupManager;
import net.wordrider.utilities.Swinger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JTextFieldOption
implements IOptionable<JTextField>,
DocumentListener {
    private final String initValue;
    private String defaultValue;
    private boolean wasChanged = false;
    private final OptionsGroupManager optionsGroupManager;
    private IOptionGroup group = null;
    private String propertyName = null;
    private JTextField field;

    public JTextFieldOption(OptionsGroupManager optionsGroupManager, Document document, String string, String string2, IOptionGroup iOptionGroup) {
        this(optionsGroupManager, document, AppPrefs.getProperty(string, string2), iOptionGroup);
        this.propertyName = string;
        this.defaultValue = string2;
    }

    private JTextFieldOption(OptionsGroupManager optionsGroupManager, Document document, String string, IOptionGroup iOptionGroup) {
        document = document == null ? new PlainDocument() : document;
        this.field = new JTextField(document, string, 0);
        this.initValue = string;
        this.group = iOptionGroup;
        this.optionsGroupManager = optionsGroupManager;
        document.addDocumentListener(this);
        Swinger.addKeyActions(this.field);
    }

    private void updateValue() {
        this.wasChanged = !this.initValue.equals(this.field.getText());
        this.optionsGroupManager.makeChange(this);
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.updateValue();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.updateValue();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.updateValue();
    }

    @Override
    public final void setDefault() {
        this.field.setText(this.defaultValue);
    }

    @Override
    public final void restorePrevious() {
        this.field.setText(this.initValue);
    }

    @Override
    public final boolean wasChanged() {
        return this.wasChanged;
    }

    @Override
    public void applyChange() {
        this.wasChanged = false;
        if (this.propertyName != null) {
            AppPrefs.storeProperty(this.propertyName, this.field.getText());
        }
    }

    @Override
    public final IOptionGroup getOptionsGroup() {
        return this.group;
    }

    public JTextField getComponent() {
        return this.field;
    }
}

