/*
* Copyright (C) 2004 Ladislav Vitasek
* info@wordrider.net
* http://www.wordrider.net
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 2
* of the License, or any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
package net.wordrider.area;

import javax.swing.*;
import java.awt.*;
import java.awt.event.AWTEventListener;
import java.awt.event.MouseEvent;

/**
 * Created by Santhosh Kumar http://www.jroller.com/page/santhosh?entry=enhanced_scrolling_in_swing
 */
final class ScrollGestureRecognizer implements AWTEventListener {
    private static final ScrollGestureRecognizer instance = new ScrollGestureRecognizer();

    private ScrollGestureRecognizer() {
        start();
    }

    public static ScrollGestureRecognizer getInstance() {
        return instance;
    }

    final void start() {
        Toolkit.getDefaultToolkit().addAWTEventListener(this, AWTEvent.MOUSE_EVENT_MASK);
    }

    final void stop() {
        Toolkit.getDefaultToolkit().removeAWTEventListener(this);
    }

    public final void eventDispatched(AWTEvent event) {
        MouseEvent me = (MouseEvent) event;
        boolean isGesture = SwingUtilities.isMiddleMouseButton(me) && me.getID() == MouseEvent.MOUSE_PRESSED;
        if (!isGesture)
            return;

        JViewport viewPort = (JViewport) SwingUtilities.getAncestorOfClass(JViewport.class, me.getComponent());
        if (viewPort == null)
            return;
        JRootPane rootPane = SwingUtilities.getRootPane(viewPort);
        if (rootPane == null)
            return;

        Point location = SwingUtilities.convertPoint(me.getComponent(), me.getPoint(), rootPane.getGlassPane());
        ScrollGlassPane glassPane = new ScrollGlassPane(rootPane.getGlassPane(), viewPort, location);
        rootPane.setGlassPane(glassPane);
        rootPane.setCursor(Cursor.getDefaultCursor());
        glassPane.setVisible(true);
    }
}