/*
* Copyright (C) 2004 Ladislav Vitasek
* info@wordrider.net
* http://www.wordrider.net
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 2
* of the License, or any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
package net.wordrider.core.actions;

import net.wordrider.core.managers.AreaManager;
import net.wordrider.utilities.Utils;

import javax.swing.*;
import java.awt.event.ActionEvent;
import java.io.File;

/**
 * @author Vity
 */
public final class OpenRecentFileAction extends CoreAction {
    private final File recentFile;

    public OpenRecentFileAction(final File file, final char mnemonic) {
        super("OpenRecentFileAction", mnemonic + " " + Utils.shortenFileName(file.toString(), 50), (int) mnemonic, null);
        this.recentFile = file;
        putValue(Action.SHORT_DESCRIPTION, file.toString());
    }

    public final void actionPerformed(final ActionEvent e) {
        SwingUtilities.invokeLater(new Runnable() {
            public void run() {
                final AreaManager areaManager = AreaManager.getInstance();
                if (!OpenFileAction.open(recentFile)) {
                    areaManager.getRecentFilesManager().removeBadFile(recentFile);
                } else areaManager.grabActiveFocus();
            }
        });
    }

}
