/*
* Copyright (C) 2004 Ladislav Vitasek
* info@wordrider.net
* http://www.wordrider.net
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 2
* of the License, or any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
package net.wordrider.core.actions;

import net.wordrider.core.AppPrefs;
import net.wordrider.core.managers.interfaces.IHidAble;

import javax.swing.*;
import java.awt.event.ActionEvent;

/**
 * @author Vity
 */
public final class ToggleToolbarAction extends CoreAction {
    private final static ToggleToolbarAction instance = new ToggleToolbarAction();
    private final static String CODE = "ToggleToolbarAction";
    private JMenuItem menuItem;

    public static ToggleToolbarAction getInstance(final JMenuItem menuItem) {
        instance.menuItem = menuItem;
        menuItem.setSelected(AppPrefs.getProperty("net.wordrider.gui.showToolbar", true));
        return instance;
    }

    private ToggleToolbarAction() {
        super(CODE, KeyStroke.getKeyStroke("F11"), null);    //call to super
    }

    public final void actionPerformed(final ActionEvent e) {
        final IHidAble hidAble = getManagerDirector().getToolbarManager();
        hidAble.setVisible(!hidAble.isVisible());
        menuItem.setSelected(hidAble.isVisible());
    }
}
