/*
* Copyright (C) 2004 Ladislav Vitasek
* info@wordrider.net
* http://www.wordrider.net
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 2
* of the License, or any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
package net.wordrider.dialogs.pictures.filters;

import java.awt.image.RGBImageFilter;

/**
 * @author Vity
 */
public final class AlphaFilter extends RGBImageFilter {
    public AlphaFilter() {
        super();
        this.canFilterIndexColorModel = true;
    }

    public final int filterRGB(final int x, final int y, final int rgb) {
        if ((rgb & 0xFF) > 0 || rgb == 0)
            return 0x00FFFFFF;
        else
            return rgb;
        //return (rgb << 24) ^ rgb;
        // return rgb;
        //return (rgb & 0x00FFFFFF) | (((rgb & 0xff) ^ 0xFF) << 16);
    }
}
