/*
* Copyright (C) 2004 Ladislav Vitasek
* info@wordrider.net
* http://www.wordrider.net
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 2
* of the License, or any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
package net.wordrider.files.ti68kformat;

import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;

/**
 * @author Vity
 */
public class TITextFileReader extends TIFileReader {

    private String content = null;
    private char contentChecksum;

    public TITextFileReader() {
        this.fileInfo = new TITextFileInfo();
    }

    public final TITextFileInfo getTextFileInfo() {
        return (TITextFileInfo) fileInfo;
    }

    protected void readContent(final DataInputStream stream) throws IOException {
        stream.skipBytes(8); //4x zeroes + 2 content length + 0x00 + 0x1
        int character;
        final StringBuilder buffer = new StringBuilder();
        contentChecksum = 0;
        while (true) {
            character = stream.readUnsignedByte();
            if (character == 0 || character == -1)
                break;
            contentChecksum += character;
            buffer.append((char) character);
        }
        //if (character == 0 || character == -1)
        stream.skipBytes(1);//0xE0
        content = buffer.toString();
    }


    protected String[] getSupportedHeaders() {
        return TIFileConstants.SUPPORTED_FORMATS_TEXT;
    }

    public final String getContent() {
        return content;
    }

    public byte getDataType() {
        return TIFileConstants.DATATYPE_TEXT;
    }

    protected void storeFileInformation(final File file) {
    }

    protected final char getCheckSum() {
        if (content == null) return 0;
        final int length4 = content.length() + 0x4;
        char result = contentChecksum;
        return (char) (result + 0xE0 + 0x1 + ((length4 & 0xff) + ((length4 >> 8) & 0xff)));  //+0x20
    }
}
