/*
* Copyright (C) 2004 Ladislav Vitasek
* info@wordrider.net
* http://www.wordrider.net
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 2
* of the License, or any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
package net.wordrider.gui;

/**
 * @author Vity
 */
public final class LaF {
    private final String className;
    private final String name;
    private final String themeClass;
    private boolean toolbarOpaque = true;

    public LaF(final String className, final String name, final String themeClass, final boolean toolbarOpaque) {
        this.className = className;
        this.name = name;
        this.themeClass = themeClass;
        this.toolbarOpaque = toolbarOpaque;
    }

    public final String getClassName() {
        return className;
    }

    public final String getName() {
        return name;
    }

    public final String getThemeClass() {
        return themeClass;
    }

    public final boolean isToolbarOpaque() {
        return toolbarOpaque;
    }

    public final boolean equals(final Object obj) {
        return obj instanceof LaF && equals((LaF) obj);
    }

    public final boolean equals(final LaF obj) {
        if (className.equals(obj.getClassName()))
            if (themeClass != null)
                return themeClass.equals(obj.getThemeClass());
            else
                return (obj.getThemeClass() == null);
        return false;
    }

    public final String toString() {
        return this.getName();
    }
}
