/*
* Copyright (C) 2004 Ladislav Vitasek
* info@wordrider.net
* http://www.wordrider.net
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 2
* of the License, or any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
package net.wordrider.gui;

import javax.swing.*;
import javax.swing.plaf.ComponentUI;
import java.awt.*;

@SuppressWarnings({"WeakerAccess"})
public final class ToolbarSeparatorUI extends javax.swing.plaf.basic.BasicToolBarSeparatorUI {
    private ToolbarSeparatorUI() {
        shadow = UIManager.getColor("controlDkShadow");
        highlight = UIManager.getColor("controlLtHighlight");
    }

    public static ComponentUI createUI(JComponent c) {
        c = null;//must be
        return new ToolbarSeparatorUI();
    }

    public final void paint(final Graphics g, final JComponent c) {
        final Dimension s = c.getSize();
        final int sWidth = s.width / 2;

        g.setColor(shadow);
        g.drawLine(sWidth, 0, sWidth, s.height);

        g.setColor(highlight);
        g.drawLine(sWidth + 1, 0, sWidth + 1, s.height);
    }
}

