/*
* Copyright (C) 2004 Ladislav Vitasek
* info@wordrider.net
* http://www.wordrider.net
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 2
* of the License, or any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
package net.wordrider.utilities;

public final class Consts {
    //public static int LOG_SEVERITY = Utils.WARN_LOG;

    public static final String APPVERSION = "WordRider 0.8 alpha 3 preview";

    public static final int DEFAULT_RECENT_FILES_MAX_COUNT = 7;
    public static final int DEFAULT_TAB_SIZE = 4;
    public static final int ONE_INSTANCE_SERVER_PORT = 35139;
    public static final String WEBURL = "http://wordrider.net";
    public static final String WEBURL_HELP_PARAMS = "http://wordrider.net/documentation.html#params";
    public static final String WEBMAIL = "info@wordrider.net";
    public static final String WEBMAILCMD = "mailto:" + WEBMAIL;
    private static final String RESOURCESDIR = "resources/";
    public static final String IMAGESDIR = RESOURCESDIR + "images/";
    public static final String FONTDIR = RESOURCESDIR + "fonts/";
    public static final String LANGUAGESDIR = RESOURCESDIR + "languages/";
    public static final String SOUNDSDIR = RESOURCESDIR + "sound/";
    public static final String LINE_SEPARATOR = "\n";
    public static final String LAFSDIRFILE = RESOURCESDIR + "lookandfeels/lookandfeels.properties";

    public static final String WEBURL_CHECKNEWVERSION = "http://wordrider.net/check.php";

    public static final String TI_CONNECT_PATH = "C:\\Program Files\\TI Education\\TI Connect\\TISendTo.exe";
    public static final String TILP_WINDOWS = "C:\\Program Files\\TiLP-2\\tilp2.exe";
    public static final String TILP_LINUX = "/usr/tilp2/tilp2";

    public static final int XOR_VALUE = 35132;
    public final static int MAX_RECENT_PHRASES_COUNT = 5;

    public static final String LOGDEBUG = RESOURCESDIR + "logdebug.properties";
    public static final String LOGDEFAULT = RESOURCESDIR + "logdefault.properties";
    public static final String PDF_DIRECTORY = "help";
    public static final String QUICK_REF_PDF = "quickref.pdf";
    public static final String ONLINE_TUTORIAL = WEBURL + "/download.php?file=swf/WordRider/WordRider.html";
    public static final String ONLINE_DOCUMENTATION = WEBURL + "/documentation.html";
    public static final String SAMPLE_FILE = "sample/riderhlp.89t";
    public static final String DEFAULT_VARNAME = "untitled";
    public static final String DEFAULT_FOLDERNAME = "main";

    private Consts() {

    }
}
