/*
 * Decompiled with CFR 0.152.
 */
package net.wordrider.area;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.Stroke;
import java.io.IOException;
import java.io.InputStream;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Logger;
import javax.swing.text.AttributeSet;
import javax.swing.text.Element;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import net.wordrider.area.AreaImage;
import net.wordrider.area.ColorStyles;
import net.wordrider.area.SeparatorLine;
import net.wordrider.utilities.LogUtils;

public final class RiderStyles {
    public static final String TI89MAXLENGTHSTRING = "01234567890123456789012345";
    public static final String TI92MAXLENGTHSTRING = "0123456789012345678901234567890123456789";
    public static final Stroke DOTTED_STROKE = new BasicStroke(1.0f, 1, 1, 1.0f, new float[]{2.0f}, 0.0f);
    private static final String STYLE_INVERTED = "INVERT";
    private static final String STYLE_UNDERLINEDOTTED = "UNDERLINEDOTTED";
    public static final String STYLE_BOOKMARK = "BOOKMARK";
    private static final String STYLE_VECTOR = "VECTOR";
    private static final String STYLE_CONJUGATE = "CONJUGATE";
    private static final String STYLE_MATH = "MATH";
    private static final String STYLE_WORDWRAP = "WORDWRAP";
    public static final String STYLE_ALIGMENT_LEFT = "aligmentLeft";
    public static final String STYLE_ALIGMENT_RIGHT = "aligmentRight";
    public static final String STYLE_ALIGMENT_CENTER = "aligmentCenter";
    public static final String STYLE_FONT_MINI = "miniSize";
    public static final String STYLE_FONT_NORMAL = "normalSize";
    public static final String STYLE_FONT_MAXI = "maxiSize";
    public static final String STYLE_MARGIN10 = "margin10";
    public static final String STYLE_MARGIN20 = "margin20";
    public static final String STYLE_MARGIN30 = "margin30";
    public static final int ALIGN_LEFT = 0;
    public static final int ALIGN_RIGHT = 2;
    public static final int ALIGN_CENTER = 1;
    public static final int SIZE_MINI = 11;
    public static final int SIZE_NORMAL = 13;
    public static final int SIZE_MAXI = 16;
    public static final int MARGIN_0 = 0;
    public static final int MARGIN_10 = 10;
    public static final int MARGIN_20 = 20;
    public static final int MARGIN_30 = 30;
    private static final int MAX_MARGIN_X = 240;
    public static final int SINGLE_LINE = 0;
    public static final int DOUBLE_LINE = 1;
    public static final int EMPTY_LINE = 10;
    public static final String FONT_NAME = "Ti-92p.ttf";
    public static final String FONT_FAMILY = "Ti92Pluspc";
    private static final Font font = RiderStyles.readDefaultFont();
    private static final Font maxiFont = font.deriveFont(1, 15.0f);
    public static final Font maxiFontNoBold = maxiFont.deriveFont(0);
    public static Style normalStyle;
    public static Style miniStyle;
    public static Style maxiStyle;
    private static Style superscriptStyle;
    private static Style subscriptStyle;
    public static Style margin10Style;
    public static Style margin20Style;
    public static Style margin30Style;
    public static Style alignmentLeftStyle;
    public static Style alignmentRightStyle;
    public static Style alignmentCenteredStyle;
    private static Style underlineStyle;
    private static Style strikethroughStyle;
    private static Style underlineDottedStyle;
    private static Style basicStyle;
    private static Style invertStyle;
    public static Style mathStyle;
    private static Style vectorStyle;
    private static Style conjugateStyle;
    private static Style wordwrapStyle;
    public static SimpleAttributeSet bookmarkStyle;
    private static StyleContext styleContext;
    public static final byte P_UNDERLINE = 0;
    public static final byte P_VECTOR = 1;
    public static final byte P_INVERT = 2;
    public static final byte P_UNDERLINE_DOTTED = 3;
    public static final byte P_STRIKETHROUGHT = 4;
    public static final byte P_EXPOSANT = 5;
    public static final byte P_WORDWRAP = 6;
    public static final byte P_CONJUGATE = 7;
    public static final byte P_SUBSCRIPT = 8;
    private static final Object[] ATTRIBUTE_NAMES;
    private static final Set<Integer> aditionalMarginX;
    private static final Logger logger;

    private RiderStyles() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Font readDefaultFont() {
        Font font = new Font(FONT_FAMILY, 0, 13);
        if (font.getFamily().equalsIgnoreCase(FONT_FAMILY)) {
            return font;
        }
        InputStream inputStream = null;
        try {
            inputStream = RiderStyles.class.getClassLoader().getResourceAsStream("resources/fonts/Ti-92p.ttf");
            if (inputStream != null) {
                font = Font.createFont(0, inputStream).deriveFont(0, 13.0f);
            }
        }
        catch (FontFormatException fontFormatException) {
            LogUtils.processException(logger, fontFormatException);
        }
        catch (IOException iOException) {
            LogUtils.processException(logger, iOException);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {
                LogUtils.processException(logger, iOException);
            }
        }
        return font;
    }

    public static boolean isCorrectFont() {
        return font.getFamily().equalsIgnoreCase(FONT_FAMILY);
    }

    private static StyleContext createDefaultStyles(StyleContext styleContext) {
        Style style = styleContext.getStyle("default");
        StyleConstants.setFontFamily(style, font.getFamily());
        StyleConstants.setFontSize(style, 13);
        basicStyle = styleContext.addStyle("basic", null);
        StyleConstants.setFontFamily(basicStyle, font.getFamily());
        normalStyle = styleContext.addStyle(STYLE_FONT_NORMAL, basicStyle);
        StyleConstants.setFontSize(normalStyle, 13);
        StyleConstants.setBold(normalStyle, false);
        miniStyle = styleContext.addStyle(STYLE_FONT_MINI, basicStyle);
        StyleConstants.setFontSize(miniStyle, 11);
        StyleConstants.setBold(miniStyle, false);
        maxiStyle = styleContext.addStyle(STYLE_FONT_MAXI, basicStyle);
        StyleConstants.setFontSize(maxiStyle, 16);
        StyleConstants.setBold(maxiStyle, true);
        StyleConstants.setSuperscript(maxiStyle, false);
        superscriptStyle = styleContext.addStyle("superscript", miniStyle);
        StyleConstants.setSuperscript(superscriptStyle, true);
        StyleConstants.setSubscript(superscriptStyle, false);
        subscriptStyle = styleContext.addStyle("subscript", miniStyle);
        StyleConstants.setSubscript(subscriptStyle, true);
        StyleConstants.setSuperscript(subscriptStyle, false);
        alignmentLeftStyle = styleContext.addStyle(STYLE_ALIGMENT_LEFT, basicStyle);
        StyleConstants.setLeftIndent(alignmentLeftStyle, 0.0f);
        StyleConstants.setAlignment(alignmentLeftStyle, 0);
        alignmentRightStyle = styleContext.addStyle(STYLE_ALIGMENT_RIGHT, alignmentLeftStyle);
        StyleConstants.setAlignment(alignmentRightStyle, 2);
        StyleConstants.setLeftIndent(alignmentRightStyle, 0.0f);
        alignmentCenteredStyle = styleContext.addStyle(STYLE_ALIGMENT_CENTER, alignmentLeftStyle);
        StyleConstants.setAlignment(alignmentCenteredStyle, 1);
        StyleConstants.setLeftIndent(alignmentCenteredStyle, 0.0f);
        margin10Style = styleContext.addStyle(STYLE_MARGIN10, alignmentLeftStyle);
        StyleConstants.setLeftIndent(margin10Style, 10.0f);
        StyleConstants.setAlignment(margin10Style, 0);
        margin20Style = styleContext.addStyle(STYLE_MARGIN20, alignmentLeftStyle);
        StyleConstants.setLeftIndent(margin20Style, 20.0f);
        StyleConstants.setAlignment(margin20Style, 0);
        margin30Style = styleContext.addStyle(STYLE_MARGIN30, alignmentLeftStyle);
        StyleConstants.setLeftIndent(margin30Style, 30.0f);
        StyleConstants.setAlignment(margin30Style, 0);
        underlineStyle = styleContext.addStyle("underline", alignmentLeftStyle);
        StyleConstants.setUnderline(underlineStyle, true);
        strikethroughStyle = styleContext.addStyle("strikethrough", basicStyle);
        StyleConstants.setStrikeThrough(strikethroughStyle, true);
        underlineDottedStyle = styleContext.addStyle("underlineDotted", basicStyle);
        StyleConstants.setUnderline(underlineDottedStyle, false);
        RiderStyles.setProperty(underlineDottedStyle, STYLE_UNDERLINEDOTTED);
        invertStyle = styleContext.addStyle("invert", basicStyle);
        RiderStyles.setProperty(invertStyle, STYLE_INVERTED);
        mathStyle = styleContext.addStyle("math", normalStyle);
        RiderStyles.setProperty(mathStyle, STYLE_MATH);
        mathStyle.addAttributes(alignmentLeftStyle);
        vectorStyle = styleContext.addStyle("vector", basicStyle);
        RiderStyles.setProperty(vectorStyle, STYLE_VECTOR);
        RiderStyles.setProperty(vectorStyle, STYLE_CONJUGATE, false);
        conjugateStyle = styleContext.addStyle("conjugate", basicStyle);
        RiderStyles.setProperty(conjugateStyle, STYLE_CONJUGATE);
        RiderStyles.setProperty(conjugateStyle, STYLE_VECTOR, false);
        wordwrapStyle = styleContext.addStyle("wordwrap", wordwrapStyle);
        RiderStyles.setProperty(wordwrapStyle, STYLE_WORDWRAP);
        bookmarkStyle = new SimpleAttributeSet();
        RiderStyles.updateColorsForStyles(styleContext);
        return styleContext;
    }

    private static void updateColorsForStyles(StyleContext styleContext) {
        if (RiderStyles.styleContext == null) {
            return;
        }
        Style style = styleContext.getStyle("default");
        Color color = ColorStyles.getColor(0);
        Color color2 = ColorStyles.getColor(1);
        StyleConstants.setForeground(style, color);
        StyleConstants.setBackground(style, color2);
        StyleConstants.setForeground(basicStyle, color);
        StyleConstants.setBackground(basicStyle, color2);
        StyleConstants.setBackground(invertStyle, color);
        StyleConstants.setForeground(invertStyle, color2);
    }

    public static void updateColorsForStyles() {
        RiderStyles.updateColorsForStyles(styleContext);
    }

    private static MutableAttributeSet setProperty(MutableAttributeSet mutableAttributeSet, Object object, boolean bl) {
        mutableAttributeSet.addAttribute(object, bl);
        return mutableAttributeSet;
    }

    private static void setProperty(MutableAttributeSet mutableAttributeSet, String string) {
        mutableAttributeSet.addAttribute(string, true);
    }

    public static boolean isReadonlySection(Element element) {
        int n = element.getElementCount();
        for (int i = 0; i < n; ++i) {
            String string = element.getElement(i).getName();
            if (!string.equals("component") && !string.equals("icon")) continue;
            return true;
        }
        return false;
    }

    public static boolean isUnderLine(AttributeSet attributeSet) {
        return StyleConstants.isUnderline(attributeSet);
    }

    public static boolean isUnderLineDotted(AttributeSet attributeSet) {
        Object object = attributeSet.getAttribute(STYLE_UNDERLINEDOTTED);
        return object != null && (Boolean)object != false;
    }

    public static boolean isExposant(AttributeSet attributeSet) {
        return StyleConstants.isSuperscript(attributeSet);
    }

    public static boolean isSubscript(AttributeSet attributeSet) {
        return StyleConstants.isSubscript(attributeSet);
    }

    public static boolean isInvert(AttributeSet attributeSet) {
        Object object = attributeSet.getAttribute(STYLE_INVERTED);
        return object != null && (Boolean)object != false;
    }

    public static boolean isVector(AttributeSet attributeSet) {
        Object object = attributeSet.getAttribute(STYLE_VECTOR);
        return object != null && (Boolean)object != false;
    }

    public static boolean isConjugate(AttributeSet attributeSet) {
        Object object = attributeSet.getAttribute(STYLE_CONJUGATE);
        return object != null && (Boolean)object != false;
    }

    public static boolean isSize(AttributeSet attributeSet, int n) {
        return StyleConstants.getFontSize(attributeSet) == n;
    }

    public static boolean isMath(Element element) {
        Object object = element.getAttributes().getAttribute(STYLE_MATH);
        return object != null && (Boolean)object != false;
    }

    public static boolean isStrikeOut(AttributeSet attributeSet) {
        return StyleConstants.isStrikeThrough(attributeSet);
    }

    public static boolean isWordWrap(AttributeSet attributeSet) {
        Object object = attributeSet.getAttribute(STYLE_WORDWRAP);
        return object != null && (Boolean)object != false;
    }

    public static boolean isSupportedComponent(Element element) {
        return element.getName().equals("component") && element.getAttributes().getAttribute(StyleConstants.ComponentAttribute) instanceof SeparatorLine;
    }

    public static boolean isComponentLine(Element element, int n) {
        Object object;
        return element.getName().equals("component") && (object = element.getAttributes().getAttribute(StyleConstants.ComponentAttribute)) instanceof SeparatorLine && ((SeparatorLine)object).getLineType() == n;
    }

    public static AreaImage getImage(Element element) {
        return (AreaImage)element.getAttributes().getAttribute(StyleConstants.IconAttribute);
    }

    public static boolean isImage(Element element) {
        if (element.getName().equals("icon")) {
            Object object = element.getAttributes().getAttribute(StyleConstants.IconAttribute);
            return object != null;
        }
        return false;
    }

    public static boolean isBookmark(Element element) {
        Object object = element.getAttributes().getAttribute(STYLE_BOOKMARK);
        return object != null && object.equals(element);
    }

    public static int getAlignment(AttributeSet attributeSet) {
        return StyleConstants.getAlignment(attributeSet);
    }

    public static short getMargin(AttributeSet attributeSet) {
        return (short)StyleConstants.getLeftIndent(attributeSet);
    }

    public static int getFontSize(AttributeSet attributeSet) {
        return StyleConstants.getFontSize(attributeSet);
    }

    public static Font getAreaFont() {
        return font;
    }

    public static Font getAreaBigFont() {
        return maxiFont;
    }

    public static Style getMarginXStyle(int n) {
        n = Math.min(n, 240);
        String string = "STYLE_MARGINX" + n;
        Style style = styleContext.getStyle(string);
        if (style != null) {
            return style;
        }
        style = styleContext.addStyle(string, alignmentLeftStyle);
        StyleConstants.setLeftIndent(style, n);
        StyleConstants.setAlignment(style, 0);
        aditionalMarginX.add(n);
        return style;
    }

    public static MutableAttributeSet updateVectorAttributes(MutableAttributeSet mutableAttributeSet) {
        return RiderStyles.isVector(mutableAttributeSet) ? RiderStyles.setProperty(new SimpleAttributeSet(), STYLE_VECTOR, false) : vectorStyle;
    }

    public static MutableAttributeSet updateConjugateAttributes(MutableAttributeSet mutableAttributeSet) {
        return RiderStyles.isConjugate(mutableAttributeSet) ? RiderStyles.setProperty(new SimpleAttributeSet(), STYLE_CONJUGATE, false) : conjugateStyle;
    }

    public static MutableAttributeSet updateUnderlineAttributes(MutableAttributeSet mutableAttributeSet) {
        return RiderStyles.isUnderLine(mutableAttributeSet) ? RiderStyles.setProperty(new SimpleAttributeSet(), StyleConstants.Underline, false) : underlineStyle;
    }

    public static MutableAttributeSet flipUnderlineAttributes(MutableAttributeSet mutableAttributeSet) {
        MutableAttributeSet mutableAttributeSet2 = RiderStyles.isUnderLine(mutableAttributeSet) ? RiderStyles.setProperty(new SimpleAttributeSet(), StyleConstants.Underline, false) : new SimpleAttributeSet(underlineStyle.copyAttributes());
        return RiderStyles.setProperty(mutableAttributeSet2, STYLE_UNDERLINEDOTTED, false);
    }

    public static MutableAttributeSet flipUnderlineDottedAttributes(MutableAttributeSet mutableAttributeSet) {
        MutableAttributeSet mutableAttributeSet2 = RiderStyles.isUnderLineDotted(mutableAttributeSet) ? RiderStyles.setProperty(new SimpleAttributeSet(), STYLE_UNDERLINEDOTTED, false) : new SimpleAttributeSet(underlineDottedStyle.copyAttributes());
        StyleConstants.setUnderline(mutableAttributeSet2, false);
        return mutableAttributeSet2;
    }

    public static MutableAttributeSet updateUnderlineDottedAttributes(MutableAttributeSet mutableAttributeSet) {
        return RiderStyles.isUnderLineDotted(mutableAttributeSet) ? RiderStyles.setProperty(new SimpleAttributeSet(), STYLE_UNDERLINEDOTTED, false) : underlineDottedStyle;
    }

    public static MutableAttributeSet updateWordWrapAttributes(MutableAttributeSet mutableAttributeSet) {
        return RiderStyles.isWordWrap(mutableAttributeSet) ? RiderStyles.setProperty(new SimpleAttributeSet(), STYLE_WORDWRAP, false) : wordwrapStyle;
    }

    public static MutableAttributeSet updateInvertAttributes(MutableAttributeSet mutableAttributeSet) {
        return RiderStyles.isInvert(mutableAttributeSet) ? RiderStyles.setProperty(new SimpleAttributeSet(basicStyle), STYLE_INVERTED, false) : invertStyle;
    }

    public static MutableAttributeSet updateStrikedAttributes(MutableAttributeSet mutableAttributeSet) {
        return RiderStyles.isStrikeOut(mutableAttributeSet) ? RiderStyles.setProperty(new SimpleAttributeSet(), StyleConstants.StrikeThrough, false) : strikethroughStyle;
    }

    public static MutableAttributeSet updateExposantAttributes(MutableAttributeSet mutableAttributeSet) {
        return RiderStyles.isExposant(mutableAttributeSet) ? RiderStyles.setProperty(new SimpleAttributeSet(), StyleConstants.Superscript, false) : superscriptStyle;
    }

    public static MutableAttributeSet updateSubscriptAttributes(MutableAttributeSet mutableAttributeSet) {
        return RiderStyles.isSubscript(mutableAttributeSet) ? RiderStyles.setProperty(new SimpleAttributeSet(), StyleConstants.Subscript, false) : subscriptStyle;
    }

    public static MutableAttributeSet updateBookmark(Element element) {
        bookmarkStyle.addAttribute(STYLE_BOOKMARK, element);
        return bookmarkStyle;
    }

    public static StyleContext getDefaultStyleContext() {
        if (styleContext == null) {
            styleContext = new StyleContext();
            return RiderStyles.createDefaultStyles(styleContext);
        }
        return styleContext;
    }

    public static boolean isSet(AttributeSet attributeSet, int n) {
        Object object = attributeSet.getAttribute(ATTRIBUTE_NAMES[n]);
        return object != null && (Boolean)object != false;
    }

    public static Object[] getVariableMargins() {
        return aditionalMarginX.toArray();
    }

    public static boolean isText(Element element) {
        String string = element.getName();
        return string.equals("content") && !string.equals("component") && !string.equals("icon");
    }

    static {
        ATTRIBUTE_NAMES = new Object[]{StyleConstants.Underline, STYLE_VECTOR, STYLE_INVERTED, STYLE_UNDERLINEDOTTED, StyleConstants.StrikeThrough, StyleConstants.Superscript, STYLE_WORDWRAP, STYLE_CONJUGATE, StyleConstants.Subscript};
        aditionalMarginX = new TreeSet<Integer>();
        logger = Logger.getLogger(RiderStyles.class.getName());
    }
}

