/*
 * Decompiled with CFR 0.152.
 */
package net.wordrider.dialogs;

import info.clearthought.layout.TableLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import net.wordrider.core.AppPrefs;
import net.wordrider.core.Lng;
import net.wordrider.core.managers.FileInstance;
import net.wordrider.core.managers.interfaces.IFileInstance;
import net.wordrider.core.swing.CustomLayoutConstraints;
import net.wordrider.dialogs.AppDialog;
import net.wordrider.dialogs.CheckRenderer;
import net.wordrider.dialogs.layouts.EqualsLayout;
import net.wordrider.utilities.LogUtils;
import net.wordrider.utilities.Swinger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CloseDialog<C extends FileInstance>
extends AppDialog {
    private static final Logger logger = Logger.getLogger(CloseDialog.class.getName());
    private JButton btnCancel;
    private JButton btnSave;
    private JButton selectAll;
    private JList list;
    private List<ContentData> listData;
    private final boolean sendFiles;
    private final C active;
    private final JCheckBox checkSort = Swinger.getCheckBox("dialog.close.checkSort");
    private final JCheckBox checkSendWithPictures = Swinger.getCheckBox("dialog.send.checkSendWithPictures", "settings.sendWithPictures", true);

    public CloseDialog(Frame frame, Collection<C> collection) {
        this(frame, collection, null);
    }

    public CloseDialog(Frame frame, Collection<C> collection, C c) {
        super(frame, true);
        this.active = c;
        this.sendFiles = c != null;
        try {
            this.init();
        }
        catch (Exception exception) {
            LogUtils.processException(logger, exception);
        }
        this.prepareData(collection);
        boolean bl = AppPrefs.getProperty("settings.listSort", false);
        this.checkSort.setSelected(bl);
        this.reSort(bl);
        Swinger.centerDialog(frame, this);
        this.setModal(true);
        this.setTitle(this.sendFiles ? Lng.getLabel("dialog.send.title") : Lng.getLabel("dialog.close.title"));
        this.setDefaultCloseOperation(2);
        this.list.setSelectedIndex(0);
        Swinger.inputFocus(this.list);
        this.setVisible(true);
    }

    private void prepareData(Collection<C> collection) {
        this.listData = new ArrayList<ContentData>(collection.size());
        for (FileInstance fileInstance : collection) {
            boolean bl = !this.sendFiles || fileInstance.equals(this.active);
            ContentData contentData = new ContentData(this, fileInstance, bl);
            this.listData.add(contentData);
        }
    }

    @Override
    protected AbstractButton getOkButton() {
        return this.btnSave;
    }

    @Override
    protected AbstractButton getCancelButton() {
        return this.btnCancel;
    }

    public final Collection<C> getReturnList() {
        ArrayList<FileInstance> arrayList = new ArrayList<FileInstance>();
        if (this.result == 1) {
            return arrayList;
        }
        for (ContentData contentData : this.listData) {
            if (!contentData.checked) continue;
            arrayList.add(contentData.item);
        }
        return arrayList;
    }

    private void checkAll(boolean bl) {
        for (ContentData contentData : this.listData) {
            contentData.checked = bl;
        }
    }

    private void toggleChecked(int n) {
        ContentData contentData;
        if (n < 0) {
            return;
        }
        contentData.checked = !(contentData = (ContentData)this.list.getModel().getElementAt(n)).checked;
        Rectangle rectangle = this.list.getCellBounds(n, n);
        this.list.repaint(rectangle);
        if (this.sendFiles) {
            this.updateSaveBtnEnabled();
        }
    }

    private void updateSaveBtnEnabled() {
        this.btnSave.setEnabled(this.isAnyChecked());
    }

    private boolean isAnyChecked() {
        for (ContentData contentData : this.listData) {
            if (!contentData.checked) continue;
            return true;
        }
        return false;
    }

    private void init() {
        TableLayout tableLayout = new TableLayout(new double[]{-1.0}, new double[]{-1.0, -2.0, -2.0});
        tableLayout.setVGap(2);
        Container container = this.getContentPane();
        container.setLayout(tableLayout);
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)this.checkSort, "West");
        if (this.sendFiles) {
            jPanel2.add((Component)this.checkSendWithPictures, "East");
        }
        jPanel.setBorder(BorderFactory.createCompoundBorder(jPanel.getBorder(), BorderFactory.createEmptyBorder(4, 6, 4, 6)));
        JPanel jPanel3 = new JPanel(new EqualsLayout(2, 5));
        JPanel jPanel4 = new JPanel(new EqualsLayout(4, 5));
        jPanel.add((Component)jPanel3, "West");
        jPanel.add((Component)jPanel4, "Center");
        this.list = new JList();
        JScrollPane jScrollPane = new JScrollPane(this.list);
        container.add((Component)jScrollPane, new CustomLayoutConstraints(0, 0));
        container.add((Component)jPanel2, new CustomLayoutConstraints(0, 1));
        this.list.addKeyListener(new MyKeyAdapter());
        this.list.setCellRenderer(new CheckListRenderer());
        this.list.setSelectionMode(0);
        this.list.setBorder(new EmptyBorder(2, 4, 0, 0));
        this.list.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                CloseDialog.this.toggleChecked(CloseDialog.this.list.locationToIndex(mouseEvent.getPoint()));
            }
        });
        container.add((Component)jPanel, new CustomLayoutConstraints(0, 2));
        Insets insets = jPanel.getBorder().getBorderInsets(jPanel);
        Dimension dimension = new Dimension(80, 25);
        SelectAction selectAction = new SelectAction();
        this.selectAll = Swinger.getButton("dialog.close.btnSelectAll");
        this.selectAll.addActionListener(selectAction);
        JButton jButton = Swinger.getButton("dialog.close.btnNone");
        jButton.addActionListener(selectAction);
        this.btnCancel = Swinger.getButton("dialog.close.btnCancel");
        this.btnCancel.setMinimumSize(dimension);
        this.btnSave = Swinger.getButton(this.sendFiles ? "dialog.send.btnSend" : "dialog.close.btnOK");
        this.btnSave.setMinimumSize(dimension);
        ActionButtonsAdapter actionButtonsAdapter = new ActionButtonsAdapter();
        this.btnSave.addActionListener(actionButtonsAdapter);
        this.btnCancel.addActionListener(actionButtonsAdapter);
        this.checkSort.addActionListener(actionButtonsAdapter);
        jPanel3.add(this.selectAll);
        jPanel3.add(jButton);
        jPanel4.add(this.btnSave);
        jPanel4.add(this.btnCancel);
        jPanel.setPreferredSize(new Dimension(this.selectAll.getPreferredSize().width + jButton.getPreferredSize().width + this.btnCancel.getPreferredSize().width * 2 + 70, dimension.height + insets.top + insets.bottom + 5));
        jScrollPane.setPreferredSize(new Dimension(360, 150));
        this.pack();
    }

    private void reSort(boolean bl) {
        TreeSet<ContentData> treeSet;
        if (bl) {
            treeSet = new TreeSet<ContentData>(new NameComparator());
            treeSet.addAll(this.listData);
        } else {
            treeSet = new TreeSet<ContentData>(this.listData);
        }
        final Object[] objectArray = treeSet.toArray();
        AbstractListModel abstractListModel = new AbstractListModel(){

            public int getSize() {
                return objectArray.length;
            }

            public Object getElementAt(int n) {
                return objectArray[n];
            }
        };
        this.list.setModel(abstractListModel);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class NameComparator
    implements Comparator<ContentData> {
        private NameComparator() {
        }

        @Override
        public int compare(ContentData contentData, ContentData contentData2) {
            return contentData.item.getName().toLowerCase().compareTo(contentData2.item.getName().toLowerCase());
        }
    }

    private final class SelectAction
    implements ActionListener {
        private SelectAction() {
        }

        public final void actionPerformed(ActionEvent actionEvent) {
            CloseDialog.this.checkAll(actionEvent.getSource().equals(CloseDialog.this.selectAll));
            CloseDialog.this.list.repaint();
        }
    }

    private final class MyKeyAdapter
    extends KeyAdapter {
        private MyKeyAdapter() {
        }

        public final void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 32) {
                CloseDialog.this.toggleChecked(CloseDialog.this.list.getSelectedIndex());
            }
        }
    }

    private final class CheckListRenderer
    extends CheckRenderer {
        private CheckListRenderer() {
        }

        public final Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            ContentData contentData = (ContentData)object;
            this.check.setSelected(contentData.checked);
            File file = contentData.item.getFile();
            if (file != null) {
                this.setToolTipText(file.getPath());
            }
            return super.getListCellRendererComponent(jList, contentData.item, n, bl, bl2, contentData.item.getIcon());
        }
    }

    private final class ActionButtonsAdapter
    implements ActionListener {
        private ActionButtonsAdapter() {
        }

        public final void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object.equals(CloseDialog.this.btnSave)) {
                CloseDialog.this.setResult(0);
                AppPrefs.storeProperty("settings.sendWithPictures", CloseDialog.this.checkSendWithPictures.isSelected());
                AppPrefs.storeProperty("settings.listSort", CloseDialog.this.checkSort.isSelected());
                CloseDialog.this.doClose();
            } else if (object.equals(CloseDialog.this.btnCancel)) {
                CloseDialog.this.doClose();
            } else if (object.equals(CloseDialog.this.checkSort)) {
                CloseDialog.this.reSort(CloseDialog.this.checkSort.isSelected());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ContentData
    implements Comparable {
        private C item;
        private boolean checked;
        final /* synthetic */ CloseDialog this$0;

        /*
         * WARNING - Possible parameter corruption
         */
        public ContentData(C c, boolean bl) {
            this.this$0 = (CloseDialog)n;
            this.item = c;
            this.checked = bl;
        }

        public int compareTo(Object object) {
            return ((FileInstance)this.item).compareTo((IFileInstance)((ContentData)object).item);
        }
    }
}

