/*
 * Decompiled with CFR 0.152.
 */
package net.wordrider.dialogs.settings;

import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JLabel;
import javax.swing.SpinnerNumberModel;
import net.wordrider.core.AppPrefs;
import net.wordrider.core.Lng;
import net.wordrider.core.managers.AreaManager;
import net.wordrider.core.swing.CustomLayoutConstraints;
import net.wordrider.dialogs.settings.CheckBoxOption;
import net.wordrider.dialogs.settings.ComboBoxOption;
import net.wordrider.dialogs.settings.DefaultOptionsGroup;
import net.wordrider.dialogs.settings.SettingsDialog;
import net.wordrider.dialogs.settings.SettingsPanel;
import net.wordrider.dialogs.settings.SpinnerOption;

final class EditorSettingsPanel
extends SettingsPanel {
    public EditorSettingsPanel(SettingsDialog settingsDialog, String string) {
        super(settingsDialog, string);
    }

    protected final void init() {
        DefaultOptionsGroup defaultOptionsGroup = new DefaultOptionsGroup();
        CheckBoxOption checkBoxOption = new CheckBoxOption(this.manager, "settings.dragndrop", "settings.dragndrop", true, defaultOptionsGroup);
        CheckBoxOption checkBoxOption2 = new CheckBoxOption(this.manager, "settings.highlightline", "settings.linehighlight", true, defaultOptionsGroup){

            public void applyChange() {
                super.applyChange();
                AreaManager.getInstance().updateHighlightCurrentLine();
            }
        };
        CheckBoxOption checkBoxOption3 = new CheckBoxOption(this.manager, "settings.bracketMatching", "settings.matchBrackets", true, defaultOptionsGroup){

            public void applyChange() {
                super.applyChange();
                AreaManager.getInstance().updateBracketMatching();
            }
        };
        final CheckBoxOption checkBoxOption4 = new CheckBoxOption(this.manager, "settings.bracketMatchMath", "settings.matchbracketmath", true, defaultOptionsGroup);
        checkBoxOption3.getComponent().addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                checkBoxOption4.getComponent().setEnabled(((AbstractButton)itemEvent.getItem()).isSelected());
            }
        });
        checkBoxOption4.getComponent().setEnabled(checkBoxOption3.getComponent().isSelected());
        CheckBoxOption checkBoxOption5 = new CheckBoxOption(this.manager, "settings.altmenu", "settings.altmenu", false, defaultOptionsGroup);
        JLabel jLabel = new JLabel(Lng.getLabel("settings.emulation"));
        JLabel jLabel2 = new JLabel(Lng.getLabel("settings.tabsize"));
        Object[] objectArray = new Object[]{new ViewWidth(0), new ViewWidth(1), new ViewWidth(2)};
        DefaultComboBoxModel<Object> defaultComboBoxModel = new DefaultComboBoxModel<Object>(objectArray);
        defaultComboBoxModel.setSelectedItem(new ViewWidth(AppPrefs.getProperty("settings.emulation", 0)));
        ComboBoxOption comboBoxOption = new ComboBoxOption(this.manager, defaultComboBoxModel, defaultOptionsGroup){

            public void applyChange() {
                super.applyChange();
                AppPrefs.storeProperty("settings.emulation", ((ViewWidth)this.getComponent().getSelectedItem()).getViewWidthValue());
            }
        };
        Dimension dimension = comboBoxOption.getComponent().getPreferredSize();
        dimension.height = 23;
        comboBoxOption.getComponent().setPreferredSize(dimension);
        comboBoxOption.getComponent().setMaximumSize(new Dimension(80, 23));
        jLabel.setLabelFor(comboBoxOption.getComponent());
        SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel();
        spinnerNumberModel.setValue(new Integer(AppPrefs.getProperty("settings.tabsize", 4)));
        spinnerNumberModel.setMaximum(Integer.valueOf(20));
        spinnerNumberModel.setMinimum(Integer.valueOf(0));
        SpinnerOption spinnerOption = new SpinnerOption(this.manager, spinnerNumberModel, defaultOptionsGroup){

            public void applyChange() {
                super.applyChange();
                AppPrefs.storeProperty("settings.tabsize", this.getComponent().getValue().toString());
            }
        };
        spinnerOption.setDefaultValue(4);
        spinnerOption.getComponent().setPreferredSize(new Dimension(60, 23));
        jLabel2.setLabelFor(spinnerOption.getComponent());
        checkBoxOption4.getComponent().setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 25, 0, 0), checkBoxOption4.getComponent().getBorder()));
        TableLayout tableLayout = new TableLayout(new double[]{-2.0, -1.0}, new double[]{-2.0, -2.0, -2.0, -2.0, -2.0, -2.0, 2.0, -2.0});
        tableLayout.setHGap(10);
        tableLayout.setVGap(2);
        this.setLayout(tableLayout);
        this.add((Component)checkBoxOption.getComponent(), new CustomLayoutConstraints(0, 0, 2, 1));
        this.add((Component)checkBoxOption2.getComponent(), new CustomLayoutConstraints(0, 1, 2, 1));
        this.add((Component)checkBoxOption3.getComponent(), new CustomLayoutConstraints(0, 2, 2, 1));
        this.add((Component)checkBoxOption4.getComponent(), new CustomLayoutConstraints(0, 3, 2, 1));
        this.add((Component)checkBoxOption5.getComponent(), new CustomLayoutConstraints(0, 4, 2, 1));
        this.add((Component)jLabel, new CustomLayoutConstraints(0, 5));
        this.add((Component)comboBoxOption.getComponent(), new CustomLayoutConstraints(1, 5, 1, 1, 2, 0));
        this.add((Component)jLabel2, new CustomLayoutConstraints(0, 7));
        this.add((Component)spinnerOption.getComponent(), new CustomLayoutConstraints(1, 7, 1, 1, 0, 0));
    }

    private static final class ViewWidth {
        private final Integer value;
        private final String label;

        public ViewWidth(int n) {
            this.value = n;
            switch (n) {
                case 1: {
                    this.label = Lng.getLabel("settings.emulation.ti89");
                    break;
                }
                case 2: {
                    this.label = Lng.getLabel("settings.emulation.ti92");
                    break;
                }
                case 0: {
                    this.label = Lng.getLabel("settings.emulation.fullview");
                    break;
                }
                default: {
                    this.label = Lng.getLabel("not found!");
                }
            }
        }

        public final boolean equals(Object object) {
            return object instanceof ViewWidth && this.value.equals(((ViewWidth)object).getViewWidthValue());
        }

        public final Integer getViewWidthValue() {
            return this.value;
        }

        public final String toString() {
            return this.label;
        }
    }
}

