/*
 * Decompiled with CFR 0.152.
 */
package net.wordrider.area;

import java.awt.Color;
import javax.swing.UIManager;
import javax.swing.text.JTextComponent;
import net.wordrider.area.RiderDocument;
import net.wordrider.core.MainApp;
import net.wordrider.core.managers.FileInstance;
import net.wordrider.core.managers.interfaces.IFileInstance;
import net.wordrider.utilities.Swinger;

public final class ColorStyles {
    public static final int COLOR_AREA_FG = 0;
    public static final int COLOR_AREA_BG = 1;
    public static final int COLOR_MATH_STYLE = 2;
    public static final int COLOR_LINE_COLOR = 3;
    public static final int COLOR_BORDER_LINE_COLOR = 4;
    public static final int COLOR_HIGHLIGHT_LINE = 5;
    public static final int COLOR_BRACKET_MATCH = 6;
    public static final int COLOR_BRACKET_MISMATCH = 7;
    public static final int COLOR_TEXT_NOTFOCUSED = 8;
    public static final int COLOR_HIGHLIGHT_FOUND = 9;
    private static final int COLORS_COUNT = 10;
    private static final String[] COLOR_CODES = new String[]{"color.fgArea", "color.bgArea", "color.fgMathstyle", "color.editorline", "color.borderline", "color.lineHighlight", "color.bracketMatch", "color.bracketMMatch", "color.inactivetext", "color.highlightFound"};
    private static final Color LINE_COLOR = new Color(255, 255, 215);
    private static final Color BRACKET_MATCH_COLOR = new Color(153, 204, 255);
    private static final Color BRACKET_MMATCH_COLOR = new Color(255, 220, 220);
    private static final Color NOTFOCUSED_TEXT_COLOR = new Color(230, 230, 210);
    private static final Color[] colors = ColorStyles.initColors();
    private static Color borderColor = null;

    private ColorStyles() {
    }

    private static Color[] initColors() {
        Color[] colorArray = new Color[]{Swinger.getColor(COLOR_CODES[0], Color.BLACK), Swinger.getColor(COLOR_CODES[1], Color.WHITE), Swinger.getColor(COLOR_CODES[2], Color.BLUE), Swinger.getColor(COLOR_CODES[3], Color.GRAY), Swinger.getColor(COLOR_CODES[4], Color.GRAY), Swinger.getColor(COLOR_CODES[5], LINE_COLOR), Swinger.getColor(COLOR_CODES[6], BRACKET_MATCH_COLOR), Swinger.getColor(COLOR_CODES[7], BRACKET_MMATCH_COLOR), Swinger.getColor(COLOR_CODES[8], NOTFOCUSED_TEXT_COLOR), Swinger.getColor(COLOR_CODES[9], Color.YELLOW)};
        return colorArray;
    }

    public static Color getDefaultColor(int n) {
        switch (n) {
            case 0: {
                return Color.BLACK;
            }
            case 1: {
                return Color.WHITE;
            }
            case 2: {
                return Color.BLUE;
            }
            case 3: {
                return Color.GRAY;
            }
            case 4: {
                return Color.GRAY;
            }
            case 5: {
                return LINE_COLOR;
            }
            case 6: {
                return BRACKET_MATCH_COLOR;
            }
            case 7: {
                return BRACKET_MMATCH_COLOR;
            }
            case 9: {
                return Color.YELLOW;
            }
        }
        throw new IllegalArgumentException("invalid color");
    }

    public static void setColor(int n, Color color) {
        ColorStyles.colors[n] = color;
    }

    public static Color getColor(int n) {
        return colors[n];
    }

    public static void updateEditorColors() {
        for (FileInstance fileInstance : MainApp.getInstance().getMainAppFrame().getManagerDirector().getAreaManager().getOpenedInstances()) {
            ((RiderDocument)((JTextComponent)((IFileInstance)fileInstance).getRiderArea()).getDocument()).refreshAll();
        }
    }

    public static void updateBorderColor() {
        borderColor = null;
    }

    public static Color getBorderColor() {
        return borderColor == null ? (borderColor = Swinger.getColor("color.bgborder", Swinger.brighter(UIManager.getDefaults().getColor("control")))) : borderColor;
    }

    public static void storeColors() {
        for (int i = 0; i < 10; ++i) {
            Swinger.setColor(COLOR_CODES[i], colors[i]);
        }
    }
}

