/*
 * Decompiled with CFR 0.152.
 */
package net.wordrider.area.actions;

import java.awt.event.ActionEvent;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.Utilities;
import net.wordrider.area.RiderEditorKit;
import net.wordrider.utilities.LogUtils;

abstract class WordAction
extends AbstractAction {
    int caretPosition;
    JTextComponent textArea = null;
    private static final Logger logger = Logger.getLogger(WordAction.class.getName());
    static final int NO_WORD_AVAILABLE = -100;

    protected WordAction(String string) {
        super(string);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.textArea = (JTextComponent)actionEvent.getSource();
        this.caretPosition = this.textArea.getCaretPosition();
    }

    final JTextComponent getTextArea() {
        return this.textArea;
    }

    final int getWordInDirection(int n) {
        if (this.textArea != null) {
            String string;
            Element element = Utilities.getParagraphElement(this.textArea, this.caretPosition);
            int n2 = element.getStartOffset();
            try {
                string = element.getDocument().getText(n2, element.getEndOffset() - n2);
            }
            catch (BadLocationException badLocationException) {
                LogUtils.processException(logger, badLocationException);
                return -100;
            }
            return n == 1 ? WordAction.getPrevWord(this.textArea, this.caretPosition, n2, string) : WordAction.getNextWord(this.textArea, this.caretPosition, n2, string);
        }
        return -100;
    }

    private static int getPrevWord(JTextComponent jTextComponent, int n, int n2, String string) {
        if ((n -= n2) <= 0) {
            if (n2 == 0) {
                jTextComponent.getToolkit().beep();
                return -100;
            }
            return n2 + --n;
        }
        --n;
        int n3 = 1;
        while (n >= 0) {
            char c = string.charAt(n);
            switch (n3) {
                case 1: {
                    if (c == ' ') {
                        n3 = 1;
                        break;
                    }
                    if (WordAction.isWordSeparator(c)) {
                        n3 = 5;
                        break;
                    }
                    n3 = 4;
                    break;
                }
                case 4: {
                    if (RiderEditorKit.WORD_SEPARATORS.get(c)) {
                        n3 = 3;
                        break;
                    }
                    n3 = 4;
                    break;
                }
                case 5: {
                    if (WordAction.isWordSeparator(c)) {
                        n3 = 5;
                        break;
                    }
                    n3 = 3;
                    break;
                }
                case 3: {
                    break;
                }
            }
            if (n3 == 3) break;
            --n;
        }
        return n2 + ++n;
    }

    private static int getNextWord(JTextComponent jTextComponent, int n, int n2, String string) {
        int n3 = string.length();
        if ((n -= n2) + 1 >= n3) {
            if (n2 + n == jTextComponent.getDocument().getLength()) {
                jTextComponent.getToolkit().beep();
                return -100;
            }
            return n2 + ++n;
        }
        int n4 = 1;
        while (n < n3 - 1) {
            char c = string.charAt(n);
            switch (n4) {
                case 1: {
                    if (c == ' ') {
                        n4 = 2;
                        break;
                    }
                    if (WordAction.isWordSeparator(c)) {
                        n4 = 5;
                        break;
                    }
                    n4 = 4;
                    break;
                }
                case 2: {
                    if (c == ' ') {
                        n4 = 2;
                        break;
                    }
                    n4 = 3;
                    break;
                }
                case 4: {
                    if (c == ' ') {
                        n4 = 2;
                        break;
                    }
                    if (WordAction.isWordSeparator(c)) {
                        n4 = 3;
                        break;
                    }
                    n4 = 4;
                    break;
                }
                case 5: {
                    if (WordAction.isWordSeparator(c)) {
                        n4 = 5;
                        break;
                    }
                    if (c == ' ') {
                        n4 = 2;
                        break;
                    }
                    n4 = 3;
                    break;
                }
                case 3: {
                    break;
                }
            }
            if (n4 == 3) break;
            ++n;
        }
        return n2 + n;
    }

    private static boolean isWordSeparator(char c) {
        return c != ' ' && RiderEditorKit.WORD_SEPARATORS.get(c);
    }
}

