/*
 * Decompiled with CFR 0.152.
 */
package net.wordrider.core.actions;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.logging.Logger;
import javax.swing.JFrame;
import javax.swing.KeyStroke;
import net.wordrider.core.AppPrefs;
import net.wordrider.core.Lng;
import net.wordrider.core.actions.CoreAction;
import net.wordrider.core.actions.SaveFileAction;
import net.wordrider.core.actions.ShowUserSettings;
import net.wordrider.core.managers.AreaManager;
import net.wordrider.core.managers.FileInstance;
import net.wordrider.dialogs.CloseDialog;
import net.wordrider.utilities.LogUtils;
import net.wordrider.utilities.Swinger;
import net.wordrider.utilities.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SendToCalcAction
extends CoreAction {
    private static final SendToCalcAction instance = new SendToCalcAction();
    private static final String CODE = "SendToCalcAction";
    public static final int TI_CONNECT = 1;
    public static final int TILP = 2;
    private static final Logger logger = Logger.getLogger(SendToCalcAction.class.getName());

    private SendToCalcAction() {
        super(CODE, KeyStroke.getKeyStroke(83, 10), null);
    }

    public static int getMethodSelected() {
        int n = AppPrefs.getProperty("settings.sendMethod", Utils.isWindows() ? 1 : 2);
        if (n == 1 && !Utils.isWindows()) {
            return 2;
        }
        return n;
    }

    public static String getDefaultPath(int n) {
        if (n == 1) {
            return AppPrefs.getProperty("settings.ticonnectPath", "C:\\Program Files\\TI Education\\TI Connect\\TISendTo.exe");
        }
        return AppPrefs.getProperty("settings.tilpPath", Utils.isWindows() ? "C:\\Program Files\\TiLP-2\\tilp2.exe" : "/usr/tilp2/tilp2");
    }

    private static File testMethodSelected(int n) {
        File file = new File(SendToCalcAction.getDefaultPath(n));
        if (file.exists() && file.isFile()) {
            return file;
        }
        return null;
    }

    public static SendToCalcAction getInstance() {
        return instance;
    }

    private static boolean sendOpened(int n, File file) {
        AreaManager areaManager = AreaManager.getInstance();
        Collection collection = areaManager.getOpenedInstances();
        if (collection.isEmpty()) {
            return true;
        }
        JFrame jFrame = SendToCalcAction.getMainFrame();
        CloseDialog<FileInstance> closeDialog = new CloseDialog<FileInstance>((Frame)jFrame, collection, (FileInstance)areaManager.getActiveInstance());
        Collection<FileInstance> collection2 = closeDialog.getReturnList();
        if (collection2.isEmpty()) {
            return true;
        }
        Collection<FileInstance> collection3 = areaManager.getModifiedInstances();
        LinkedList<File> linkedList = new LinkedList<File>();
        boolean bl = AppPrefs.getProperty("settings.sendWithPictures", true);
        for (FileInstance fileInstance : collection2) {
            if (!fileInstance.hasAssignedFile() || collection3.contains(fileInstance)) {
                int n2 = Swinger.getButtonsOption(jFrame, new String[]{Lng.getLabel("message.button.save"), Lng.getLabel("message.button.skiptThisFile"), Lng.getLabel("message.button.cancel")}, Lng.getLabel("message.confirm.fileNotSaved", fileInstance.getName()));
                if (n2 == 0) {
                    if (!SaveFileAction.save(false)) {
                        return false;
                    }
                } else {
                    if (n2 == 1) continue;
                    return false;
                }
            }
            if (bl) {
                linkedList.addAll(fileInstance.getRiderArea().getAllPictureFilePaths());
            }
            linkedList.add(fileInstance.getFile());
        }
        SendToCalcAction.sendFiles(n, file, linkedList);
        return true;
    }

    private static void sendFiles(int n, File file, Collection<File> collection) {
        String string;
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(file.getAbsolutePath());
        if (n == 2 && (string = AppPrefs.getProperty("settings.tilpParameters", "")).length() > 0) {
            arrayList.add(string);
        }
        boolean bl = Utils.isWindows();
        for (File comparable2 : collection) {
            if (!comparable2.exists() || !comparable2.isFile()) continue;
            String string2 = comparable2.getAbsolutePath();
            arrayList.add(bl ? "\"" + string2 + "\"" : string2);
        }
        String[] stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        StringBuilder stringBuilder = new StringBuilder();
        for (String string3 : stringArray) {
            stringBuilder.append(string3);
            stringBuilder.append(' ');
        }
        String string4 = stringBuilder.toString();
        logger.info("Sending files to calc command " + string4);
        try {
            Runtime.getRuntime().exec(stringArray);
        }
        catch (IOException iOException) {
            LogUtils.processException(logger, iOException);
            Swinger.showErrorDialog(SendToCalcAction.getMainFrame(), Lng.getLabel("message.error.externProgram", string4));
        }
    }

    @Override
    public final void actionPerformed(ActionEvent actionEvent) {
        int n = SendToCalcAction.getMethodSelected();
        File file = SendToCalcAction.testMethodSelected(n);
        if (file == null) {
            Swinger.showErrorDialog(SendToCalcAction.getMainFrame(), Lng.getLabel("message.error.externProgramMissing"));
            ShowUserSettings.getInstance().setUpSendMethod();
            n = SendToCalcAction.getMethodSelected();
            file = SendToCalcAction.testMethodSelected(n);
        }
        if (file == null) {
            return;
        }
        SendToCalcAction.sendOpened(n, file);
    }
}

