/*
 * Decompiled with CFR 0.152.
 */
package net.wordrider.core.managers;

import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.Utilities;
import net.wordrider.core.AppPrefs;
import net.wordrider.core.Lng;
import net.wordrider.core.managers.AreaChangeEvent;
import net.wordrider.core.managers.AreaManager;
import net.wordrider.core.managers.FileInstance;
import net.wordrider.core.managers.InstanceEvent;
import net.wordrider.core.managers.interfaces.IAreaChangeListener;
import net.wordrider.core.managers.interfaces.IFileInstance;
import net.wordrider.core.managers.interfaces.IHidAble;
import net.wordrider.core.managers.interfaces.IRiderManager;
import net.wordrider.core.managers.interfaces.InstanceListener;
import net.wordrider.core.swing.CustomLayoutConstraints;
import net.wordrider.utilities.LogUtils;
import net.wordrider.utilities.Utils;

public final class StatusbarManager
implements IRiderManager,
CaretListener,
IAreaChangeListener,
PropertyChangeListener,
IHidAble,
InstanceListener {
    private final JPanel statusPanel;
    private static final String LINE_PROPERTY = "linePosition";
    private static final String OVERTYPE_PROPERTY = "overtype";
    private JTextComponent editor;
    private final Map<String, PanelItem> subSections = new LinkedHashMap<String, PanelItem>(9);
    private static final Font font = new Font("SansSerif", 0, 11);
    private static final Logger logger = Logger.getLogger(StatusbarManager.class.getName());

    public StatusbarManager() {
        this.statusPanel = new JPanel();
        this.statusPanel.setSize(new Dimension(10, 16));
        this.statusPanel.setPreferredSize(new Dimension(10, 16));
        this.statusPanel.setVisible(AppPrefs.getProperty("settings.showStatusbar", true));
        this.init();
    }

    private void init() {
        TableLayout tableLayout = new TableLayout(new double[]{4.0, 300.0, 70.0, 70.0, -1.0, 60.0, 60.0, -1.0, 35.0, 30.0, 10.0}, new double[]{-2.0});
        tableLayout.setHGap(4);
        tableLayout.setVGap(2);
        this.statusPanel.setLayout(tableLayout);
        this.addSection("fileName", "", "");
        this.addSection("line", Lng.getLabel("statusbar.linenumber"), Lng.getLabel("statusbar.hint.linePosition"));
        this.addSection("column", Lng.getLabel("statusbar.column"), Lng.getLabel("statusbar.hint.columnPosition"));
        this.addSeparator("Separator1");
        this.addSection(OVERTYPE_PROPERTY, "", Lng.getLabel("statusbar.hint.overtype"));
        this.addSection("modified", "", Lng.getLabel("statusbar.hint.modified"));
        this.addSeparator("Separator2");
        this.addSection("capslock", "", Lng.getLabel("statusbar.hint.capslock"));
        this.addSection("numlock", "", Lng.getLabel("statusbar.hint.numlock"));
    }

    private void addSeparator(String string) {
        this.addSection(string, "", null);
    }

    private void addSection(String string, String string2, String string3) {
        PanelItem panelItem = new PanelItem(string2, string3, false);
        this.subSections.put(string, panelItem);
        panelItem.getComponent().setVisible(false);
        this.statusPanel.add(panelItem.getComponent(), new CustomLayoutConstraints(this.subSections.size(), 0));
    }

    private void display(String string, String string2) {
        PanelItem panelItem = this.subSections.get(string);
        panelItem.setOptionalLabel(string2);
    }

    private void display(String string, String string2, String string3) {
        PanelItem panelItem = this.subSections.get(string);
        panelItem.setOptionalLabel(string2, string3);
    }

    private void clear(boolean bl) {
        Collection<PanelItem> collection = this.subSections.values();
        for (PanelItem panelItem : collection) {
            panelItem.setVisible(bl);
        }
    }

    private void displayFilePath(IFileInstance iFileInstance) {
        String string = !iFileInstance.hasAssignedFile() ? Lng.getLabel("statusbar.notsaved") : iFileInstance.getFile().getAbsolutePath();
        this.display("fileName", Utils.shortenFileName(string, 50), string);
    }

    private void displayOvertype(boolean bl) {
        this.display(OVERTYPE_PROPERTY, bl ? Lng.getLabel("statusbar.rewrite") : Lng.getLabel("statusbar.insert"));
    }

    public void instanceModifiedStatusChanged(InstanceEvent instanceEvent) {
        this.displayModified(instanceEvent.getInstance().isModified());
    }

    public void fileAssigned(InstanceEvent instanceEvent) {
        this.displayFilePath(instanceEvent.getInstance());
    }

    public final Component getManagerComponent() {
        return this.statusPanel;
    }

    private void setCaretColumn(int n) {
        int n2 = 0;
        if (n != 0) {
            try {
                n2 = n - Utilities.getRowStart(this.editor, n);
            }
            catch (BadLocationException badLocationException) {
                LogUtils.processException(logger, badLocationException);
            }
        }
        this.display("column", String.valueOf(n2 + 1));
    }

    public final void caretUpdate(final CaretEvent caretEvent) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (caretEvent.getSource().equals(StatusbarManager.this.editor)) {
                    StatusbarManager.this.setCaretColumn(StatusbarManager.this.editor.getCaretPosition());
                }
            }
        });
    }

    private void displayLineNumber(String string) {
        this.display("line", string);
    }

    private void displayModified(boolean bl) {
        this.display("modified", bl ? Lng.getLabel("statusbar.modified") : "");
    }

    public final void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals(LINE_PROPERTY)) {
            this.displayLineNumber(propertyChangeEvent.getNewValue().toString());
        } else if (propertyChangeEvent.getPropertyName().equals(OVERTYPE_PROPERTY)) {
            this.displayOvertype((Boolean)propertyChangeEvent.getNewValue());
        }
    }

    public final void specialKeyStatusChanged() {
        this.display("capslock", StatusbarManager.getKeyStatus(20) ? Lng.getLabel("statusbar.caps") : "");
        this.display("numlock", StatusbarManager.getKeyStatus(144) ? Lng.getLabel("statusbar.num") : "");
    }

    private static boolean getKeyStatus(int n) {
        try {
            return Toolkit.getDefaultToolkit().getLockingKeyState(n);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            return false;
        }
    }

    public void areaActivated(AreaChangeEvent areaChangeEvent) {
        if (!this.isVisible()) {
            return;
        }
        if (((AreaManager)areaChangeEvent.getSource()).getOpenedInstanceCount() == 1) {
            this.clear(true);
        }
        IFileInstance iFileInstance = areaChangeEvent.getFileInstance();
        this.displayFilePath(iFileInstance);
        iFileInstance.addInstanceListener(this);
        this.editor = iFileInstance.getRiderArea();
        this.editor.addCaretListener(this);
        this.editor.addPropertyChangeListener(LINE_PROPERTY, this);
        this.editor.addPropertyChangeListener(OVERTYPE_PROPERTY, this);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                StatusbarManager.this.setCaretColumn(StatusbarManager.this.editor.getCaretPosition());
            }
        });
        this.displayLineNumber("1");
        this.displayModified(iFileInstance.isModified());
        this.displayOvertype((Boolean)this.editor.getClientProperty(OVERTYPE_PROPERTY));
        this.specialKeyStatusChanged();
    }

    public void areaDeactivated(AreaChangeEvent areaChangeEvent) {
        if (((AreaManager)areaChangeEvent.getSource()).getOpenedInstanceCount() == 1) {
            this.clear(false);
        }
        areaChangeEvent.getFileInstance().removeInstanceListener(this);
        assert (this.editor != null);
        this.editor.removeCaretListener(this);
        this.editor.removePropertyChangeListener(LINE_PROPERTY, this);
        this.editor.removePropertyChangeListener(OVERTYPE_PROPERTY, this);
        this.editor = null;
    }

    public final boolean isVisible() {
        return this.statusPanel.isVisible();
    }

    public final void setVisible(boolean bl) {
        this.statusPanel.setVisible(bl);
        AreaManager areaManager = AreaManager.getInstance();
        FileInstance fileInstance = (FileInstance)areaManager.getActiveInstance();
        if (bl) {
            if (fileInstance != null) {
                this.areaDeactivated(new AreaChangeEvent(areaManager, fileInstance));
            }
        } else {
            this.areaDeactivated(new AreaChangeEvent(areaManager, fileInstance));
        }
        AppPrefs.storeProperty("settings.showStatusbar", bl);
    }

    private static final class PanelItem {
        private String staticLabel = "";
        private String optionalLabel = "";
        private Component component;
        private boolean separator = false;

        private PanelItem() {
        }

        public PanelItem(String string, String string2, boolean bl) {
            this();
            this.separator = bl;
            this.staticLabel = string;
            JLabel jLabel = new JLabel(this.getComposedText());
            jLabel.setToolTipText(string2);
            this.component = jLabel;
            jLabel.setFont(font);
        }

        public final Component getComponent() {
            return this.component;
        }

        public final String getStaticLabel() {
            return this.staticLabel;
        }

        public final String getOptionalLabel() {
            return this.optionalLabel;
        }

        public final boolean isSeparator() {
            return this.separator;
        }

        public final void setOptionalLabel(String string, String string2) {
            this.optionalLabel = string;
            JLabel jLabel = (JLabel)this.component;
            jLabel.setText(this.getComposedText());
            jLabel.setToolTipText(string2);
        }

        public final void setOptionalLabel(String string) {
            this.optionalLabel = string;
            ((JLabel)this.component).setText(this.getComposedText());
        }

        private String getComposedText() {
            return this.getStaticLabel() + " " + this.getOptionalLabel();
        }

        public void setVisible(boolean bl) {
            this.component.setVisible(bl);
        }
    }
}

