/*
 * Decompiled with CFR 0.152.
 */
package net.wordrider.core.managers;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.MutableAttributeSet;
import net.wordrider.area.RiderArea;
import net.wordrider.area.RiderDocument;
import net.wordrider.area.RiderStyles;
import net.wordrider.area.actions.AligmentCenterAction;
import net.wordrider.area.actions.AligmentLeftAction;
import net.wordrider.area.actions.AligmentRightAction;
import net.wordrider.area.actions.ChangeConjugateStyleAction;
import net.wordrider.area.actions.ChangeDottedStyleAction;
import net.wordrider.area.actions.ChangeExponentStyleAction;
import net.wordrider.area.actions.ChangeFontSizeStyle1Action;
import net.wordrider.area.actions.ChangeFontSizeStyle2Action;
import net.wordrider.area.actions.ChangeFontSizeStyle3Action;
import net.wordrider.area.actions.ChangeInvertStyleAction;
import net.wordrider.area.actions.ChangeMathStyleAction;
import net.wordrider.area.actions.ChangeStrikedStyleAction;
import net.wordrider.area.actions.ChangeSubscriptStyleAction;
import net.wordrider.area.actions.ChangeUnderlineStyleAction;
import net.wordrider.area.actions.ChangeVectorStyleAction;
import net.wordrider.area.actions.ChangeWordWrapStyleAction;
import net.wordrider.area.actions.CopyAction;
import net.wordrider.area.actions.CutAction;
import net.wordrider.area.actions.InsertPictureAction;
import net.wordrider.area.actions.InsertSeparatorDoubleAction;
import net.wordrider.area.actions.InsertSeparatorSingleAction;
import net.wordrider.area.actions.Margin10Action;
import net.wordrider.area.actions.Margin20Action;
import net.wordrider.area.actions.Margin30Action;
import net.wordrider.area.actions.MarginXAction;
import net.wordrider.area.actions.PasteAction;
import net.wordrider.area.actions.RedoAction;
import net.wordrider.area.actions.UndoAction;
import net.wordrider.area.actions.UpdateBreakpointAction;
import net.wordrider.core.AppPrefs;
import net.wordrider.core.actions.ChangeImagePropertiesAction;
import net.wordrider.core.actions.CreateNewFileAction;
import net.wordrider.core.actions.OpenFileAction;
import net.wordrider.core.actions.SaveAsFileAction;
import net.wordrider.core.actions.SaveFileAction;
import net.wordrider.core.managers.AreaChangeEvent;
import net.wordrider.core.managers.AreaManager;
import net.wordrider.core.managers.FileChangeEvent;
import net.wordrider.core.managers.InstanceEvent;
import net.wordrider.core.managers.interfaces.IAreaChangeListener;
import net.wordrider.core.managers.interfaces.IFileChangeListener;
import net.wordrider.core.managers.interfaces.IFileInstance;
import net.wordrider.core.managers.interfaces.IHidAble;
import net.wordrider.core.managers.interfaces.IRiderManager;
import net.wordrider.core.managers.interfaces.InstanceListener;
import net.wordrider.dialogs.LimitedPlainDocument;
import net.wordrider.gui.ToolbarSeparator;
import net.wordrider.utilities.Swinger;

public final class ToolbarManager
implements IRiderManager,
CaretListener,
IFileChangeListener,
IAreaChangeListener,
DocumentListener,
PropertyChangeListener,
IHidAble,
InstanceListener {
    private final JPanel panel = new JPanel(new BorderLayout());
    private JToolBar toolbar;
    private JToggleButton leftItem;
    private JToggleButton centerItem;
    private JToggleButton rightItem;
    private JToggleButton margin10Item;
    private JToggleButton margin20Item;
    private JToggleButton margin30Item;
    private JToggleButton marginXItem;
    private JToggleButton mathItem;
    private JToggleButton bookmarkItem;
    private JToggleButton size1Item;
    private JToggleButton size2Item;
    private JToggleButton size3Item;
    private JToggleButton superScriptItem;
    private JToggleButton underlineSingleItem;
    private JToggleButton underlineDottedItem;
    private JToggleButton strikeoutItem;
    private JToggleButton invertItem;
    private JToggleButton vectorItem;
    private JToggleButton wordWrapItem;
    private JToggleButton subScriptItem;
    private JToggleButton conjugateItem;
    private static final Dimension buttonDimension = new Dimension(24, 23);
    private static final int STRUT_SIZE = 8;
    private IFileInstance instance;
    private boolean activeMath = false;
    private Element currentRunEl;
    private JComboBox comboMarginX;
    private static final Logger logger = Logger.getLogger(ToolbarManager.class.getName());

    public ToolbarManager() {
        this.panel.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 0));
        UIManager.addPropertyChangeListener(this);
        this.createToolbar();
        this.panel.setVisible(AppPrefs.getProperty("net.wordrider.gui.showToolbar", true));
    }

    private void initToolbar() {
        this.comboMarginX.setEnabled(this.instance != null);
    }

    public void updateHibviewButtons() {
        boolean bl = AppPrefs.getProperty("settings.hibviewButtons", true);
        this.conjugateItem.setVisible(bl);
        this.subScriptItem.setVisible(bl);
        this.comboMarginX.setVisible(bl);
    }

    private void createToolbar() {
        this.toolbar = new JToolBar("Main Toolbar");
        this.panel.add(this.toolbar);
        this.panel.setPreferredSize(new Dimension(400, 27));
        SwingUtilities.updateComponentTreeUI(this.toolbar);
        this.toolbar.setFocusable(false);
        this.toolbar.setFloatable(false);
        this.toolbar.add(ToolbarManager.getButton(CreateNewFileAction.getInstance()));
        this.toolbar.add(ToolbarManager.getButton(OpenFileAction.getInstance()));
        this.toolbar.add(Box.createHorizontalStrut(2));
        this.toolbar.add(ToolbarManager.getButton(SaveFileAction.getInstance()));
        this.toolbar.add(ToolbarManager.getButton(SaveAsFileAction.getInstance()));
        this.toolbar.add(new ToolbarSeparator());
        this.toolbar.add(ToolbarManager.getButton(UndoAction.getInstance()));
        this.toolbar.add(ToolbarManager.getButton(RedoAction.getInstance()));
        this.toolbar.add(new ToolbarSeparator());
        this.toolbar.add(ToolbarManager.getButton(CutAction.getInstance()));
        this.toolbar.add(ToolbarManager.getButton(CopyAction.getInstance()));
        this.toolbar.add(ToolbarManager.getButton(PasteAction.getInstance()));
        this.toolbar.add(new ToolbarSeparator());
        ButtonGroup buttonGroup = new ButtonGroup();
        this.size1Item = ToolbarManager.getToggleButton(ChangeFontSizeStyle1Action.getInstance());
        this.toolbar.add(this.size1Item);
        buttonGroup.add(this.size1Item);
        this.size2Item = ToolbarManager.getToggleButton(ChangeFontSizeStyle2Action.getInstance());
        this.toolbar.add(this.size2Item);
        buttonGroup.add(this.size2Item);
        this.size3Item = ToolbarManager.getToggleButton(ChangeFontSizeStyle3Action.getInstance());
        this.toolbar.add(this.size3Item);
        buttonGroup.add(this.size3Item);
        this.toolbar.add(Box.createHorizontalStrut(8));
        this.superScriptItem = ToolbarManager.getToggleButton(ChangeExponentStyleAction.getInstance());
        this.toolbar.add(this.superScriptItem);
        this.subScriptItem = ToolbarManager.getToggleButton(ChangeSubscriptStyleAction.getInstance());
        this.toolbar.add(this.subScriptItem);
        this.toolbar.add(new ToolbarSeparator());
        this.underlineSingleItem = ToolbarManager.getToggleButton(ChangeUnderlineStyleAction.getInstance());
        this.toolbar.add(this.underlineSingleItem);
        this.underlineDottedItem = ToolbarManager.getToggleButton(ChangeDottedStyleAction.getInstance());
        this.toolbar.add(this.underlineDottedItem);
        this.toolbar.add(Box.createHorizontalStrut(8));
        this.strikeoutItem = ToolbarManager.getToggleButton(ChangeStrikedStyleAction.getInstance());
        this.toolbar.add(this.strikeoutItem);
        this.toolbar.add(new ToolbarSeparator());
        this.invertItem = ToolbarManager.getToggleButton(ChangeInvertStyleAction.getInstance());
        this.toolbar.add(this.invertItem);
        this.toolbar.add(Box.createHorizontalStrut(8));
        this.vectorItem = ToolbarManager.getToggleButton(ChangeVectorStyleAction.getInstance());
        this.toolbar.add(this.vectorItem);
        this.conjugateItem = ToolbarManager.getToggleButton(ChangeConjugateStyleAction.getInstance());
        this.toolbar.add(this.conjugateItem);
        this.toolbar.add(Box.createHorizontalStrut(8));
        this.wordWrapItem = ToolbarManager.getToggleButton(ChangeWordWrapStyleAction.getInstance());
        this.toolbar.add(this.wordWrapItem);
        this.toolbar.add(new ToolbarSeparator());
        buttonGroup = new ButtonGroup();
        this.leftItem = ToolbarManager.getToggleButton(AligmentLeftAction.getInstance());
        buttonGroup.add(this.leftItem);
        this.toolbar.add(this.leftItem);
        this.centerItem = ToolbarManager.getToggleButton(AligmentCenterAction.getInstance());
        buttonGroup.add(this.centerItem);
        this.toolbar.add(this.centerItem);
        this.rightItem = ToolbarManager.getToggleButton(AligmentRightAction.getInstance());
        this.toolbar.add(this.rightItem);
        buttonGroup.add(this.rightItem);
        this.toolbar.add(Box.createHorizontalStrut(8));
        this.margin10Item = ToolbarManager.getToggleButton(Margin10Action.getInstance());
        this.toolbar.add(this.margin10Item);
        buttonGroup.add(this.margin10Item);
        this.margin20Item = ToolbarManager.getToggleButton(Margin20Action.getInstance());
        this.toolbar.add(this.margin20Item);
        buttonGroup.add(this.margin20Item);
        this.margin30Item = ToolbarManager.getToggleButton(Margin30Action.getInstance());
        this.toolbar.add(this.margin30Item);
        buttonGroup.add(this.margin30Item);
        this.toolbar.add(this.getMarginXCombo());
        this.toolbar.add(Box.createHorizontalStrut(8));
        this.toolbar.add(this.comboMarginX);
        this.marginXItem = ToolbarManager.getToggleButton(MarginXAction.getInstance());
        this.toolbar.add(this.marginXItem);
        buttonGroup.add(this.marginXItem);
        this.toolbar.add(Box.createHorizontalStrut(8));
        this.mathItem = ToolbarManager.getToggleButton(ChangeMathStyleAction.getInstance());
        this.toolbar.add(this.mathItem);
        this.toolbar.add(new ToolbarSeparator());
        this.toolbar.add(ToolbarManager.getButton(InsertPictureAction.getInstance()));
        this.toolbar.add(Box.createHorizontalStrut(8));
        this.toolbar.add(ToolbarManager.getButton(InsertSeparatorSingleAction.getInstance()));
        this.toolbar.add(ToolbarManager.getButton(InsertSeparatorDoubleAction.getInstance()));
        this.toolbar.add(Box.createHorizontalStrut(8));
        this.bookmarkItem = ToolbarManager.getToggleButton(UpdateBreakpointAction.getInstance());
        this.toolbar.add(this.bookmarkItem);
        this.panel.validate();
        this.initToolbar();
    }

    private static JToggleButton getToggleButton(Action action) {
        JToggleButton jToggleButton = new JToggleButton(action);
        jToggleButton.setAction(action);
        jToggleButton.setText(null);
        jToggleButton.setMinimumSize(buttonDimension);
        jToggleButton.setPreferredSize(buttonDimension);
        jToggleButton.setMaximumSize(buttonDimension);
        jToggleButton.setMnemonic(0);
        jToggleButton.setFocusable(false);
        return jToggleButton;
    }

    public final void insertUpdate(DocumentEvent documentEvent) {
        this.updateStatus(0, 0);
    }

    private void unregisterHooks() {
        if (this.instance == null) {
            return;
        }
        Object c = this.instance.getRiderArea();
        ((JTextComponent)c).getDocument().removeDocumentListener(this);
        ((Component)c).removePropertyChangeListener("document", this);
        ((JTextComponent)c).removeCaretListener(this);
        this.comboMarginX.setEnabled(false);
        this.instance.removeInstanceListener(this);
        this.instance = null;
    }

    public void areaActivated(AreaChangeEvent areaChangeEvent) {
        IFileInstance iFileInstance = areaChangeEvent.getFileInstance();
        this.areaActivated(iFileInstance);
    }

    private void areaActivated(IFileInstance iFileInstance) {
        if (this.isVisible()) {
            if (!iFileInstance.equals(this.instance)) {
                this.unregisterHooks();
                this.registerHooks(iFileInstance);
            }
            this.updateModifiedStatus();
            this.updateButtonsStatuses();
            this.comboMarginX.setEnabled(true);
        }
    }

    public void areaDeactivated(AreaChangeEvent areaChangeEvent) {
        this.areaDeactivated();
    }

    private void areaDeactivated() {
        this.unregisterHooks();
    }

    public final void updateToolbar() {
        if (logger.isLoggable(Level.INFO)) {
            logger.info("update toolbar buttons statuses");
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ToolbarManager.this.updateButtonsStatuses();
            }
        });
    }

    private void updateButtonsStatuses() {
        boolean bl;
        if (this.instance == null) {
            return;
        }
        RiderArea riderArea = (RiderArea)this.instance.getRiderArea();
        MutableAttributeSet mutableAttributeSet = riderArea.getInputAttributes();
        Element element = riderArea.getDoc().getParagraphElement(riderArea.getCaretPosition());
        boolean bl2 = bl = !RiderStyles.isMath(element);
        if (this.activeMath != bl) {
            ChangeFontSizeStyle1Action.getInstance().setEnabled(bl);
            ChangeFontSizeStyle2Action.getInstance().setEnabled(bl);
            ChangeFontSizeStyle3Action.getInstance().setEnabled(bl);
            AligmentLeftAction.getInstance().setEnabled(bl);
            AligmentCenterAction.getInstance().setEnabled(bl);
            AligmentRightAction.getInstance().setEnabled(bl);
            Margin10Action.getInstance().setEnabled(bl);
            Margin20Action.getInstance().setEnabled(bl);
            Margin30Action.getInstance().setEnabled(bl);
            ChangeInvertStyleAction.getInstance().setEnabled(bl);
            ChangeVectorStyleAction.getInstance().setEnabled(bl);
            ChangeConjugateStyleAction.getInstance().setEnabled(bl);
            ChangeWordWrapStyleAction.getInstance().setEnabled(bl);
            ChangeExponentStyleAction.getInstance().setEnabled(bl);
            ChangeSubscriptStyleAction.getInstance().setEnabled(bl);
            ChangeUnderlineStyleAction.getInstance().setEnabled(bl);
            ChangeDottedStyleAction.getInstance().setEnabled(bl);
            ChangeStrikedStyleAction.getInstance().setEnabled(bl);
            UpdateBreakpointAction.getInstance().setEnabled(bl);
            MarginXAction.getInstance().setEnabled(bl);
            this.comboMarginX.setEnabled(bl);
            this.activeMath = bl;
            this.mathItem.setSelected(!bl);
        }
        this.size1Item.setSelected(RiderStyles.isSize(mutableAttributeSet, 11));
        this.size2Item.setSelected(RiderStyles.isSize(mutableAttributeSet, 13));
        this.size3Item.setSelected(RiderStyles.isSize(mutableAttributeSet, 16));
        this.superScriptItem.setSelected(RiderStyles.isExposant(mutableAttributeSet));
        this.subScriptItem.setSelected(RiderStyles.isSubscript(mutableAttributeSet));
        if (RiderStyles.isUnderLineDotted(mutableAttributeSet)) {
            this.underlineSingleItem.setSelected(false);
            this.underlineDottedItem.setSelected(true);
        } else if (RiderStyles.isUnderLine(mutableAttributeSet)) {
            this.underlineSingleItem.setSelected(true);
            this.underlineDottedItem.setSelected(false);
        } else {
            this.underlineSingleItem.setSelected(false);
            this.underlineDottedItem.setSelected(false);
        }
        short s = RiderStyles.getMargin(mutableAttributeSet);
        block0 : switch (s) {
            case 10: {
                this.margin10Item.setSelected(true);
                break;
            }
            case 20: {
                this.margin20Item.setSelected(true);
                break;
            }
            case 30: {
                this.margin30Item.setSelected(true);
                break;
            }
            case 0: {
                switch (RiderStyles.getAlignment(mutableAttributeSet)) {
                    case 0: {
                        this.leftItem.setSelected(true);
                        break block0;
                    }
                    case 1: {
                        this.centerItem.setSelected(true);
                        break block0;
                    }
                    case 2: {
                        this.rightItem.setSelected(true);
                        break block0;
                    }
                }
                this.leftItem.setSelected(true);
                break;
            }
            default: {
                this.comboMarginX.setSelectedItem(s);
                this.marginXItem.setSelected(true);
            }
        }
        this.invertItem.setSelected(RiderStyles.isInvert(mutableAttributeSet));
        this.vectorItem.setSelected(RiderStyles.isVector(mutableAttributeSet));
        this.conjugateItem.setSelected(RiderStyles.isConjugate(mutableAttributeSet));
        this.wordWrapItem.setSelected(RiderStyles.isWordWrap(mutableAttributeSet));
        this.strikeoutItem.setSelected(RiderStyles.isStrikeOut(mutableAttributeSet));
        this.bookmarkItem.setSelected(RiderStyles.isBookmark(element));
        this.updateCopyPasteButtons();
    }

    public final Component getManagerComponent() {
        return this.panel;
    }

    private void updateModifiedStatus() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SaveFileAction.getInstance().setEnabled(ToolbarManager.this.instance != null && ToolbarManager.this.instance.isModified());
            }
        });
    }

    public void fileWasOpened(FileChangeEvent fileChangeEvent) {
        if (this.comboMarginX != null) {
            MarginXAction.updateComboData(this.comboMarginX);
        }
    }

    public void fileWasClosed(FileChangeEvent fileChangeEvent) {
    }

    private void updateStatus(int n, int n2) {
        RiderArea riderArea = (RiderArea)this.instance.getRiderArea();
        if (riderArea.isBusy()) {
            return;
        }
        int n3 = Math.min(n, n2);
        RiderDocument riderDocument = riderArea.getDoc();
        Element element = riderDocument.getParagraphElement(n3);
        Element element2 = element.getStartOffset() == n3 || n != n2 ? riderDocument.getCharacterElement(n3) : riderDocument.getCharacterElement(Math.max(n3 - 1, 0));
        if (!element2.equals(this.currentRunEl)) {
            this.updateToolbar();
            this.currentRunEl = element2;
        } else {
            this.updateCopyPasteButtons();
        }
    }

    private void updateCopyPasteButtons() {
        Object c = this.instance.getRiderArea();
        boolean bl = ((JTextComponent)c).getSelectionStart() != ((JTextComponent)c).getSelectionEnd();
        CopyAction.getInstance().setEnabled(bl && ((JTextComponent)c).isEditable());
        CutAction.getInstance().setEnabled(bl && ((JTextComponent)c).isEditable());
        PasteAction.getInstance().setEnabled(((JTextComponent)c).isEditable());
        ChangeImagePropertiesAction.getInstance().updateEnabled((RiderArea)c);
    }

    public final void caretUpdate(CaretEvent caretEvent) {
        this.updateStatus(caretEvent.getDot(), caretEvent.getMark());
    }

    public final void changedUpdate(DocumentEvent documentEvent) {
        this.updateStatus(documentEvent.getOffset(), 0);
    }

    public final void removeUpdate(DocumentEvent documentEvent) {
        this.changedUpdate(documentEvent);
    }

    public JComboBox getInputMarginXCombo() {
        return this.comboMarginX;
    }

    private JComboBox getMarginXCombo() {
        Serializable serializable;
        this.comboMarginX = new JComboBox();
        Component component = this.comboMarginX.getEditor().getEditorComponent();
        if (component instanceof JTextComponent) {
            serializable = (JTextComponent)component;
            ((Component)serializable).addKeyListener(new ComboKeyListener());
            ((JTextComponent)serializable).setDocument(new LimitedPlainDocument("\\p{Digit}{0,3}"));
            ((Component)serializable).addFocusListener(new Swinger.SelectAllOnFocusListener());
        }
        this.comboMarginX.setEditable(true);
        serializable = new Dimension(50, 22);
        this.comboMarginX.setMinimumSize((Dimension)serializable);
        this.comboMarginX.setPreferredSize((Dimension)serializable);
        this.comboMarginX.setMaximumSize((Dimension)serializable);
        return this.comboMarginX;
    }

    public void instanceModifiedStatusChanged(InstanceEvent instanceEvent) {
        this.updateModifiedStatus();
    }

    public void fileAssigned(InstanceEvent instanceEvent) {
    }

    public final void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getSource().equals(this.instance.getRiderArea()) && propertyChangeEvent.getPropertyName().equals("document")) {
            ((Document)propertyChangeEvent.getOldValue()).removeDocumentListener(this);
            Document document = (Document)propertyChangeEvent.getNewValue();
            document.addDocumentListener(this);
        } else if (propertyChangeEvent.getPropertyName().equals("lookAndFeel")) {
            this.panel.remove(this.toolbar);
            this.createToolbar();
            this.updateButtonsStatuses();
        }
    }

    private void registerHooks(IFileInstance iFileInstance) {
        this.instance = iFileInstance;
        Object c = iFileInstance.getRiderArea();
        ((JTextComponent)c).addCaretListener(this);
        ((JTextComponent)c).getDocument().addDocumentListener(this);
        ((Container)c).addPropertyChangeListener("document", this);
        iFileInstance.addInstanceListener(this);
    }

    private static JButton getButton(Action action) {
        JButton jButton = new JButton(action);
        jButton.setText("");
        jButton.setMnemonic(0);
        jButton.setMinimumSize(buttonDimension);
        jButton.setPreferredSize(buttonDimension);
        jButton.setMaximumSize(buttonDimension);
        jButton.setFocusable(false);
        return jButton;
    }

    public final boolean isVisible() {
        return this.panel.isVisible();
    }

    public final void setVisible(boolean bl) {
        if (bl) {
            this.panel.setVisible(true);
            this.areaActivated((IFileInstance)AreaManager.getInstance().getActiveInstance());
        } else {
            this.panel.setVisible(false);
            this.areaDeactivated();
        }
        AppPrefs.storeProperty("net.wordrider.gui.showToolbar", bl);
    }

    private static final class ComboKeyListener
    extends KeyAdapter {
        private ComboKeyListener() {
        }

        public final void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 10) {
                MarginXAction.getInstance().actionPerformed(null);
            }
        }
    }
}

