/*
 * Decompiled with CFR 0.152.
 */
package net.wordrider.dialogs;

import java.io.File;
import javax.swing.filechooser.FileFilter;
import net.wordrider.core.Lng;
import net.wordrider.core.actions.IFileType;
import net.wordrider.utilities.Utils;

public final class RiderFileFilter
extends FileFilter
implements IFileType {
    private final Object[] extensions;
    private final String description;

    public RiderFileFilter(String[] stringArray, String string) {
        this.extensions = stringArray;
        StringBuilder stringBuilder = new StringBuilder();
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            stringBuilder.append("*.").append(stringArray[i]);
            if (i + 1 == n) continue;
            stringBuilder.append(',');
        }
        this.description = Lng.getLabel(string, new Object[]{stringArray[0].toUpperCase(), stringBuilder.toString()});
    }

    public final String getExtension() {
        return this.extensions[0].toString();
    }

    public final boolean accept(File file) {
        if (file.isDirectory()) {
            return true;
        }
        String string = Utils.getExtension(file);
        if (string != null) {
            for (int i = 0; i < this.extensions.length; ++i) {
                if (!string.equals(this.extensions[i])) continue;
                return true;
            }
        }
        return false;
    }

    public final String getDescription() {
        return this.description;
    }
}

