/*
 * Decompiled with CFR 0.152.
 */
package net.wordrider.files.ti68kformat;

import java.awt.Image;
import java.awt.image.PixelGrabber;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import net.wordrider.files.ti68kformat.TIFileWriter;

public final class TIImageFileWriter
extends TIFileWriter {
    private static final String fileHeader = "**TI92P*";
    private int sum = 0;
    private final Image image;
    private int[] bitmap;

    public TIImageFileWriter(Image image) {
        this.image = image;
    }

    public boolean saveToFile(File file) throws IOException {
        int n = this.image.getWidth(null);
        int n2 = this.image.getHeight(null);
        this.bitmap = new int[n * n2];
        PixelGrabber pixelGrabber = new PixelGrabber(this.image, 0, 0, n, n2, this.bitmap, 0, n);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            throw new IOException(interruptedException.getMessage());
        }
        if ((pixelGrabber.getStatus() & 0x80) != 0) {
            throw new IOException("Fatal error image processing");
        }
        return super.saveToFile(file);
    }

    protected final char getCheckSum() {
        return (char)this.sum;
    }

    protected final byte getDataType() {
        return 16;
    }

    protected final String getFileHeaderType() {
        return fileHeader;
    }

    protected int getContentFileSize() {
        return 19 + this.bitmap.length / 8;
    }

    protected final void writeContent(DataOutputStream dataOutputStream) throws IOException {
        int n = this.image.getWidth(null);
        int n2 = this.image.getHeight(null);
        this.sum = 223 + (n & 0xFF) + (n >> 8 & 0xFF) + (n2 & 0xFF) + (n2 >> 8 & 0xFF);
        int n3 = this.bitmap.length;
        int n4 = n3 / 8;
        int n5 = n4 + 5;
        this.sum += (n5 & 0xFF) + (n5 >> 8 & 0xFF);
        dataOutputStream.writeInt((char)n5);
        dataOutputStream.writeByte(n2 >> 8 & 0xFF);
        dataOutputStream.writeByte(n2 & 0xFF);
        dataOutputStream.writeByte(n >> 8 & 0xFF);
        dataOutputStream.writeByte(n & 0xFF);
        for (int i = 0; i < n3; i += 8) {
            int n6 = this.bitmap[i] == -16777216 ? 128 : 0;
            n6 |= this.bitmap[i + 1] == -16777216 ? 64 : 0;
            n6 |= this.bitmap[i + 2] == -16777216 ? 32 : 0;
            n6 |= this.bitmap[i + 3] == -16777216 ? 16 : 0;
            n6 |= this.bitmap[i + 4] == -16777216 ? 8 : 0;
            n6 |= this.bitmap[i + 5] == -16777216 ? 4 : 0;
            n6 |= this.bitmap[i + 6] == -16777216 ? 2 : 0;
            this.sum += (n6 |= this.bitmap[i + 7] == -16777216 ? 1 : 0);
            dataOutputStream.writeByte(n6);
        }
        dataOutputStream.writeByte(223);
    }
}

