/*
 * Decompiled with CFR 0.152.
 */
package net.wordrider.core.managers;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.event.EventListenerList;
import net.wordrider.area.RiderArea;
import net.wordrider.core.Lng;
import net.wordrider.core.MainApp;
import net.wordrider.core.actions.CloseActiveAction;
import net.wordrider.core.actions.SaveFileAction;
import net.wordrider.core.managers.InstanceEvent;
import net.wordrider.core.managers.interfaces.IFileInstance;
import net.wordrider.core.managers.interfaces.IInformedTab;
import net.wordrider.core.managers.interfaces.InstanceListener;
import net.wordrider.files.ti68kformat.TITextFileInfo;
import net.wordrider.utilities.Swinger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FileInstance
implements IFileInstance<RiderArea>,
IInformedTab,
PropertyChangeListener {
    private File file = null;
    private static int untitledCount;
    private String name;
    private final RiderArea area = new RiderArea();
    private final JScrollPane scrollPane = new JScrollPane();
    private Integer internalId = 0;
    private final EventListenerList listenerList = new EventListenerList();
    private TITextFileInfo fileInfo;

    public FileInstance() {
        this.setFileInfo(new TITextFileInfo());
        this.init();
    }

    public FileInstance(File file, TITextFileInfo tITextFileInfo) {
        this.setFileInfo(tITextFileInfo);
        this.file = file;
        this.init();
    }

    private void init() {
        this.area.addPropertyChangeListener("modified", this);
        this.scrollPane.getViewport().add(this.area);
        this.scrollPane.setFocusable(false);
        this.scrollPane.setFocusCycleRoot(false);
        this.scrollPane.setVerticalScrollBarPolicy(22);
        this.updateName();
    }

    private void updateName() {
        this.name = this.file == null ? Lng.getLabel("editor.untitled", String.valueOf(++untitledCount)) : this.file.getName();
    }

    @Override
    public int compareTo(IFileInstance iFileInstance) {
        return this.getInternalId().compareTo(((FileInstance)iFileInstance).getInternalId());
    }

    @Override
    public boolean hasAssignedFile() {
        return this.file != null;
    }

    @Override
    public final File getFile() {
        return this.file;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final TITextFileInfo getFileInfo() {
        return this.fileInfo;
    }

    @Override
    public final void setFileInfo(TITextFileInfo tITextFileInfo) {
        this.fileInfo = tITextFileInfo;
    }

    @Override
    public final void setFile(File file) {
        this.file = file;
        this.updateName();
        this.fireFileAssigned();
        CloseActiveAction.getInstance().updateStatusName(this);
        this.setModified(false);
    }

    @Override
    public final RiderArea getRiderArea() {
        return this.area;
    }

    @Override
    public final JComponent getComponent() {
        return this.scrollPane;
    }

    @Override
    public final Icon getIcon() {
        return null;
    }

    @Override
    public final String getTip() {
        return this.file != null ? this.file.getAbsolutePath() : null;
    }

    @Override
    public final void activate() {
        Swinger.inputFocus(this.area);
    }

    @Override
    public String getTabName() {
        return this.isModified() ? this.getName() + "*" : this.getName();
    }

    @Override
    public boolean closeSoft() throws Throwable {
        if (this.isModified()) {
            switch (Swinger.getChoiceCancel(MainApp.getInstance().getMainAppFrame(), Lng.getLabel("message.confirm.changed"))) {
                case 0: {
                    SaveFileAction.getInstance().actionPerformed(null);
                    break;
                }
                case 1: {
                    this.closeHard();
                    return true;
                }
                default: {
                    return false;
                }
            }
        }
        this.area.removePropertyChangeListener("modified", this);
        this.closeHard();
        return true;
    }

    public final String toString() {
        return this.getName();
    }

    @Override
    public void closeHard() throws Throwable {
        this.area.freeUpResources();
    }

    @Override
    public boolean isModified() {
        return this.area.isModified();
    }

    @Override
    public final void deactivate() {
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("modified")) {
            this.fireInstanceModified();
        }
    }

    void setInternalId(Integer n) {
        this.internalId = n;
    }

    private Integer getInternalId() {
        return this.internalId;
    }

    private void fireInstanceModified() {
        Object[] objectArray = this.listenerList.getListenerList();
        InstanceEvent instanceEvent = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != InstanceListener.class) continue;
            if (instanceEvent == null) {
                instanceEvent = new InstanceEvent(this);
            }
            ((InstanceListener)objectArray[i + 1]).instanceModifiedStatusChanged(instanceEvent);
        }
    }

    private void fireFileAssigned() {
        Object[] objectArray = this.listenerList.getListenerList();
        InstanceEvent instanceEvent = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != InstanceListener.class) continue;
            if (instanceEvent == null) {
                instanceEvent = new InstanceEvent(this);
            }
            ((InstanceListener)objectArray[i + 1]).fileAssigned(instanceEvent);
        }
    }

    @Override
    public void addInstanceListener(InstanceListener instanceListener) {
        this.listenerList.add(InstanceListener.class, instanceListener);
    }

    @Override
    public void removeInstanceListener(InstanceListener instanceListener) {
        this.listenerList.remove(InstanceListener.class, instanceListener);
    }

    @Override
    public void setModified(boolean bl) {
        this.area.setModified(bl);
    }
}

