/*
 * Decompiled with CFR 0.152.
 */
package net.wordrider.files.ti68kformat;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.logging.Logger;
import net.wordrider.files.ImportableFileReader;
import net.wordrider.files.InvalidDataTypeException;
import net.wordrider.files.NotSupportedFileException;
import net.wordrider.files.ti68kformat.TIFile;
import net.wordrider.utilities.LogUtils;

public abstract class TIFileReader
extends TIFile
implements ImportableFileReader {
    private static final Logger logger = Logger.getLogger(TIFileReader.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean openFromFile(File file) throws InvalidDataTypeException, NotSupportedFileException, IOException {
        FilterInputStream filterInputStream = null;
        this.storeFileInformation(file);
        if (!file.exists() && !file.createNewFile()) {
            return false;
        }
        if (file.length() > 100000L) {
            throw new InvalidDataTypeException();
        }
        try {
            filterInputStream = new DataInputStream(new FileInputStream(file));
            this.readHeader((DataInputStream)filterInputStream);
            this.readContent((DataInputStream)filterInputStream);
            char c = this.readChecksum((DataInputStream)filterInputStream);
            char c2 = this.getCheckSum();
            if (c != c2) {
                logger.warning("File '" + file.getPath() + "' was loaded but the file might be corrupted (CRC mismatch)");
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            if (filterInputStream != null) {
                filterInputStream.close();
            }
        }
    }

    protected abstract void storeFileInformation(File var1);

    private static String getString(byte[] byArray) {
        int n;
        int n2 = byArray.length;
        for (n = 0; n < n2 && byArray[n] != 0; ++n) {
        }
        try {
            return new String(byArray, 0, n, "ASCII");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            LogUtils.processException(logger, unsupportedEncodingException);
            return "unknown";
        }
    }

    private void readHeader(DataInputStream dataInputStream) throws NotSupportedFileException, InvalidDataTypeException, IOException {
        byte[] byArray = new byte[8];
        dataInputStream.readFully(byArray);
        String string = TIFileReader.getString(byArray);
        if (!TIFileReader.isSupportedHeader(this.getSupportedHeaders(), string)) {
            throw new NotSupportedFileException(string);
        }
        dataInputStream.skipBytes(2);
        dataInputStream.readFully(byArray);
        this.fileInfo.setFolderName(TIFileReader.getString(byArray));
        byArray = new byte[40];
        dataInputStream.readFully(byArray);
        this.fileInfo.setComment(TIFileReader.getString(byArray));
        dataInputStream.readShort();
        dataInputStream.skipBytes(4);
        byArray = new byte[8];
        dataInputStream.readFully(byArray);
        this.fileInfo.setVarName(TIFileReader.getString(byArray));
        int n = dataInputStream.readUnsignedByte();
        if (n != this.getDataType()) {
            throw new InvalidDataTypeException();
        }
        this.fileInfo.setStoreType(dataInputStream.readUnsignedByte(), true);
        dataInputStream.skipBytes(8);
    }

    char readChecksum(DataInputStream dataInputStream) throws IOException {
        return (char)(dataInputStream.readUnsignedByte() + (dataInputStream.readUnsignedByte() << 8));
    }

    protected abstract void readContent(DataInputStream var1) throws IOException, InvalidDataTypeException;

    protected abstract String[] getSupportedHeaders();

    private static boolean isSupportedHeader(String[] stringArray, String string) {
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            if (!stringArray[i].equals(string)) continue;
            return true;
        }
        return false;
    }

    protected abstract byte getDataType();

    protected abstract char getCheckSum();
}

