/*
 * Decompiled with CFR 0.152.
 */
package net.wordrider.area;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.Autoscroll;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.io.File;
import java.util.Collection;
import java.util.LinkedList;
import java.util.logging.Logger;
import javax.swing.InputMap;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.TextUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.Utilities;
import javax.swing.undo.UndoManager;
import net.wordrider.area.AlphaBetaKeyListener;
import net.wordrider.area.AreaBorder;
import net.wordrider.area.AreaImage;
import net.wordrider.area.AreaUndoManager;
import net.wordrider.area.BracketMatcher;
import net.wordrider.area.ColorStyles;
import net.wordrider.area.ContextMenu;
import net.wordrider.area.CurrentLineHighlighter;
import net.wordrider.area.OvertypeCaret;
import net.wordrider.area.RiderCaret;
import net.wordrider.area.RiderDocument;
import net.wordrider.area.RiderEditorKit;
import net.wordrider.area.RiderStyles;
import net.wordrider.area.ScrollGestureRecognizer;
import net.wordrider.area.StyledContent;
import net.wordrider.area.StyledContentSelection;
import net.wordrider.area.actions.AligmentLeftAction;
import net.wordrider.area.actions.DeleteWordAction;
import net.wordrider.area.actions.GetNextTabAction;
import net.wordrider.area.actions.GetPrevTabAction;
import net.wordrider.area.actions.RedoAction;
import net.wordrider.area.actions.RotateAligmentStyleAction;
import net.wordrider.area.actions.RotateMarginStyleAction;
import net.wordrider.area.actions.SelectWordAction;
import net.wordrider.area.actions.UndoAction;
import net.wordrider.area.actions.UpdateBreakpointAction;
import net.wordrider.core.AppPrefs;
import net.wordrider.core.actions.BatchPureTextReader;
import net.wordrider.core.actions.ChangeImagePropertiesAction;
import net.wordrider.core.swing.AutoscrollSupport;
import net.wordrider.utilities.LogUtils;
import net.wordrider.utilities.Swinger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RiderArea
extends JTextPane
implements DropTargetListener,
DragSourceListener,
DragGestureListener,
Autoscroll {
    public static final int LEFT_BORDER_WIDTH = 30;
    private AutoscrollSupport scrollSupport = new AutoscrollSupport(this, new Insets(10, 10, 10, 10));
    private boolean isModified = false;
    private static boolean isOvertypeMode;
    private static InputMap defaultInputMap;
    private Caret defaultCaret = new RiderCaret();
    private Caret overtypeCaret = new OvertypeCaret();
    private static final ClipboardOwner defaultClipboardOwner;
    private AreaUndoManager undoManager = null;
    private static final Logger logger;
    public static final DataFlavor df;
    private final DragSource dragSource = new DragSource();
    private int lastSelStart = 0;
    private int lastSelEnd = 0;
    private int dndEventLocation = 0;
    private boolean dragStartedHere = false;
    private static int maxTI89FontWidth;
    private static int maxTI92FontWidth;
    public static final int FULLVIEWBORDER = 0;
    public static final int TI89VIEWBORDER = 1;
    public static final int TI92VIEWBORDER = 2;
    private int borderType = 0;
    private int maxRightWidth = -1;
    private static final KeyListener alfaBetaKeyListener;
    private boolean tooltipSet = false;
    private static int max1CharWidth;
    private boolean busy = false;
    public static final String MODIFIED_PROPERTY = "modified";
    private static final int BOTTOM_MARGIN = 15;

    public RiderArea() {
        this.init();
    }

    public final RiderDocument getDoc() {
        return (RiderDocument)this.getDocument();
    }

    @Override
    public Font getFont() {
        return RiderStyles.getAreaFont();
    }

    @Override
    public Color getBackground() {
        return ColorStyles.getColor(1);
    }

    private void init() {
        MouseListener[] mouseListenerArray;
        new DropTarget(this, this);
        if (maxTI89FontWidth == 0) {
            maxTI89FontWidth = this.getFontMetrics(RiderStyles.getAreaFont()).stringWidth("01234567890123456789012345") + 1;
        }
        if (maxTI92FontWidth == 0) {
            maxTI92FontWidth = this.getFontMetrics(RiderStyles.getAreaFont()).stringWidth("0123456789012345678901234567890123456789") + 1;
        }
        if (max1CharWidth == 0) {
            max1CharWidth = this.getFontMetrics(RiderStyles.getAreaBigFont()).stringWidth("M") + 1;
        }
        this.dragSource.createDefaultDragGestureRecognizer(this, 2, this);
        this.defaultCaret.setBlinkRate(this.getCaret().getBlinkRate());
        this.setCaret(this.defaultCaret);
        this.setViewBorder(AppPrefs.getProperty("settings.emulation", 0), false);
        AreaBorder areaBorder = new AreaBorder(2, 30, 500, 4, this);
        this.setBorder(areaBorder);
        UIManager.addPropertyChangeListener(areaBorder);
        this.createUndoManager();
        if (defaultInputMap == null) {
            Swinger.addKeyActions(this);
            defaultInputMap = RiderArea.initActions(this.getInputMap());
        }
        this.setInputMap(0, defaultInputMap);
        for (MouseListener mouseListener : mouseListenerArray = this.getMouseListeners()) {
            this.removeMouseListener(mouseListener);
        }
        this.addMouseMotionListener(new MouseMoveAdapter());
        this.addMouseListener(new MouseClickAdapter());
        for (MouseListener mouseListener : mouseListenerArray) {
            this.addMouseListener(mouseListener);
        }
        this.addKeyListener(alfaBetaKeyListener);
        this.overtypeCaret.setBlinkRate(this.defaultCaret.getBlinkRate());
        this.setOvertypeMode(false);
        if (AppPrefs.getProperty("settings.linehighlight", true)) {
            CurrentLineHighlighter.install(this);
        }
        if (AppPrefs.getProperty("settings.matchBrackets", true)) {
            BracketMatcher.install(this);
        }
    }

    boolean showRightBorder() {
        return this.borderType != 0;
    }

    boolean limitRightBorder() {
        return this.borderType != 0;
    }

    public final UndoManager getUndoManager() {
        return this.undoManager;
    }

    public final int getViewBorder() {
        return this.borderType;
    }

    @Override
    public void scrollRectToVisible(Rectangle rectangle) {
        Dimension dimension = this.getVisibleRect().getSize();
        rectangle.height = Math.min(rectangle.height + 15, dimension.height);
        super.scrollRectToVisible(rectangle);
    }

    public final void setViewBorder(int n, boolean bl) {
        switch (n) {
            case 0: {
                this.maxRightWidth = -1;
                break;
            }
            case 1: {
                this.maxRightWidth = maxTI89FontWidth;
                break;
            }
            case 2: {
                this.maxRightWidth = maxTI92FontWidth;
                break;
            }
            default: {
                return;
            }
        }
        this.borderType = n;
        if (bl) {
            this.getDoc().refreshAll();
        }
    }

    private void setOvertypeMode(boolean bl) {
        isOvertypeMode = bl;
        int n = this.getCaretPosition();
        this.putClientProperty("overtype", bl);
        this.firePropertyChange("overtype", bl, bl);
        if (bl) {
            this.setCaret(this.overtypeCaret);
        } else {
            this.setCaret(this.defaultCaret);
            this.getDoc().refresh(n, 1);
        }
        this.setCaretPosition(n);
    }

    int getMaxTextWidth() {
        return this.maxRightWidth;
    }

    public void freeUpResources() {
        this.getUndoManager().discardAllEdits();
        CurrentLineHighlighter.uninstall(this);
        BracketMatcher.uninstall(this);
        UIManager.removePropertyChangeListener((AreaBorder)this.getBorder());
        this.undoManager = null;
        defaultInputMap = null;
        this.defaultCaret = null;
        this.overtypeCaret = null;
    }

    public AreaImage getSelectedImage() {
        int n = this.getSelectionStart();
        if (this.getSelectionEnd() - n == 1) {
            return RiderStyles.getImage(this.getDoc().getCharacterElement(n));
        }
        return null;
    }

    public void setBracketMatching(boolean bl) {
        if (bl) {
            BracketMatcher.install(this);
        } else {
            BracketMatcher.uninstall(this);
        }
    }

    public void setCurrentLineHighlight(boolean bl) {
        if (bl) {
            CurrentLineHighlighter.install(this);
        } else {
            CurrentLineHighlighter.uninstall(this);
        }
    }

    @Override
    public Insets getAutoscrollInsets() {
        return this.scrollSupport.getAutoscrollInsets();
    }

    @Override
    public void autoscroll(Point point) {
        this.scrollSupport.autoscroll(point);
    }

    public Collection<File> getAllPictureFilePaths() {
        LinkedList<File> linkedList = new LinkedList<File>();
        Element element = this.getDoc().getDefaultRootElement();
        int n = element.getElementCount();
        for (int i = 0; i < n; ++i) {
            Element element2 = element.getElement(i);
            int n2 = element2.getElementCount();
            for (int j = 0; j < n2; ++j) {
                AreaImage areaImage;
                File file;
                Element element3 = element2.getElement(j);
                if (!RiderStyles.isImage(element3) || (file = (areaImage = RiderStyles.getImage(element3)).getOriginalFile()) == null) continue;
                linkedList.add(file);
            }
        }
        return linkedList;
    }

    @Override
    public final void setDocument(Document document) {
        super.setDocument(document);
        this.setModified(false);
    }

    private void createUndoManager() {
        this.undoManager = new AreaUndoManager(this);
    }

    public final void setModified(boolean bl) {
        if (this.isModified != bl) {
            this.isModified = bl;
            this.putClientProperty(MODIFIED_PROPERTY, bl);
        }
    }

    public final boolean isModified() {
        return this.isModified;
    }

    private void replaceSelection(StyledContent styledContent) {
        Caret caret = this.getCaret();
        try {
            int n = Math.min(caret.getDot(), caret.getMark());
            int n2 = Math.max(caret.getDot(), caret.getMark());
            if (n != n2) {
                this.getDocument().remove(n, n2 - n);
            }
            if (styledContent != null) {
                styledContent.insert(this, n);
            }
        }
        catch (Exception exception) {
            LogUtils.processException(logger, exception);
        }
    }

    public void makeGroupChange(boolean bl) {
        this.setBusy(bl);
        this.firePropertyChange("undoredo", !bl, bl);
    }

    @Override
    public void replaceSelection(String string) {
        if (RiderArea.isOvertypeMode()) {
            int n = this.getCaretPosition();
            if (this.getSelectedText() == null && n < this.getDocument().getLength()) {
                this.moveCaretPosition(n + 1);
            }
        }
        super.replaceSelection(string);
    }

    private static boolean isOvertypeMode() {
        return isOvertypeMode;
    }

    @Override
    protected final EditorKit createDefaultEditorKit() {
        return new RiderEditorKit();
    }

    @Override
    public final void cut() {
        if (this.isEditable() && this.isEnabled()) {
            this.copy();
            this.replaceSelection("");
        }
    }

    @Override
    public final void copy() {
        if (this.getSelectionStart() != this.getSelectionEnd()) {
            try {
                StyledContent styledContent = new StyledContent(this);
                StyledContentSelection styledContentSelection = new StyledContentSelection(styledContent);
                Clipboard clipboard = this.getToolkit().getSystemClipboard();
                clipboard.setContents(styledContentSelection, defaultClipboardOwner);
            }
            catch (Exception exception) {
                LogUtils.processException(logger, exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void paste() {
        Clipboard clipboard = this.getToolkit().getSystemClipboard();
        Transferable transferable = clipboard.getContents(this);
        if (transferable != null) {
            try {
                this.makeGroupChange(true);
                if (transferable.isDataFlavorSupported(df)) {
                    this.replaceSelection((StyledContent)transferable.getTransferData(df));
                } else if (transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                    String string = transferable.getTransferData(DataFlavor.stringFlavor).toString();
                    this.replaceSelection(BatchPureTextReader.importText(string));
                }
            }
            catch (Exception exception) {
                LogUtils.processException(logger, exception);
            }
            finally {
                this.makeGroupChange(false);
            }
        }
    }

    @Override
    public final Color getCaretColor() {
        if (this.hasFocus()) {
            int n = this.getCaretPosition();
            try {
                if (RiderStyles.isInvert(this.getInputAttributes()) && Utilities.getRowEnd(this, n) != n) {
                    return this.getBackground();
                }
            }
            catch (BadLocationException badLocationException) {
                LogUtils.processException(logger, badLocationException);
            }
        }
        return super.getCaretColor();
    }

    private static InputMap initActions(InputMap inputMap) {
        inputMap.put(KeyStroke.getKeyStroke(89, 2), RedoAction.getInstance());
        inputMap.put(KeyStroke.getKeyStroke(8, 3), RedoAction.getInstance());
        inputMap.put(KeyStroke.getKeyStroke(8, 8), UndoAction.getInstance());
        inputMap.put(KeyStroke.getKeyStroke(127, 2), new DeleteWordAction(0));
        inputMap.put(KeyStroke.getKeyStroke(87, 2), new SelectWordAction());
        inputMap.put(KeyStroke.getKeyStroke(8, 2), new DeleteWordAction(1));
        inputMap.put(KeyStroke.getKeyStroke(48, 8), AligmentLeftAction.getInstance());
        inputMap.put(KeyStroke.getKeyStroke(9, 1), new RiderEditorKit.RemoveTabAction());
        inputMap.put(KeyStroke.getKeyStroke("F4"), RotateAligmentStyleAction.getInstance());
        inputMap.put(KeyStroke.getKeyStroke("F5"), RotateMarginStyleAction.getInstance());
        inputMap.put(GetNextTabAction.getInstance().getKeyStroke(), GetNextTabAction.getInstance());
        inputMap.put(GetPrevTabAction.getInstance().getKeyStroke(), GetPrevTabAction.getInstance());
        return inputMap;
    }

    private static boolean isInLeftBorder(MouseEvent mouseEvent) {
        return mouseEvent.getX() < 25;
    }

    private Element getBookmarkElement(MouseEvent mouseEvent, int n) {
        if (n != -1) {
            Rectangle rectangle;
            Element element = this.getStyledDocument().getParagraphElement(n);
            if (RiderStyles.isReadonlySection(element) || RiderStyles.isMath(element)) {
                return null;
            }
            try {
                rectangle = this.modelToView(element.getStartOffset());
            }
            catch (BadLocationException badLocationException) {
                LogUtils.processException(logger, badLocationException);
                return null;
            }
            if (mouseEvent.getY() >= rectangle.y + 2 && mouseEvent.getY() <= rectangle.height + rectangle.y - 2) {
                return element;
            }
        }
        return null;
    }

    public void switchOverTypeMode() {
        this.setOvertypeMode(!RiderArea.isOvertypeMode());
    }

    @Override
    public final String getToolTipText(MouseEvent mouseEvent) {
        TextUI textUI = this.getUI();
        if (textUI != null) {
            return textUI.getToolTipText(this, new Point(mouseEvent.getX(), mouseEvent.getY()));
        }
        return null;
    }

    private void areaMouseMoved(MouseEvent mouseEvent) {
        int n;
        if (RiderArea.isInLeftBorder(mouseEvent)) {
            n = this.viewToModel(mouseEvent.getPoint());
            if (this.getBookmarkElement(mouseEvent, n) != null) {
                if (this.getCursor().getType() != 12) {
                    this.setCursor(Cursor.getPredefinedCursor(12));
                }
            } else if (this.getCursor().getType() != 0) {
                this.setCursor(Cursor.getPredefinedCursor(0));
            }
        } else if (!this.tooltipSet && (n = this.getCursor().getType()) != 2 && n != 3) {
            this.setCursor(Cursor.getPredefinedCursor(2));
        }
        String string = this.getToolTipText(mouseEvent);
        if (string != null) {
            if (!this.tooltipSet) {
                this.setCursor(Cursor.getPredefinedCursor(0));
                this.setToolTipText(string);
                this.tooltipSet = true;
            }
        } else if (this.tooltipSet) {
            this.setToolTipText("");
            this.tooltipSet = false;
            if (this.getCursor().getType() != 2) {
                this.setCursor(Cursor.getPredefinedCursor(2));
            }
        }
    }

    public void selectReverse(int n, int n2) {
        int n3 = this.getDocument().getLength();
        if (n < 0) {
            n = 0;
        }
        if (n2 < 0) {
            n = 0;
        }
        if (n > n3) {
            n = n3;
        }
        if (n2 > n3) {
            n2 = n3;
        }
        this.setCaretPosition(n);
        this.moveCaretPosition(n2);
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
        if (AppPrefs.getProperty("settings.dragndrop", true)) {
            int n = this.getSelectionStart();
            try {
                if (this.lastSelEnd > this.lastSelStart && n >= this.lastSelStart && n < this.lastSelEnd) {
                    this.dragStartedHere = true;
                    this.select(this.lastSelStart, this.lastSelEnd);
                    StyledContent styledContent = new StyledContent(this);
                    StyledContentSelection styledContentSelection = new StyledContentSelection(styledContent);
                    this.dragSource.startDrag(dragGestureEvent, DragSource.DefaultMoveDrop, styledContentSelection, this);
                }
            }
            catch (Exception exception) {
                LogUtils.processException(logger, exception);
            }
        } else {
            dragGestureEvent.getTriggerEvent().consume();
        }
    }

    @Override
    public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
    }

    @Override
    public void dragExit(DragSourceEvent dragSourceEvent) {
    }

    @Override
    public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
        this.dragStartedHere = false;
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
    }

    @Override
    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
    }

    @Override
    public void dragExit(DropTargetEvent dropTargetEvent) {
    }

    @Override
    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        this.dndEventLocation = this.viewToModel(dropTargetDragEvent.getLocation());
        try {
            this.setCaretPosition(this.dndEventLocation);
            CurrentLineHighlighter.updateDnD(this);
        }
        catch (Exception exception) {
            LogUtils.processException(logger, exception);
        }
    }

    @Override
    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        this.dndEventLocation = this.viewToModel(dropTargetDropEvent.getLocation());
        if (this.dndEventLocation >= this.lastSelStart && this.dndEventLocation <= this.lastSelEnd) {
            dropTargetDropEvent.rejectDrop();
            this.select(this.lastSelStart, this.lastSelEnd);
        } else {
            try {
                Transferable transferable = dropTargetDropEvent.getTransferable();
                if (transferable.isDataFlavorSupported(df)) {
                    StyledContent styledContent = (StyledContent)transferable.getTransferData(df);
                    this.doDrop(dropTargetDropEvent, styledContent);
                } else if (transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                    String string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                    this.doDrop(dropTargetDropEvent, string);
                } else {
                    dropTargetDropEvent.rejectDrop();
                }
            }
            catch (Exception exception) {
                LogUtils.processException(logger, exception);
                dropTargetDropEvent.rejectDrop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doDrop(DropTargetDropEvent dropTargetDropEvent, Object object) {
        try {
            this.firePropertyChange("undoredo", false, true);
            int n = 0;
            int n2 = 0;
            dropTargetDropEvent.acceptDrop(2);
            this.addElement(object);
            if (this.dndEventLocation < this.lastSelStart) {
                n = object.toString().length();
            } else {
                n2 = object.toString().length();
            }
            int n3 = this.dndEventLocation + (this.lastSelEnd - this.lastSelStart) - n2;
            int n4 = this.dndEventLocation - n2;
            if (this.dragStartedHere) {
                this.lastSelStart += n;
                this.lastSelEnd += n;
                this.removeElement();
            }
            this.lastSelEnd = n3;
            this.lastSelStart = n4;
            this.select(this.lastSelStart, this.lastSelEnd);
            dropTargetDropEvent.getDropTargetContext().dropComplete(true);
        }
        finally {
            this.firePropertyChange("undoredo", true, false);
        }
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
    }

    private void addElement(Object object) {
        try {
            this.setCaretPosition(this.dndEventLocation);
            if (object instanceof StyledContent) {
                this.replaceSelection((StyledContent)object);
            } else if (object instanceof String) {
                this.replaceSelection((String)object);
            }
        }
        catch (Exception exception) {
            LogUtils.processException(logger, exception);
        }
    }

    private void removeElement() {
        this.select(this.lastSelStart, this.lastSelEnd);
        this.replaceSelection("");
    }

    public synchronized void setBusy(boolean bl) {
        this.busy = bl;
        this.getCaret().setVisible(!bl);
    }

    public synchronized boolean isBusy() {
        return this.busy;
    }

    public int getMaxMarginWidth() {
        return (this.borderType == 0 ? this.getWidth() : this.getMaxTextWidth()) - max1CharWidth;
    }

    static {
        defaultInputMap = null;
        defaultClipboardOwner = new ClipboardObserver();
        logger = Logger.getLogger(RiderArea.class.getName());
        df = new DataFlavor(StyledContent.class, "StyledContent");
        maxTI89FontWidth = 0;
        maxTI92FontWidth = 0;
        alfaBetaKeyListener = new AlphaBetaKeyListener();
        max1CharWidth = 0;
        ScrollGestureRecognizer.getInstance();
    }

    private static final class ClipboardObserver
    implements ClipboardOwner {
        private ClipboardObserver() {
        }

        public final void lostOwnership(Clipboard clipboard, Transferable transferable) {
        }
    }

    private final class MouseMoveAdapter
    extends MouseMotionAdapter {
        private MouseMoveAdapter() {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            RiderArea.this.areaMouseMoved(mouseEvent);
        }
    }

    private final class MouseClickAdapter
    extends MouseAdapter {
        private boolean isImage;
        private RiderArea area;
        private boolean inLeftBorder;

        private MouseClickAdapter() {
        }

        public final void mouseReleased(MouseEvent mouseEvent) {
            RiderArea.this.lastSelStart = RiderArea.this.getSelectionStart();
            RiderArea.this.lastSelEnd = RiderArea.this.getSelectionEnd();
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.area = (RiderArea)mouseEvent.getSource();
            this.isImage = false;
            this.inLeftBorder = RiderArea.isInLeftBorder(mouseEvent);
            if (!this.inLeftBorder) {
                int n = this.area.viewToModel(mouseEvent.getPoint());
                Element element = this.area.getDoc().getCharacterElement(n);
                if (RiderStyles.isImage(element)) {
                    try {
                        Rectangle rectangle = this.area.modelToView(n);
                        if (rectangle.x <= mouseEvent.getX()) {
                            this.isImage = true;
                            this.area.select(element.getStartOffset(), element.getEndOffset());
                        }
                        mouseEvent.consume();
                    }
                    catch (BadLocationException badLocationException) {
                        LogUtils.processException(logger, badLocationException);
                    }
                }
            }
        }

        public final void mouseClicked(MouseEvent mouseEvent) {
            if (this.inLeftBorder) {
                int n = this.area.getCaretPosition();
                Element element = this.area.getBookmarkElement(mouseEvent, this.area.viewToModel(mouseEvent.getPoint()));
                if (element != null) {
                    UpdateBreakpointAction.getInstance().toggleBookmark(this.area.getDoc(), element.getStartOffset());
                    this.area.setCaretPosition(n);
                }
                mouseEvent.consume();
            } else {
                if (this.isImage) {
                    this.area.select(RiderArea.this.lastSelStart, RiderArea.this.lastSelEnd);
                }
                if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                    ContextMenu.getInstance().show(this.area, mouseEvent.getX(), mouseEvent.getY());
                    mouseEvent.consume();
                } else if (mouseEvent.getClickCount() > 1) {
                    if (this.isImage) {
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                ChangeImagePropertiesAction.getInstance().actionPerformed(null);
                            }
                        });
                        mouseEvent.consume();
                    }
                    RiderArea.this.lastSelStart = RiderArea.this.getSelectionStart();
                    RiderArea.this.lastSelEnd = RiderArea.this.getSelectionEnd();
                }
            }
        }
    }
}

