/*
 * Decompiled with CFR 0.152.
 */
package net.wordrider.area;

import java.awt.Font;
import java.awt.Image;
import java.util.Collection;
import java.util.Hashtable;
import java.util.LinkedList;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import net.wordrider.area.AreaImage;
import net.wordrider.area.RiderStyles;
import net.wordrider.area.SeparatorLine;

public final class RiderDocument
extends DefaultStyledDocument {
    private static final char[] EOL_ARRAY = new char[]{'\n'};
    private static final transient FontKey fontSearch = new FontKey(null, 0, 0);
    private static final transient Hashtable<FontKey, Font> fontTable = new Hashtable();
    private Collection<DefaultStyledDocument.ElementSpec> batch = new LinkedList<DefaultStyledDocument.ElementSpec>();
    private static final Element[] ELEMENT = new Element[0];

    public RiderDocument() {
        super(RiderStyles.getDefaultStyleContext());
    }

    public void appendBatchString(char[] cArray, AttributeSet attributeSet) {
        this.batch.add(new DefaultStyledDocument.ElementSpec(attributeSet.copyAttributes(), 3, cArray, 0, cArray.length));
    }

    public void appendBatchString(String string, AttributeSet attributeSet) {
        this.batch.add(new DefaultStyledDocument.ElementSpec(attributeSet.copyAttributes(), 3, string.toCharArray(), 0, string.length()));
    }

    public void appendBatchLineFeed(AttributeSet attributeSet) {
        this.batch.add(new DefaultStyledDocument.ElementSpec(attributeSet, 3, EOL_ARRAY, 0, 1));
        Element element = this.getParagraphElement(0);
        AttributeSet attributeSet2 = element.getAttributes();
        this.batch.add(new DefaultStyledDocument.ElementSpec(null, 2));
        this.batch.add(new DefaultStyledDocument.ElementSpec(attributeSet2, 1));
    }

    public void appendBatchLineFeed(AttributeSet attributeSet, AttributeSet attributeSet2) {
        this.batch.add(new DefaultStyledDocument.ElementSpec(attributeSet.copyAttributes(), 3, EOL_ARRAY, 0, 1));
        this.batch.add(new DefaultStyledDocument.ElementSpec(null, 2));
        this.batch.add(new DefaultStyledDocument.ElementSpec(attributeSet2, 1));
    }

    public void processBatchUpdates(int n, boolean bl) throws BadLocationException {
        DefaultStyledDocument.ElementSpec[] elementSpecArray = new DefaultStyledDocument.ElementSpec[this.batch.size()];
        this.batch.toArray(elementSpecArray);
        this.batch = new LinkedList<DefaultStyledDocument.ElementSpec>();
        super.insert(n, elementSpecArray);
        if (bl && this.getDefaultRootElement().getElementCount() > 2) {
            AttributeSet attributeSet = this.getParagraphElement(1).getAttributes().copyAttributes();
            this.remove(0, 1);
            this.setParagraphAttributes(0, this.getParagraphElement(0).getEndOffset(), attributeSet, true);
        }
        this.remove(this.getLength() - 1, 1);
    }

    public final Font getFont(AttributeSet attributeSet) {
        Integer n;
        int n2;
        int n3 = 0;
        if (StyleConstants.isBold(attributeSet)) {
            n3 |= 1;
        }
        if (StyleConstants.isItalic(attributeSet)) {
            n3 |= 2;
        }
        int n4 = n2 = (n = (Integer)attributeSet.getAttribute(StyleConstants.FontSize)) != null ? n : 13;
        if (StyleConstants.isSuperscript(attributeSet) || StyleConstants.isSubscript(attributeSet)) {
            --n2;
        }
        return RiderDocument.getFont(n3, n2);
    }

    private static Font getFont(int n, int n2) {
        fontSearch.setValue("Ti92Pluspc", n, n2);
        Font font = fontTable.get(fontSearch);
        if (font == null) {
            font = RiderStyles.getAreaFont().deriveFont(n, n2);
            FontKey fontKey = new FontKey("Ti92Pluspc", n, n2);
            fontTable.put(fontKey, font);
        }
        return font;
    }

    public final void toggleBookmark(int n) {
        this.toggleBookmark(this.getParagraphElement(n));
    }

    public void removeBookmark(Element element) {
        AttributeSet attributeSet = this.getAttributeContext().removeAttributes(element.getAttributes(), RiderStyles.bookmarkStyle.getAttributeNames());
        this.setParagraphAttributes(element.getStartOffset(), 0, attributeSet, true);
    }

    public final void toggleBookmark(Element element) {
        if (RiderStyles.isMath(element) || RiderStyles.isReadonlySection(element)) {
            return;
        }
        int n = element.getEndOffset() - element.getStartOffset();
        if (RiderStyles.isBookmark(element)) {
            this.removeBookmark(element);
        } else {
            this.setParagraphAttributes(element.getStartOffset(), n, RiderStyles.updateBookmark(element), false);
        }
        this.refresh(element.getStartOffset(), n);
    }

    public void setPrettyPrint(Element element) {
        int n = element.getEndOffset() - element.getStartOffset();
        if (RiderStyles.isMath(element)) {
            AttributeSet attributeSet = this.getAttributeContext().removeAttributes(element.getAttributes(), RiderStyles.mathStyle.getAttributeNames());
            this.setParagraphAttributes(element.getStartOffset(), n, attributeSet, true);
        } else {
            this.removeBookmark(element);
            this.setCharacterAttributes(element.getStartOffset(), n, new SimpleAttributeSet(), true);
            this.setParagraphAttributes(element.getStartOffset(), n, RiderStyles.mathStyle, true);
        }
        this.refresh(element.getStartOffset(), n);
    }

    public final void refresh(int n, int n2) {
        AbstractDocument.DefaultDocumentEvent defaultDocumentEvent = new AbstractDocument.DefaultDocumentEvent(this, n, n2, DocumentEvent.EventType.CHANGE);
        Element element = this.getDefaultRootElement();
        Element[] elementArray = ELEMENT;
        Element[] elementArray2 = ELEMENT;
        defaultDocumentEvent.addEdit(new AbstractDocument.ElementEdit(element, 0, elementArray, elementArray2));
        defaultDocumentEvent.end();
        this.fireChangedUpdate(defaultDocumentEvent);
    }

    public final void refreshAll() {
        this.refresh(0, this.getLength());
    }

    public final void insertPicture(int n, AreaImage areaImage) throws BadLocationException {
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        StyleConstants.setIcon(simpleAttributeSet, areaImage);
        this.insertString(n, " ", simpleAttributeSet);
    }

    public final void insertPicture(int n, Image image) throws BadLocationException {
        this.insertPicture(n, new AreaImage(image));
    }

    public final void appendSeparateLine(JTextComponent jTextComponent, int n) {
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        StyleConstants.setComponent(simpleAttributeSet, new SeparatorLine(jTextComponent, n));
        this.appendBatchString(" ", (AttributeSet)simpleAttributeSet);
    }

    public final void insertSeparateLine(JTextComponent jTextComponent, int n, int n2) throws BadLocationException {
        this.setParagraphAttributes(n, 0, RiderStyles.alignmentLeftStyle, true);
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        StyleConstants.setComponent(simpleAttributeSet, new SeparatorLine(jTextComponent, n2));
        this.insertString(n, " ", simpleAttributeSet);
    }

    static class FontKey {
        private String family;
        private int style;
        private int size;

        public FontKey(String string, int n, int n2) {
            this.setValue(string, n, n2);
        }

        public void setValue(String string, int n, int n2) {
            this.family = string != null ? string.intern() : null;
            this.style = n;
            this.size = n2;
        }

        public int hashCode() {
            int n = this.family != null ? this.family.hashCode() : 0;
            return n ^ this.style ^ this.size;
        }

        public boolean equals(Object object) {
            if (object instanceof FontKey) {
                FontKey fontKey = (FontKey)object;
                return this.size == fontKey.size && this.style == fontKey.style && this.family == fontKey.family;
            }
            return false;
        }
    }
}

