/*
 * Decompiled with CFR 0.152.
 */
package net.wordrider.core.actions;

import java.util.Collection;
import java.util.LinkedList;
import javax.swing.JProgressBar;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.SimpleAttributeSet;
import net.wordrider.area.RiderStyles;
import net.wordrider.core.AppPrefs;
import net.wordrider.core.actions.BatchRead;
import net.wordrider.core.managers.interfaces.IFileInstance;

final class BatchNotefolioRead
extends BatchRead {
    private Collection<Integer> bookmarkList;
    private boolean setBookmark;
    private int linesCount;
    private boolean addBookmarks;

    public BatchNotefolioRead(IFileInstance iFileInstance, String string) {
        super(iFileInstance, string);
    }

    public final Document process(JProgressBar jProgressBar) throws BadLocationException {
        this.bookmarkList = new LinkedList<Integer>();
        this.setBookmark = true;
        this.linesCount = 0;
        int n = this.content.length() - 1;
        char[] cArray = this.content.toCharArray();
        BatchNotefolioRead.initProgressBar(jProgressBar, n);
        int n2 = n / 100 * 4;
        if (n2 <= 0) {
            n2 = 1;
        }
        int n3 = 0;
        int n4 = AppPrefs.getProperty("settings.notefolioSeparator", 1);
        this.addBookmarks = AppPrefs.getProperty("settings.notefolioBreakpoint", true);
        boolean bl = n4 == 10;
        this.insertNewLine();
        block17: for (int i = 0; i < n; ++i) {
            if (i % n2 == 0) {
                jProgressBar.setValue(i);
            }
            char c = cArray[i];
            switch (n3) {
                case 0: {
                    switch (c) {
                        case '\r': {
                            this.insertNewLine();
                            n3 = 2;
                            continue block17;
                        }
                        case '\f': {
                            if (bl) {
                                this.insertNewLine();
                                this.setBookmark = true;
                                this.insertNewLine();
                                n3 = 2;
                                continue block17;
                            }
                            this.appendSeparateLine(n4);
                            n3 = 1;
                            this.setBookmark = true;
                            continue block17;
                        }
                    }
                    this.appendChar(c);
                    continue block17;
                }
                case 2: {
                    switch (c) {
                        case '\r': {
                            this.insertNewLine();
                            continue block17;
                        }
                        case '\f': {
                            if (bl) {
                                this.setBookmark = true;
                                this.insertNewLine();
                                continue block17;
                            }
                            this.appendSeparateLine2(n4);
                            n3 = 1;
                            this.setBookmark = true;
                            continue block17;
                        }
                    }
                    this.appendChar(c);
                    n3 = 0;
                    continue block17;
                }
                case 1: {
                    switch (c) {
                        case '\r': {
                            this.insertNewLine();
                            n3 = 2;
                            continue block17;
                        }
                        case '\f': {
                            this.appendSeparateLine(n4);
                            this.setBookmark = true;
                            continue block17;
                        }
                    }
                    this.insertNewLine();
                    this.appendChar(c);
                    n3 = 0;
                    continue block17;
                }
                default: {
                    assert (false);
                    continue block17;
                }
            }
        }
        this.insertContent();
        this.insertNewLine();
        this.doc.processBatchUpdates(0, true);
        if (!this.bookmarkList.isEmpty()) {
            Element element = this.doc.getDefaultRootElement();
            for (int n5 : this.bookmarkList) {
                Element element2 = element.getElement(n5 - 1);
                if (element2 == null || element2.getAttributes().getAttribute("BOOKMARK") == null) continue;
                this.doc.setParagraphAttributes(element2.getStartOffset(), 0, RiderStyles.updateBookmark(element2), false);
            }
        }
        jProgressBar.setValue(n);
        return this.doc;
    }

    void insertNewLineWithAttr(AttributeSet attributeSet) {
        super.insertNewLineWithAttr(attributeSet);
        ++this.linesCount;
    }

    protected void insertNewLine() {
        if (this.addBookmarks && this.setBookmark) {
            SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet(this.paraA);
            simpleAttributeSet.addAttribute("BOOKMARK", "");
            this.insertNewLineWithAttr(simpleAttributeSet);
            this.bookmarkList.add(this.linesCount);
            this.setBookmark = false;
        } else {
            this.insertNewLineWithAttr(this.paraA);
        }
    }
}

