/*
 * Decompiled with CFR 0.152.
 */
package net.wordrider.core.actions;

import java.util.HashMap;
import java.util.Map;
import javax.swing.JProgressBar;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import net.wordrider.core.Lng;
import net.wordrider.core.actions.BatchRead;
import net.wordrider.core.managers.interfaces.IFileInstance;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BatchPureTextReader
extends BatchRead {
    private static final Map<Character, Character> conversion_table = BatchPureTextReader.getConversionTable();

    public BatchPureTextReader(IFileInstance iFileInstance, String string) {
        super(iFileInstance, string);
    }

    @Override
    public Document process(JProgressBar jProgressBar) throws BadLocationException {
        int n = this.content.length() - 1;
        char[] cArray = this.content.toCharArray();
        BatchPureTextReader.initProgressBar(jProgressBar, n);
        int n2 = n / 100 * 4;
        if (n2 <= 0) {
            n2 = 1;
        }
        for (int i = 0; i < n; ++i) {
            char c;
            if (i % n2 == 0) {
                jProgressBar.setValue(i);
            }
            if ((c = cArray[i]) == '\n') {
                this.insertNewLine();
                continue;
            }
            this.appendChar(c);
        }
        this.insertContent();
        this.insertNewLine();
        this.doc.processBatchUpdates(0, false);
        jProgressBar.setValue(n);
        return this.doc;
    }

    @Override
    void appendChar(char c) {
        this.textBuffer.append(BatchPureTextReader.getUnicodeFromText(c));
    }

    private static char getUnicodeFromText(char c) {
        Character c2 = conversion_table.get(Character.valueOf(c));
        return c2 != null ? c2.charValue() : c;
    }

    private static Map<Character, Character> getConversionTable() {
        if (conversion_table != null) {
            return conversion_table;
        }
        logger.info("Creating conversion static ascii table");
        HashMap<Character, Character> hashMap = new HashMap<Character, Character>(56 + TI2UNICODE.size());
        hashMap.put(Character.valueOf('\u03b1'), Character.valueOf('\u20ac'));
        hashMap.put(Character.valueOf('\u03b2'), Character.valueOf('\u0081'));
        hashMap.put(Character.valueOf('\u0393'), Character.valueOf('\u201a'));
        hashMap.put(Character.valueOf('\u03b3'), Character.valueOf('\u0192'));
        hashMap.put(Character.valueOf('\u0394'), Character.valueOf('\u201e'));
        hashMap.put(Character.valueOf('\u03b4'), Character.valueOf('\u2026'));
        hashMap.put(Character.valueOf('\u03b5'), Character.valueOf('\u2020'));
        hashMap.put(Character.valueOf('\u03b6'), Character.valueOf('\u2021'));
        hashMap.put(Character.valueOf('\u03b8'), Character.valueOf('\u02c6'));
        hashMap.put(Character.valueOf('\u03bb'), Character.valueOf('\u2030'));
        hashMap.put(Character.valueOf('\u03be'), Character.valueOf('\u0160'));
        hashMap.put(Character.valueOf('\u03a0'), Character.valueOf('\u2039'));
        hashMap.put(Character.valueOf('\u03c0'), Character.valueOf('\u0152'));
        hashMap.put(Character.valueOf('\u03c1'), Character.valueOf('\u008d'));
        hashMap.put(Character.valueOf('\u03a3'), Character.valueOf('\u017d'));
        hashMap.put(Character.valueOf('\u03c3'), Character.valueOf('\u008f'));
        hashMap.put(Character.valueOf('\u03c4'), Character.valueOf('\u0090'));
        hashMap.put(Character.valueOf('\u03c6'), Character.valueOf('\u2018'));
        hashMap.put(Character.valueOf('\u03c8'), Character.valueOf('\u2019'));
        hashMap.put(Character.valueOf('\u2126'), Character.valueOf('\u201c'));
        hashMap.put(Character.valueOf('\u03c9'), Character.valueOf('\u201d'));
        hashMap.put(Character.valueOf('\u2264'), Character.valueOf('\u0153'));
        hashMap.put(Character.valueOf('\u2260'), Character.valueOf('\u009d'));
        hashMap.put(Character.valueOf('\u2265'), Character.valueOf('\u017e'));
        hashMap.put(Character.valueOf('\u2026'), Character.valueOf('\u00a1'));
        hashMap.put(Character.valueOf('\u00a1'), Character.valueOf('\u00a2'));
        hashMap.put(Character.valueOf('\u00a2'), Character.valueOf('\u00a3'));
        hashMap.put(Character.valueOf('\u00a3'), Character.valueOf('\u00a4'));
        hashMap.put(Character.valueOf('\u00a4'), Character.valueOf('\u00a5'));
        hashMap.put(Character.valueOf('\u00a5'), Character.valueOf('\u00a6'));
        hashMap.put(Character.valueOf('\u00a6'), Character.valueOf('|'));
        hashMap.put(Character.valueOf('\u221a'), Character.valueOf('\u00a7'));
        hashMap.put(Character.valueOf('\u00ab'), Character.valueOf('\u00d7'));
        hashMap.put(Character.valueOf('\u2310'), Character.valueOf('\u00a9'));
        hashMap.put(Character.valueOf('\u2212'), Character.valueOf('\u00aa'));
        hashMap.put(Character.valueOf('\u00b0'), Character.valueOf('\u00ac'));
        hashMap.put(Character.valueOf('\u2022'), Character.valueOf('\u00ad'));
        hashMap.put(Character.valueOf('\u00b2'), Character.valueOf('\u00ae'));
        hashMap.put(Character.valueOf('\u00b3'), Character.valueOf('\u00af'));
        hashMap.put(Character.valueOf('\u03bc'), Character.valueOf('\u00b1'));
        hashMap.put(Character.valueOf('\u2219'), Character.valueOf('\u00b2'));
        hashMap.put(Character.valueOf('\u00d7'), Character.valueOf('\u00b3'));
        hashMap.put(Character.valueOf('\u00b9'), Character.valueOf('\u00b4'));
        hashMap.put(Character.valueOf('\u00ba'), Character.valueOf('\u00b5'));
        hashMap.put(Character.valueOf('\u00bb'), Character.valueOf('\u00de'));
        hashMap.put(Character.valueOf('\u222b'), Character.valueOf('\u00b7'));
        hashMap.put(Character.valueOf('\u2022'), Character.valueOf('\u00b2'));
        hashMap.put(Character.valueOf('\u221e'), Character.valueOf('\u00b8'));
        hashMap.put(Character.valueOf('\u00bf'), Character.valueOf('\u00b9'));
        hashMap.put(Character.valueOf('\u2202'), Character.valueOf('@'));
        hashMap.put(Character.valueOf('\u25ba'), Character.valueOf('\u00d0'));
        hashMap.put(Character.valueOf('\u2192'), Character.valueOf('\u00bb'));
        hashMap.put(Character.valueOf('\u25cf'), Character.valueOf('-'));
        hashMap.put(Character.valueOf('\u2013'), Character.valueOf('-'));
        hashMap.put(Character.valueOf('\t'), Character.valueOf(' '));
        hashMap.putAll(TI2UNICODE);
        if (Lng.localeLanguageCode != null && Lng.localeLanguageCode.equals("CS")) {
            hashMap.put(Character.valueOf('\u201e'), Character.valueOf('\"'));
            hashMap.put(Character.valueOf('\u201c'), Character.valueOf('\"'));
            hashMap.put(Character.valueOf('\u00e9'), Character.valueOf('e'));
            hashMap.put(Character.valueOf('\u00e1'), Character.valueOf('a'));
            hashMap.put(Character.valueOf('\u00ed'), Character.valueOf('i'));
            hashMap.put(Character.valueOf('\u00f3'), Character.valueOf('o'));
            hashMap.put(Character.valueOf('\u00fa'), Character.valueOf('u'));
            hashMap.put(Character.valueOf('\u016f'), Character.valueOf('u'));
            hashMap.put(Character.valueOf('\u00da'), Character.valueOf('U'));
            hashMap.put(Character.valueOf('\u00c1'), Character.valueOf('A'));
            hashMap.put(Character.valueOf('\u00c9'), Character.valueOf('E'));
            hashMap.put(Character.valueOf('\u00d3'), Character.valueOf('O'));
            hashMap.put(Character.valueOf('\u00cd'), Character.valueOf('I'));
            hashMap.put(Character.valueOf('\u016e'), Character.valueOf('U'));
            hashMap.put(Character.valueOf('\u00dd'), Character.valueOf('Y'));
            hashMap.put(Character.valueOf('\u017e'), Character.valueOf('z'));
            hashMap.put(Character.valueOf('\u017d'), Character.valueOf('Z'));
            hashMap.put(Character.valueOf('\u0161'), Character.valueOf('s'));
            hashMap.put(Character.valueOf('\u0160'), Character.valueOf('S'));
            hashMap.put(Character.valueOf('\u011b'), Character.valueOf('e'));
            hashMap.put(Character.valueOf('\u00fd'), Character.valueOf('y'));
            hashMap.put(Character.valueOf('\u011a'), Character.valueOf('E'));
            hashMap.put(Character.valueOf('\u010d'), Character.valueOf('c'));
            hashMap.put(Character.valueOf('\u010c'), Character.valueOf('C'));
            hashMap.put(Character.valueOf('\u0159'), Character.valueOf('r'));
            hashMap.put(Character.valueOf('\u0158'), Character.valueOf('R'));
            hashMap.put(Character.valueOf('\u010e'), Character.valueOf('D'));
            hashMap.put(Character.valueOf('\u0164'), Character.valueOf('T'));
            hashMap.put(Character.valueOf('\u010f'), Character.valueOf('d'));
            hashMap.put(Character.valueOf('\u0147'), Character.valueOf('N'));
            hashMap.put(Character.valueOf('\u0148'), Character.valueOf('n'));
            hashMap.put(Character.valueOf('\u0165'), Character.valueOf('t'));
        }
        return hashMap;
    }

    public static String importText(String string) {
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            cArray[i] = BatchPureTextReader.getUnicodeFromText(cArray[i]);
        }
        return new String(cArray);
    }
}

