/*
 * Decompiled with CFR 0.152.
 */
package net.wordrider.core.actions;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.JProgressBar;
import javax.swing.text.AttributeSet;
import javax.swing.text.JTextComponent;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import net.wordrider.area.RiderDocument;
import net.wordrider.area.RiderStyles;
import net.wordrider.core.actions.BatchTextRead;
import net.wordrider.core.actions.DocumentProducer;
import net.wordrider.core.managers.interfaces.IFileInstance;
import net.wordrider.plugintools.CharacterList;

abstract class BatchRead
implements DocumentProducer {
    protected static final Map<Character, Character> TI2UNICODE;
    static final String CALC_FOLDER_SEPARATOR = "\\\\";
    private final JTextComponent area;
    static final Logger logger;
    final String content;
    StringBuilder textBuffer;
    RiderDocument doc;
    MutableAttributeSet paraA;
    MutableAttributeSet attr;

    public BatchRead(IFileInstance iFileInstance, String string) {
        this.content = string;
        this.area = iFileInstance.getRiderArea();
        this.textBuffer = new StringBuilder();
        this.doc = new RiderDocument();
        this.attr = new SimpleAttributeSet(RiderStyles.normalStyle);
        this.paraA = RiderStyles.alignmentLeftStyle;
    }

    private static char getUnicodeFromTIChar(char c) {
        if (c >= '\u0080' && c <= '\u00ff') {
            return CharacterList.TI92PC_UNICODE_FONT[c - 128];
        }
        if (c < ' ') {
            Character c2 = TI2UNICODE.get(Character.valueOf(c));
            return c2 != null ? c2.charValue() : c;
        }
        return c;
    }

    static void initProgressBar(JProgressBar jProgressBar, int n) {
        jProgressBar.setMinimum(0);
        jProgressBar.setMaximum(n);
        jProgressBar.setValue(0);
    }

    void appendChar(char c) {
        this.textBuffer.append(BatchRead.getUnicodeFromTIChar(c));
    }

    void insertContent() {
        if (this.textBuffer.length() > 0) {
            this.doc.appendBatchString(this.textBuffer.toString().toCharArray(), (AttributeSet)this.attr);
            this.initNewBuffer();
        }
    }

    void initNewBuffer() {
        this.textBuffer.setLength(0);
    }

    void insertNewLineWithAttr(AttributeSet attributeSet) {
        this.insertContent();
        this.doc.appendBatchLineFeed(this.attr, attributeSet);
    }

    void appendSeparateLine(int n) {
        this.insertNewLineWithAttr(RiderStyles.alignmentLeftStyle);
        this.doc.appendSeparateLine(this.area, n);
    }

    void appendSeparateLine2(int n) {
        this.doc.appendSeparateLine(this.area, n);
    }

    protected void insertNewLine() {
        this.insertNewLineWithAttr(this.paraA);
    }

    static {
        logger = Logger.getLogger(BatchTextRead.class.getName());
        TI2UNICODE = new HashMap<Character, Character>(7);
        TI2UNICODE.put(Character.valueOf('\u0012'), Character.valueOf('\u00d0'));
        TI2UNICODE.put(Character.valueOf('\u0016'), Character.valueOf('\u00bb'));
        TI2UNICODE.put(Character.valueOf('\u001c'), Character.valueOf('\u00bc'));
        TI2UNICODE.put(Character.valueOf('\u001d'), Character.valueOf('\u00bd'));
        TI2UNICODE.put(Character.valueOf('\u001e'), Character.valueOf('\u00be'));
        TI2UNICODE.put(Character.valueOf('\u001f'), Character.valueOf('\u00bf'));
        TI2UNICODE.put(Character.valueOf('\u0010'), Character.valueOf('_'));
    }
}

