/*
 * Decompiled with CFR 0.152.
 */
package net.wordrider.core.actions;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import net.wordrider.core.actions.GroupFileOptions;
import net.wordrider.files.InvalidDataTypeException;
import net.wordrider.files.NotSupportedFileException;
import net.wordrider.files.ti68kformat.FastTextFileReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupFileProcess {
    private Collection<Event> accidentsLog;

    public GroupFileProcess(File file, GroupFileOptions groupFileOptions) {
        File file2 = file;
        GroupFileOptions groupFileOptions2 = groupFileOptions;
    }

    public void processFiles(Collection<File> collection) {
        this.accidentsLog = new ArrayList<Event>(collection.size() * 2);
        for (File file : collection) {
            if (!file.exists()) {
                this.generateEvent(1, file);
                continue;
            }
            FastTextFileReader fastTextFileReader = new FastTextFileReader();
            try {
                fastTextFileReader.openFromFile(file);
                this.generateEvent(0, file);
            }
            catch (InvalidDataTypeException invalidDataTypeException) {
                this.generateEvent(2, file);
            }
            catch (NotSupportedFileException notSupportedFileException) {
                this.generateEvent(2, file);
            }
            catch (IOException iOException) {
                this.generateEvent(5, file);
            }
        }
    }

    private void generateEvent(int n, File file) {
        this.accidentsLog.add(Event.generate(n, file));
    }

    private static class Event {
        public static final int LOADFILE_OK = 0;
        public static final int LOADFILE_NOTFOUND = 1;
        public static final int LOADFILE_BADFILETYPE = 2;
        public static final int LOADFILE_PIC_NOTFOUND = 3;
        public static final int LOADFILE_PIC_BADFILETYPE = 4;
        public static final int LOADFILE_ERROR = 5;
        private int type;
        private File detailInfo;

        public Event(int n, File file) {
            this.type = n;
            this.detailInfo = file;
        }

        public int getType() {
            return this.type;
        }

        public void setType(int n) {
            this.type = n;
        }

        public File getDetailInfo() {
            return this.detailInfo;
        }

        public void setDetailInfo(File file) {
            this.detailInfo = file;
        }

        public static Event generate(int n, File file) {
            return new Event(n, file);
        }
    }
}

