/*
 * Decompiled with CFR 0.152.
 */
package net.wordrider.core.actions;

import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.SwingUtilities;
import net.wordrider.core.actions.CoreAction;
import net.wordrider.core.actions.OpenFileAction;
import net.wordrider.core.managers.AreaManager;
import net.wordrider.utilities.Utils;

public final class OpenRecentFileAction
extends CoreAction {
    private final File recentFile;

    public OpenRecentFileAction(File file, char c) {
        super("OpenRecentFileAction", c + " " + Utils.shortenFileName(file.toString(), 50), Integer.valueOf(c), null);
        this.recentFile = file;
        this.putValue("ShortDescription", file.toString());
    }

    public final void actionPerformed(ActionEvent actionEvent) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                AreaManager areaManager = AreaManager.getInstance();
                if (!OpenFileAction.open(OpenRecentFileAction.this.recentFile)) {
                    areaManager.getRecentFilesManager().removeBadFile(OpenRecentFileAction.this.recentFile);
                } else {
                    areaManager.grabActiveFocus();
                }
            }
        });
    }
}

