/*
 * Decompiled with CFR 0.152.
 */
package net.wordrider.core.actions;

import java.awt.Cursor;
import java.io.File;
import java.io.IOException;
import net.wordrider.area.RiderArea;
import net.wordrider.core.AppPrefs;
import net.wordrider.core.Lng;
import net.wordrider.core.actions.AbstractFileProcessor;
import net.wordrider.core.actions.BatchTextRead;
import net.wordrider.core.managers.AreaManager;
import net.wordrider.core.managers.FileInstance;
import net.wordrider.dialogs.ChooseFormatDialog;
import net.wordrider.files.ti68kformat.TITextFileReader;
import net.wordrider.utilities.LogUtils;
import net.wordrider.utilities.Swinger;

class TextFileProcessor
extends AbstractFileProcessor {
    public TextFileProcessor(File file) {
        super(file);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean process() {
        boolean bl;
        Object object;
        super.process();
        if (AppPrefs.getProperty("settings.inputFormatRemember", true) && ((ChooseFormatDialog)(object = new ChooseFormatDialog(this.getMainFrame(), 0))).getResult() != 0) {
            return false;
        }
        object = AreaManager.getInstance();
        FileInstance fileInstance = (FileInstance)((AreaManager)object).isFileAlreadyOpened(this.getFile());
        if (fileInstance != null) {
            if (Swinger.getChoice(this.getMainFrame(), Lng.getLabel("message.confirm.FAE")) != 0) return false;
            bl = true;
        } else {
            bl = false;
        }
        try {
            TITextFileReader tITextFileReader = new TITextFileReader();
            tITextFileReader.openFromFile(this.getFile());
            if (!bl) {
                fileInstance = new FileInstance(this.getFile(), tITextFileReader.getTextFileInfo());
                fileInstance.getFileInfo().setOutputFormat(AppPrefs.getProperty("settings.inputFormatHibview", true) ? 0 : 1);
                ((AreaManager)object).openFileInstance(fileInstance);
            }
            RiderArea riderArea = fileInstance.getRiderArea();
            riderArea.setCursor(Cursor.getPredefinedCursor(3));
            if (!bl) return this.loadDocument(riderArea, new BatchTextRead(fileInstance, tITextFileReader.getContent()));
            ((AreaManager)object).setActivateFileInstance(fileInstance);
            return this.loadDocument(riderArea, new BatchTextRead(fileInstance, tITextFileReader.getContent()));
        }
        catch (IOException iOException) {
            LogUtils.processException(logger, iOException);
            Swinger.showErrorDialog(this.getMainFrame(), Lng.getLabel("message.error.reading", iOException.getMessage()));
            return false;
        }
        catch (Exception exception) {
            logger.warning(exception.getMessage());
            Swinger.showErrorDialog(this.getMainFrame(), exception.getMessage());
            return false;
        }
    }
}

