/*
 * Decompiled with CFR 0.152.
 */
package net.wordrider.core.swing;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.View;
import net.wordrider.core.swing.ColorHighlightPainter;

class JaggedUnderlinePainter
extends ColorHighlightPainter {
    public JaggedUnderlinePainter(int n) {
        super(n);
    }

    public Shape paintLayer(Graphics graphics, int n, int n2, Shape shape, JTextComponent jTextComponent, View view) {
        Color color = this.getColor();
        Color color2 = graphics.getColor();
        graphics.setColor(color);
        if (n == view.getStartOffset() && n2 == view.getEndOffset()) {
            Rectangle rectangle = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
            this.drawJaggedLine(rectangle, graphics);
            return rectangle;
        }
        try {
            Shape shape2 = view.modelToView(n, Position.Bias.Forward, n2, Position.Bias.Backward, shape);
            Rectangle rectangle = shape2 instanceof Rectangle ? (Rectangle)shape2 : shape2.getBounds();
            this.drawJaggedLine(rectangle, graphics);
            return rectangle;
        }
        catch (BadLocationException badLocationException) {
            graphics.setColor(color2);
            return null;
        }
    }

    private void drawJaggedLine(Rectangle rectangle, Graphics graphics) {
        int n = rectangle.y + rectangle.height;
        int n2 = rectangle.x;
        int n3 = n2 + rectangle.width - 6;
        for (int i = n2 - 6; i <= n3; i += 6) {
            graphics.drawArc(i + 3, n - 3, 3, 3, 0, 180);
            graphics.drawArc(i + 6, n - 3, 3, 3, 180, 181);
        }
    }
}

