/*
 * Decompiled with CFR 0.152.
 */
package net.wordrider.dialogs.layouts;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.SwingConstants;

public class EqualsLayout
implements LayoutManager,
SwingConstants {
    private int gap;
    private int alignment;

    public EqualsLayout(int n, int n2) {
        this.setGap(n2);
        this.setAlignment(n);
    }

    public EqualsLayout(int n) {
        this(4, n);
    }

    public int getAlignment() {
        return this.alignment;
    }

    private void setAlignment(int n) {
        this.alignment = n;
    }

    public int getGap() {
        return this.gap;
    }

    private void setGap(int n) {
        this.gap = n;
    }

    private Dimension[] dimensions(Component[] componentArray) {
        int n;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = componentArray.length;
        for (n = 0; n < n5; ++n) {
            if (!componentArray[n].isVisible()) continue;
            Dimension dimension = componentArray[n].getPreferredSize();
            Dimension dimension2 = componentArray[n].getMinimumSize();
            n2 = Math.max(n2, Math.max(dimension.width, dimension2.width));
            n3 = Math.max(n3, Math.max(dimension.height, dimension2.height));
            ++n4;
        }
        n = this.alignment == 1 ? n2 : n2 * n4 + this.gap * (n4 - 1);
        n5 = this.alignment == 1 ? n3 * n4 + this.gap * (n4 - 1) : n3;
        return new Dimension[]{new Dimension(n2, n3), new Dimension(n, n5)};
    }

    public void layoutContainer(Container container) {
        Insets insets = container.getInsets();
        Component[] componentArray = container.getComponents();
        Dimension[] dimensionArray = this.dimensions(componentArray);
        int n = dimensionArray[0].width;
        int n2 = dimensionArray[0].height;
        int n3 = dimensionArray[1].width;
        switch (this.alignment) {
            case 1: {
                int n4 = componentArray.length;
                for (int i = 0; i < n4; ++i) {
                    if (!componentArray[i].isVisible()) continue;
                    componentArray[i].setBounds(insets.left, insets.top + (n2 + this.gap) * i, n, n2);
                }
                break;
            }
            case 2: {
                int n5 = componentArray.length;
                for (int i = 0; i < n5; ++i) {
                    if (!componentArray[i].isVisible()) continue;
                    componentArray[i].setBounds(insets.left + (n + this.gap) * i, insets.top, n, n2);
                }
                break;
            }
            case 3: 
            case 4: {
                int n6 = componentArray.length;
                for (int i = 0; i < n6; ++i) {
                    if (!componentArray[i].isVisible()) continue;
                    componentArray[i].setBounds(container.getWidth() - insets.right - n3 + (n + this.gap) * i, insets.top, n, n2);
                }
                break;
            }
        }
    }

    public Dimension minimumLayoutSize(Container container) {
        return this.preferredLayoutSize(container);
    }

    public Dimension preferredLayoutSize(Container container) {
        Insets insets = container.getInsets();
        Component[] componentArray = container.getComponents();
        Dimension[] dimensionArray = this.dimensions(componentArray);
        int n = dimensionArray[1].width;
        int n2 = dimensionArray[1].height;
        return new Dimension(insets.left + n + insets.right, insets.top + n2 + insets.bottom);
    }

    public void addLayoutComponent(String string, Component component) {
    }

    public void removeLayoutComponent(Component component) {
    }
}

