/*
 * Decompiled with CFR 0.152.
 */
package net.wordrider.files.ti68kformat;

import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import net.wordrider.files.ti68kformat.TIFileReader;

public abstract class FastTIFileReader
extends TIFileReader {
    byte[] byteContent = null;
    private byte[] checksum = null;
    private File file = null;

    public byte[] getChecksum() {
        return this.checksum;
    }

    public byte[] getByteContent() {
        return this.byteContent;
    }

    public File getFile() {
        return this.file;
    }

    public void setByteContent(byte[] byArray) {
        this.byteContent = byArray;
        this.updateChecksum();
    }

    private void updateChecksum() {
        int n;
        int n2 = this.byteContent.length;
        int n3 = 0;
        for (n = 0; n < n2; ++n) {
            n3 += this.byteContent[n];
        }
        n = (char)n3;
        this.checksum[0] = (byte)n;
        this.checksum[1] = (byte)(n >> 8);
    }

    protected void storeFileInformation(File file) {
        this.file = file;
    }

    protected void readContent(DataInputStream dataInputStream) throws IOException {
        int n = (int)this.file.length() - 82 - 2;
        if (n <= 0) {
            throw new IOException("Invalid file size");
        }
        this.byteContent = new byte[n];
        dataInputStream.readFully(this.byteContent);
        this.fileInfo.setVarName(this.fileInfo.getVarName());
        this.fileInfo.setFolderName(this.fileInfo.getFolderName());
    }

    protected char getCheckSum() {
        return '\u0000';
    }

    protected char readChecksum(DataInputStream dataInputStream) throws IOException {
        this.checksum = new byte[2];
        dataInputStream.readFully(this.checksum);
        return '\u0000';
    }
}

