/*
 * Decompiled with CFR 0.152.
 */
package net.wordrider.area;

import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.JTextPane;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.StyleConstants;
import javax.swing.text.Utilities;
import net.wordrider.area.AreaImage;
import net.wordrider.area.RiderArea;
import net.wordrider.area.RiderDocument;
import net.wordrider.area.RiderStyles;
import net.wordrider.area.SelectedElementsIterator;
import net.wordrider.area.SeparatorLine;

final class StyledContent {
    private final List<StyledCopyContent> clipContent = new Vector<StyledCopyContent>(10);

    public StyledContent(RiderArea riderArea) throws BadLocationException {
        Element element;
        Document document = riderArea.getDocument();
        int n = riderArea.getSelectionStart();
        int n2 = riderArea.getSelectionEnd();
        int n3 = Math.max(n, n2);
        SelectedElementsIterator selectedElementsIterator = new SelectedElementsIterator(document.getDefaultRootElement(), Math.min(n, n2), n3, 1);
        while ((element = selectedElementsIterator.next()) != null) {
            int n4 = element.getStartOffset();
            int n5 = element.getEndOffset();
            if (element.getName().equals("content")) {
                if (selectedElementsIterator.isFirstLeafElement()) {
                    this.clipContent.add(new StyledCopyContent(riderArea.getText(n, selectedElementsIterator.isLastLeafElement() ? n2 - n : n5 - n), element.getAttributes()));
                    continue;
                }
                this.clipContent.add(new StyledCopyContent(riderArea.getText(n4, selectedElementsIterator.isLastLeafElement() ? n2 - n4 : n5 - n4), element.getAttributes()));
                continue;
            }
            if (RiderStyles.isSupportedComponent(element)) {
                this.clipContent.add(new StyledCopyContent(((SeparatorLine)element.getAttributes().getAttribute(StyleConstants.ComponentAttribute)).getLineType()));
                continue;
            }
            if (!RiderStyles.isImage(element)) continue;
            this.clipContent.add(new StyledCopyContent(RiderStyles.getImage(element)));
        }
    }

    public final void insert(JTextPane jTextPane, int n) throws BadLocationException {
        RiderDocument riderDocument = (RiderDocument)jTextPane.getDocument();
        Iterator<StyledCopyContent> iterator = this.clipContent.iterator();
        while (iterator.hasNext()) {
            StyledCopyContent styledCopyContent;
            StyledCopyContent styledCopyContent2 = styledCopyContent = iterator.next();
            switch (styledCopyContent2.getContentType()) {
                case 0: {
                    String string = (String)styledCopyContent2.getContent();
                    if (string.equals("")) break;
                    if (RiderStyles.isReadonlySection(riderDocument.getParagraphElement(n))) {
                        riderDocument.insertString(n, "\n", null);
                        if (Utilities.getRowStart(jTextPane, n) != n) {
                            ++n;
                        }
                    }
                    riderDocument.insertString(n, string, styledCopyContent2.getAttr());
                    n += string.length();
                    break;
                }
                case 1: 
                case 2: {
                    if (RiderStyles.isReadonlySection(riderDocument.getParagraphElement(n))) {
                        riderDocument.insertString(n, "\n", null);
                        if (Utilities.getRowStart(jTextPane, n) != n) {
                            ++n;
                        }
                    } else if (n - 1 > 0 && !riderDocument.getText(n - 1, 1).equals("\n")) {
                        riderDocument.insertString(n++, "\n", null);
                    }
                    if (styledCopyContent2.getContentType() == 1) {
                        riderDocument.insertSeparateLine(jTextPane, n++, (Integer)styledCopyContent2.getContent());
                        break;
                    }
                    riderDocument.insertPicture(n++, (AreaImage)styledCopyContent2.getContent());
                    break;
                }
            }
        }
    }

    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (StyledCopyContent styledCopyContent : this.clipContent) {
            stringBuilder.append(styledCopyContent.toString());
        }
        return stringBuilder.toString();
    }

    private static final class StyledCopyContent {
        public static final int CONTENT_TEXT = 0;
        public static final int CONTENT_SEPARATOR = 1;
        public static final int CONTENT_IMAGE = 2;
        private final Object content;
        private AttributeSet attr;
        private final int contentType;

        public final Object getContent() {
            return this.content;
        }

        public final AttributeSet getAttr() {
            return this.attr;
        }

        public final int getContentType() {
            return this.contentType;
        }

        public StyledCopyContent(String string, AttributeSet attributeSet) {
            this.content = string;
            this.attr = attributeSet;
            this.contentType = 0;
        }

        public StyledCopyContent(AreaImage areaImage) {
            this.content = areaImage.clone();
            this.contentType = 2;
        }

        public StyledCopyContent(int n) {
            this.content = n;
            this.contentType = 1;
        }

        public final String toString() {
            switch (this.contentType) {
                case 0: {
                    return this.content.toString();
                }
                case 1: {
                    return SeparatorLine.getStringRepresentation((Integer)this.content);
                }
                case 2: {
                    return this.content.toString();
                }
            }
            return this.content.toString();
        }
    }
}

