/*
 * Decompiled with CFR 0.152.
 */
package net.wordrider.area.actions;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.logging.Logger;
import javax.swing.KeyStroke;
import net.wordrider.area.RiderArea;
import net.wordrider.area.actions.InsertPictureAction;
import net.wordrider.area.actions.TextAreaAction;
import net.wordrider.core.Lng;
import net.wordrider.core.MainApp;
import net.wordrider.utilities.LogUtils;
import net.wordrider.utilities.Swinger;

public final class InsertFromClipboardAction
extends TextAreaAction {
    private static final InsertFromClipboardAction instance = new InsertFromClipboardAction();
    private static final String CODE = "InsertFromClipboardAction";
    private static final Logger logger = Logger.getLogger(InsertFromClipboardAction.class.getName());

    public static InsertFromClipboardAction getInstance() {
        return instance;
    }

    private InsertFromClipboardAction() {
        super(CODE, KeyStroke.getKeyStroke(80, 3), "image_btm.gif");
    }

    public final void actionPerformed(ActionEvent actionEvent) {
        RiderArea riderArea = this.getRiderArea(actionEvent);
        if (riderArea != null) {
            Transferable transferable;
            try {
                transferable = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(this);
            }
            catch (IllegalStateException illegalStateException) {
                Swinger.showErrorDialog(MainApp.getInstance().getMainAppFrame(), Lng.getLabel("message.error.clipboard"));
                return;
            }
            if (InsertFromClipboardAction.isFlavourSupported(transferable)) {
                Object object = null;
                try {
                    object = transferable.getTransferData(DataFlavor.imageFlavor);
                }
                catch (UnsupportedFlavorException unsupportedFlavorException) {
                    LogUtils.processException(logger, unsupportedFlavorException);
                }
                catch (IOException iOException) {
                    LogUtils.processException(logger, iOException);
                }
                if (object instanceof Image) {
                    InsertPictureAction.insertImageFromFilter(MainApp.getInstance().getMainAppFrame(), riderArea, null, (Image)object);
                }
            }
        }
    }

    private static boolean isFlavourSupported(Transferable transferable) {
        return transferable.isDataFlavorSupported(DataFlavor.imageFlavor);
    }

    public boolean isFlavourSupported() {
        return InsertFromClipboardAction.isFlavourSupported(Toolkit.getDefaultToolkit().getSystemClipboard().getContents(this));
    }
}

