/*
 * Decompiled with CFR 0.152.
 */
package net.wordrider.area.views;

import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.util.logging.Logger;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.GlyphView;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.TabableView;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import net.wordrider.area.ColorStyles;
import net.wordrider.area.RiderStyles;
import net.wordrider.area.views.RiderViewFactory;
import net.wordrider.utilities.LogUtils;
import net.wordrider.utilities.Swinger;

final class RiderLabelView
extends GlyphView
implements TabableView {
    private boolean vector = false;
    private boolean dotted = false;
    private boolean _underline = false;
    private boolean wordWrap = false;
    private boolean inverse = false;
    private boolean nextElementVector = false;
    private Font font;
    private Color fg;
    private Color bg;
    private boolean underline = false;
    private boolean strike = false;
    private boolean superscript = false;
    private boolean subscript = false;
    private boolean conjugate = false;
    private static final Logger logger = Logger.getLogger(RiderLabelView.class.getName());

    public RiderLabelView(Element element) {
        super(element);
    }

    public final Color getForeground() {
        this.sync();
        return this.fg;
    }

    public final View breakView(int n, int n2, float f, float f2) {
        if (this.wordWrap) {
            return super.breakView(n, n2, f, f2);
        }
        if (n == 0) {
            int n3 = this.getGlyphPainter().getBoundedPosition(this, n2, f, f2);
            return this.createFragment(n2, n3);
        }
        return this;
    }

    public final Font getFont() {
        this.sync();
        return this.font;
    }

    private void setPropertiesFromAttributes() {
        AttributeSet attributeSet = this.getAttributes();
        if (attributeSet != null) {
            boolean bl = RiderStyles.isMath(this.getElement());
            StyledDocument styledDocument = (StyledDocument)this.getDocument();
            if (!bl) {
                this.font = styledDocument.getFont(attributeSet);
                this.fg = styledDocument.getForeground(attributeSet);
                this.underline = RiderStyles.isUnderLine(attributeSet);
                this.strike = RiderStyles.isStrikeOut(attributeSet);
                this.superscript = RiderStyles.isExposant(attributeSet);
                this.subscript = RiderStyles.isSubscript(attributeSet);
                if (this.subscript && this.font.isBold()) {
                    this.font = RiderStyles.maxiFontNoBold;
                }
                this.wordWrap = RiderStyles.isWordWrap(attributeSet);
                this.dotted = RiderStyles.isUnderLineDotted(attributeSet);
                this.vector = RiderStyles.isVector(attributeSet);
                this.inverse = RiderStyles.isInvert(attributeSet);
                this.bg = attributeSet.isDefined(StyleConstants.Background) && this.inverse ? styledDocument.getBackground(attributeSet) : null;
                this.conjugate = RiderStyles.isConjugate(attributeSet);
                if (this.vector) {
                    this.nextElementVector = RiderLabelView.isNextElementVector(this.getElement(), this.getDocument());
                }
                this._underline = RiderStyles.isUnderLine(attributeSet);
            } else {
                this.font = styledDocument.getFont(RiderStyles.mathStyle);
                this.fg = ColorStyles.getColor(2);
                this.bg = null;
                this.conjugate = false;
                this.subscript = false;
                this.superscript = false;
                this.nextElementVector = false;
                this._underline = false;
                this.inverse = false;
                this.vector = false;
                this.dotted = false;
                this.wordWrap = false;
                this.strike = false;
                this.underline = false;
            }
        }
    }

    private static boolean isNextElementVector(Element element, Document document) {
        Element element2 = element.getParentElement();
        int n = element2.getElementCount();
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            Element element3 = element2.getElement(i);
            if (bl) {
                if (RiderStyles.isVector(element3.getAttributes())) {
                    if (i + 1 == n) {
                        try {
                            return !document.getText(element3.getStartOffset(), element3.getEndOffset() - element3.getStartOffset()).equals("\n");
                        }
                        catch (BadLocationException badLocationException) {
                            LogUtils.processException(logger, badLocationException);
                            return false;
                        }
                    }
                    return true;
                }
                return false;
            }
            if (!element3.equals(element)) continue;
            bl = true;
        }
        return false;
    }

    private void fixDrawBug(Graphics graphics, int n, int n2, int n3) {
        graphics.setPaintMode();
        JTextComponent jTextComponent = (JTextComponent)this.getContainer();
        if (RiderViewFactory.isInSelection(jTextComponent, this.getElement())) {
            graphics.setColor(jTextComponent.getSelectionColor());
        } else {
            graphics.setColor(jTextComponent.getBackground());
        }
    }

    public final void paint(Graphics graphics, Shape shape) {
        if (Swinger.antialiasing) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        }
        super.paint(graphics, shape);
        if (this._underline || this.dotted || this.vector || this.conjugate || this.inverse) {
            Graphics2D graphics2D;
            int n = this.getStartOffset();
            int n2 = this.getEndOffset();
            Rectangle rectangle = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
            graphics.setColor(this.getForeground());
            this.checkPainter();
            GlyphView.GlyphPainter glyphPainter = this.getGlyphPainter();
            int n3 = rectangle.x;
            int n4 = this.getStartOffset();
            if (n4 != n) {
                n3 += (int)glyphPainter.getSpan(this, n4, n, this.getTabExpander(), n3);
            }
            int n5 = n3 + (int)glyphPainter.getSpan(this, n, n2, this.getTabExpander(), n3);
            int n6 = (int)glyphPainter.getDescent(this);
            int n7 = rectangle.y + rectangle.height - n6;
            if (this.inverse && n3 == n5) {
                this.fixDrawBug(graphics, n3, n7 + 1, rectangle.y + rectangle.height - (int)glyphPainter.getAscent(this) - 4);
            }
            Stroke stroke = null;
            if (this.dotted) {
                graphics2D = (Graphics2D)graphics;
                stroke = graphics2D.getStroke();
                graphics2D.setStroke(RiderStyles.DOTTED_STROKE);
            }
            if (this.dotted) {
                graphics.drawLine(n3, ++n7, n5, n7);
            } else if (this._underline && n5 == n3) {
                this.fixDrawBug(graphics, n3, n7, n7);
            }
            if (stroke != null) {
                graphics2D = (Graphics2D)graphics;
                graphics2D.setStroke(stroke);
            }
            if (this.vector || this.conjugate) {
                n7 = rectangle.y + rectangle.height - (int)glyphPainter.getAscent(this) - 1;
                if (n3 != n5) {
                    graphics.drawLine(n3, n7, n5, n7);
                }
                if (this.vector && n5 != n3 && !this.nextElementVector) {
                    graphics.drawLine(n5 + 1, n7, n5 - 4, n7 - 2);
                    graphics.drawLine(n5 + 1, n7, n5 - 4, n7 + 2);
                }
            }
        }
    }

    private void sync() {
        if (this.font == null) {
            this.setPropertiesFromAttributes();
        }
    }

    protected FontMetrics getFontMetrics() {
        this.sync();
        Container container = this.getContainer();
        return container != null ? container.getFontMetrics(this.font) : Toolkit.getDefaultToolkit().getFontMetrics(this.font);
    }

    public Color getBackground() {
        this.sync();
        return this.bg;
    }

    public boolean isUnderline() {
        this.sync();
        return this.underline;
    }

    public boolean isStrikeThrough() {
        this.sync();
        return this.strike;
    }

    public boolean isSubscript() {
        this.sync();
        return this.subscript;
    }

    public boolean isSuperscript() {
        this.sync();
        return this.superscript;
    }

    public void changedUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        this.font = null;
        super.changedUpdate(documentEvent, shape, viewFactory);
    }
}

