/*
 * Decompiled with CFR 0.152.
 */
package net.wordrider.area;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.UndoableEditEvent;
import javax.swing.text.AbstractDocument;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;
import net.wordrider.area.RiderArea;
import net.wordrider.area.actions.RedoAction;
import net.wordrider.area.actions.UndoAction;

final class AreaUndoManager
extends UndoManager
implements PropertyChangeListener {
    private final RiderArea editor;
    private CompoundEdit compoundEdit;
    private int lastOffset;
    private boolean multipleUndo = false;
    private boolean multipleUndoFirstTime = false;

    public AreaUndoManager(RiderArea riderArea) {
        this.editor = riderArea;
        riderArea.getDocument().addUndoableEditListener(this);
        riderArea.addPropertyChangeListener("document", this);
        riderArea.addPropertyChangeListener("undoredo", this);
    }

    public final boolean addEdit(UndoableEdit undoableEdit) {
        boolean bl = super.addEdit(undoableEdit);
        this.updateStatuses();
        return bl;
    }

    private void updateStatuses() {
        UndoAction.getInstance().updateUndoState(this.editor);
        this.editor.setModified(this.canUndoOrRedo());
        RedoAction.getInstance().updateRedoState(this.editor);
    }

    public final void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
        if (this.multipleUndoFirstTime || this.compoundEdit == null) {
            this.initMultipleUndoRedo(undoableEditEvent);
            return;
        }
        int n = this.editor.getCaretPosition() - this.lastOffset;
        if (Math.abs(n) == 1 || this.multipleUndo) {
            this.compoundEdit.addEdit(undoableEditEvent.getEdit());
            this.updateStatuses();
            this.lastOffset += n;
            return;
        }
        this.compoundEdit.end();
        this.compoundEdit = this.startCompoundEdit(undoableEditEvent.getEdit());
    }

    private void initMultipleUndoRedo(UndoableEditEvent undoableEditEvent) {
        if (this.compoundEdit != null) {
            this.compoundEdit.end();
        }
        this.compoundEdit = this.startCompoundEdit(undoableEditEvent == null ? null : undoableEditEvent.getEdit());
        this.multipleUndoFirstTime = false;
    }

    private CompoundEdit startCompoundEdit(UndoableEdit undoableEdit) {
        this.lastOffset = this.editor.getCaretPosition();
        if (undoableEdit != null) {
            AbstractDocument.DefaultDocumentEvent defaultDocumentEvent = (AbstractDocument.DefaultDocumentEvent)undoableEdit;
            boolean bl = defaultDocumentEvent.getType() == DocumentEvent.EventType.CHANGE;
            this.compoundEdit = new MyCompoundEdit(this.editor, bl);
            this.compoundEdit.addEdit(undoableEdit);
        } else {
            this.compoundEdit = new MyCompoundEdit(this.editor, true);
        }
        this.addEdit(this.compoundEdit);
        return this.compoundEdit;
    }

    public synchronized void discardAllEdits() {
        super.discardAllEdits();
        UndoAction.getInstance().updateUndoState(this.editor);
        RedoAction.getInstance().updateRedoState(this.editor);
    }

    public final void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getSource().equals(this.getEditor())) {
            if (propertyChangeEvent.getPropertyName().equals("document")) {
                ((Document)propertyChangeEvent.getOldValue()).removeUndoableEditListener(this);
                Document document = (Document)propertyChangeEvent.getNewValue();
                document.addUndoableEditListener(this);
                this.discardAllEdits();
            } else if (propertyChangeEvent.getPropertyName().equals("undoredo")) {
                this.multipleUndo = this.multipleUndoFirstTime = ((Boolean)propertyChangeEvent.getNewValue()).booleanValue();
                if (this.multipleUndoFirstTime) {
                    this.initMultipleUndoRedo(null);
                }
            }
        }
    }

    private JTextComponent getEditor() {
        return this.editor;
    }

    private final class MyCompoundEdit
    extends CompoundEdit {
        private final int realSelStart;
        private final int realSelEnd;
        private final boolean accurate;

        public MyCompoundEdit(RiderArea riderArea, boolean bl) {
            this.realSelStart = riderArea.getCaret().getMark();
            this.realSelEnd = riderArea.getCaret().getDot();
            this.accurate = bl;
        }

        public final boolean isInProgress() {
            return false;
        }

        public final void undo() throws CannotUndoException {
            if (AreaUndoManager.this.compoundEdit != null) {
                AreaUndoManager.this.compoundEdit.end();
            }
            AreaUndoManager.this.editor.putClientProperty("makingundo", Boolean.TRUE);
            super.undo();
            AreaUndoManager.this.editor.putClientProperty("makingundo", null);
            this.updateEditor();
            AreaUndoManager.this.compoundEdit = null;
        }

        private void updateEditor() {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (MyCompoundEdit.this.realSelStart == MyCompoundEdit.this.realSelEnd) {
                        AreaUndoManager.this.editor.setCaretPosition(Math.max(Math.min(MyCompoundEdit.this.realSelStart + (MyCompoundEdit.this.accurate ? 0 : -1), AreaUndoManager.this.editor.getDocument().getLength()), 0));
                    } else {
                        AreaUndoManager.this.editor.selectReverse(MyCompoundEdit.this.realSelStart, MyCompoundEdit.this.realSelEnd);
                    }
                    AreaUndoManager.this.editor.validate();
                    AreaUndoManager.this.editor.repaint();
                }
            });
        }

        public void redo() throws CannotRedoException {
            super.redo();
            this.updateEditor();
        }
    }
}

