/*
 * Decompiled with CFR 0.152.
 */
package net.wordrider.area.views;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import javax.swing.text.Element;
import javax.swing.text.IconView;
import javax.swing.text.Position;
import net.wordrider.area.RiderArea;
import net.wordrider.area.RiderStyles;
import net.wordrider.area.views.RiderViewFactory;

final class RiderIconView
extends IconView {
    private boolean wasInSelection;
    private static final Stroke SELECTION_STROKE = new BasicStroke(3.0f);

    public RiderIconView(Element element) {
        super(element);
    }

    public float getAlignment(int n) {
        switch (n) {
            case 1: {
                return super.getAlignment(n);
            }
        }
        return 0.5f;
    }

    public final String getToolTipText(float f, float f2, Shape shape) {
        return RiderStyles.getImage(this.getElement()).getDescription();
    }

    public final int viewToModel(float f, float f2, Shape shape, Position.Bias[] biasArray) {
        Rectangle rectangle = (Rectangle)shape;
        if (f < (float)(rectangle.x + rectangle.width)) {
            biasArray[0] = Position.Bias.Forward;
            return this.getStartOffset();
        }
        biasArray[0] = Position.Bias.Backward;
        return this.getEndOffset();
    }

    public final void paint(Graphics graphics, Shape shape) {
        Element element;
        RiderArea riderArea = (RiderArea)this.getContainer();
        if (RiderViewFactory.isInSelection(riderArea, element = this.getElement())) {
            super.paint(graphics, shape);
            int n = riderArea.getSelectionEnd();
            Rectangle rectangle = shape.getBounds();
            if (riderArea.getSelectionStart() == element.getStartOffset() && n == element.getEndOffset()) {
                Graphics2D graphics2D = (Graphics2D)graphics;
                graphics2D.setPaintMode();
                graphics2D.setColor(riderArea.getSelectionColor());
                Stroke stroke = graphics2D.getStroke();
                graphics2D.setStroke(SELECTION_STROKE);
                graphics2D.drawRect(rectangle.x + 1, rectangle.y + 1, rectangle.width - 3, rectangle.height - 1);
                graphics2D.setStroke(stroke);
            } else {
                graphics.setXORMode(Color.WHITE);
                graphics.setColor(riderArea.getSelectedTextColor());
                graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
            this.wasInSelection = true;
        } else {
            if (this.wasInSelection) {
                this.wasInSelection = false;
                riderArea.getDoc().refresh(element.getStartOffset(), element.getEndOffset() - element.getStartOffset());
                return;
            }
            super.paint(graphics, shape);
        }
    }
}

