/*
 * Decompiled with CFR 0.152.
 */
package net.wordrider.core.actions;

import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.KeyStroke;
import net.wordrider.core.AppPrefs;
import net.wordrider.core.Lng;
import net.wordrider.core.actions.CoreAction;
import net.wordrider.core.actions.FileProcessorFactory;
import net.wordrider.core.managers.AreaManager;
import net.wordrider.dialogs.RiderFileFilter;
import net.wordrider.utilities.Swinger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OpenFileAction
extends CoreAction {
    private static final OpenFileAction instance = new OpenFileAction();

    public static OpenFileAction getInstance() {
        return instance;
    }

    private OpenFileAction() {
        super("OpenFileAction", KeyStroke.getKeyStroke(79, 2), "open.gif");
    }

    private static void updateFileFilters(JFileChooser jFileChooser, List<RiderFileFilter> list, String string) {
        for (RiderFileFilter riderFileFilter : list) {
            jFileChooser.addChoosableFileFilter(riderFileFilter);
        }
        int n = AppPrefs.getProperty(string, list.size() - 1);
        if (n >= 0 && n < list.size()) {
            jFileChooser.setFileFilter(list.get(n));
        }
    }

    private static File[] getOpenFileDialog(List<RiderFileFilter> list, String string, String string2) {
        File file = new File(AppPrefs.getProperty(string2, ""));
        JFileChooser jFileChooser = new JFileChooser(file);
        OpenFileAction.updateFileFilters(jFileChooser, list, string);
        jFileChooser.setDialogTitle(Lng.getLabel("OpenFileAction.dialog.title"));
        jFileChooser.setMultiSelectionEnabled(true);
        int n = jFileChooser.showOpenDialog(OpenFileAction.getMainFrame());
        if (n != 0) {
            return new File[0];
        }
        AppPrefs.storeProperty(string, list.indexOf(jFileChooser.getFileFilter()));
        return jFileChooser.getSelectedFiles();
    }

    public static boolean open(File file) {
        if (file == null) {
            return false;
        }
        if (!file.isFile() || !file.exists()) {
            Swinger.showErrorDialog(OpenFileAction.getMainFrame(), Lng.getLabel("message.error.FNF", file.getAbsolutePath()));
            return false;
        }
        return FileProcessorFactory.getInstance().getProcessorByFile(file).process();
    }

    @Override
    public final void actionPerformed(ActionEvent actionEvent) {
        File[] fileArray = OpenFileAction.getOpenFileDialog(OpenFileAction.getFileFilters(), "settings.openfilter", "settings.lastOpenFolder");
        int n = fileArray.length;
        for (int i = 0; i < n && OpenFileAction.open(fileArray[i]); ++i) {
        }
        AreaManager.getInstance().grabActiveFocus();
    }

    private static List<RiderFileFilter> getFileFilters() {
        ArrayList<RiderFileFilter> arrayList = new ArrayList<RiderFileFilter>(6);
        arrayList.add(new RiderFileFilter(new String[]{"txt"}, "OpenFileAction.dialog.filterTxt"));
        arrayList.add(new RiderFileFilter(new String[]{"9xy"}, "OpenFileAction.dialog.filter9xy"));
        arrayList.add(new RiderFileFilter(new String[]{"89y"}, "OpenFileAction.dialog.filter89y"));
        arrayList.add(new RiderFileFilter(new String[]{"92t"}, "OpenFileAction.dialog.filter92"));
        arrayList.add(new RiderFileFilter(new String[]{"9xt"}, "OpenFileAction.dialog.filter9x"));
        arrayList.add(new RiderFileFilter(new String[]{"89t"}, "OpenFileAction.dialog.filter89"));
        arrayList.add(new RiderFileFilter(new String[]{"89t", "9xt", "92t", "89y", "9xy", "txt"}, "OpenFileAction.dialog.allsupported"));
        return arrayList;
    }
}

