/*
 * Decompiled with CFR 0.152.
 */
package net.wordrider.core.actions;

import java.util.ArrayList;
import java.util.regex.Pattern;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.StyledDocument;
import net.wordrider.area.AreaImage;
import net.wordrider.area.RiderStyles;
import net.wordrider.files.ti68kformat.TIFileInfo;
import net.wordrider.files.ti68kformat.TITextFileInfo;

final class TextRiderProcess {
    private static final String[] txtriderParagraphTags = new String[]{"#1", "#2", "#3", "&L", "&R", "&C", "&\\", "&,", "&;", "&.", "&-", "&=", "&E", "&P", "&M"};
    private final MatchedTag[] matchedTags = new MatchedTag[]{new MatchedTag(0, "#U"), new MatchedTag(1, "#V"), new MatchedTag(2, "#I"), new MatchedTag(3, "#N"), new MatchedTag(4, "#S"), new MatchedTag(5, "#E"), new MatchedTag(6, "#W"), new MatchedTag(7, "#J"), new MatchedTag(8, "#D")};
    private final short[] attributesMore = new short[3];
    private static final byte P_ALIGNMENT = 0;
    private static final byte P_SIZE = 1;
    private static final byte P_MARGIN = 2;
    private static final byte P_SIZEMINI = 0;
    private static final byte P_SIZENORMAL = 1;
    private static final byte P_SIZEMAXI = 2;
    private static final byte P_ALIGNLEFT = 3;
    private static final byte P_ALIGNRIGHT = 4;
    private static final byte P_ALIGNCENTER = 5;
    private static final byte P_MARGIN0 = 6;
    private static final byte P_MARGIN10 = 7;
    private static final byte P_MARGIN20 = 8;
    private static final byte P_MARGIN30 = 9;
    private static final byte P_LINESEPARATOR = 10;
    private static final byte P_DOUBLELINE = 11;
    private static final byte P_PRETTYPRINT = 12;
    private static final byte P_PICTURE = 13;
    private static final byte P_CUSTOMMARGIN = 14;
    private static final String LINE_SEPARATOR_TEXT = "\n";
    private static final String LINE_SEPARATOR_FILE = "\r ";
    private static final String tabulator = "   ";
    private String activeLineSeparator = "\n";
    private StringBuilder builder;
    private boolean prettyPrint = false;
    private TITextFileInfo textFileInfo;
    private FastStack firstStack;
    private boolean hibviewFormat;
    private static final String LINE_SEPARATOR1 = "\n";
    private static final String LINE_SEPARATOR2 = "\n\r";
    private Pattern replaceSpecialPattern = Pattern.compile("#");

    TextRiderProcess() {
    }

    private void initProcess() {
        this.attributesMore[0] = 3;
        this.attributesMore[1] = 1;
        this.attributesMore[2] = 6;
        this.firstStack = new FastStack();
    }

    public final String getTxtRiderTextForDocument(StyledDocument styledDocument, TITextFileInfo tITextFileInfo, boolean bl) throws BadLocationException {
        Element element = styledDocument.getDefaultRootElement();
        int n = element.getElementCount();
        this.hibviewFormat = tITextFileInfo.isHibviewFormat();
        this.activeLineSeparator = bl ? LINE_SEPARATOR_FILE : "\n";
        this.builder = new StringBuilder(styledDocument.getLength() + 50);
        this.textFileInfo = tITextFileInfo;
        this.initProcess();
        for (int i = 0; i < n; ++i) {
            Element element2 = element.getElement(i);
            if (bl) {
                this.updateBookmark(element2);
            }
            int n2 = this.builder.length();
            if (!RiderStyles.isReadonlySection(element2)) {
                this.updateParagraphProperties(element2);
            }
            int n3 = element2.getElementCount();
            boolean bl2 = false;
            for (int j = 0; j < n3; ++j) {
                boolean bl3;
                int n4;
                boolean bl4;
                Element element3 = element2.getElement(j);
                boolean bl5 = bl4 = j == 0;
                if (this.updateComponents(element3, bl4)) {
                    bl2 = true;
                    continue;
                }
                int n5 = element3.getStartOffset();
                String string = styledDocument.getText(n5, (n4 = element3.getEndOffset()) - n5);
                boolean bl6 = bl3 = string.equals("\n") || string.equals(LINE_SEPARATOR2);
                if (bl2 && !bl3) {
                    this.builder.append(this.activeLineSeparator);
                    n2 = this.builder.length();
                    bl4 = true;
                }
                if (this.hibviewFormat) {
                    string = this.replaceSpecialPattern.matcher(string).replaceAll("##");
                }
                if (!(this.prettyPrint || bl2 || bl3 && n3 > 1)) {
                    this.updateCharacterAttributes(element3.getAttributes());
                }
                if (bl4 && this.hibviewFormat && this.builder.length() == n2 && string.startsWith("&")) {
                    string = "&" + string;
                }
                this.builder.append(string);
            }
        }
        this.firstStack.clear();
        return this.updateResult(bl);
    }

    private boolean updateComponents(Element element, boolean bl) {
        return this.updateSingleLine(element, bl) || this.updateDoubleLine(element, bl) || this.updateImageComponent(element, bl);
    }

    private void updateCharacterAttributes(AttributeSet attributeSet) {
        for (int i = this.firstStack.size() - 1; i >= 0; --i) {
            this.matchedTags[(Integer)this.firstStack.get(i)].updateTagFirst(attributeSet);
        }
        this.updateFontSize(attributeSet);
        this.matchedTags[5].updateTag(attributeSet);
        if (this.hibviewFormat) {
            this.matchedTags[7].updateTag(attributeSet);
            this.matchedTags[8].updateTag(attributeSet);
        }
        this.matchedTags[6].updateTag(attributeSet);
        this.matchedTags[0].updateTag(attributeSet);
        this.matchedTags[2].updateTag(attributeSet);
        this.matchedTags[3].updateTag(attributeSet);
        this.matchedTags[4].updateTag(attributeSet);
        this.matchedTags[1].updateTag(attributeSet);
    }

    private String updateResult(boolean bl) {
        if (bl) {
            this.builder.deleteCharAt(this.builder.length() - 1);
            if (this.builder.charAt(this.builder.length() - 1) == '\n') {
                this.builder.append(' ');
            }
            String string = this.builder.toString().replaceAll(LINE_SEPARATOR2, LINE_SEPARATOR_FILE).replaceAll("\t", tabulator);
            this.builder = null;
            return string;
        }
        String string = this.builder.toString();
        this.builder = null;
        return string;
    }

    private void updateBookmark(Element element) {
        this.builder.append(RiderStyles.isBookmark(element) ? (char)'\f' : ' ');
    }

    private boolean updatePrettyPrint(Element element) {
        boolean bl = RiderStyles.isMath(element);
        if (bl) {
            this.builder.append(txtriderParagraphTags[12]);
            this.resetMarginToLeft();
        }
        return bl;
    }

    private void updateParagraphProperties(Element element) {
        this.prettyPrint = this.updatePrettyPrint(element);
        if (!this.prettyPrint) {
            AttributeSet attributeSet = element.getAttributes();
            int n = this.builder.length();
            this.updateMargin(attributeSet);
            if (n == this.builder.length()) {
                this.updateAlignment(attributeSet);
            }
        }
    }

    private void updateMargin(AttributeSet attributeSet) {
        boolean bl = false;
        short s = RiderStyles.getMargin(attributeSet);
        switch (s) {
            case 0: {
                s = 6;
                break;
            }
            case 10: {
                s = 7;
                break;
            }
            case 20: {
                s = 8;
                break;
            }
            case 30: {
                s = 9;
                break;
            }
            default: {
                if (this.hibviewFormat) {
                    bl = true;
                    break;
                }
                s = 6;
            }
        }
        if (this.attributesMore[2] != s) {
            this.attributesMore[2] = s;
            if (bl) {
                this.builder.append(txtriderParagraphTags[14]);
                if (s >= 10 && s < 100) {
                    this.builder.append("0");
                } else if (s < 10) {
                    this.builder.append("00");
                }
                this.builder.append(String.valueOf(s));
            } else {
                this.builder.append(txtriderParagraphTags[s]);
            }
        }
    }

    private void updateAlignment(AttributeSet attributeSet) {
        short s;
        switch (RiderStyles.getAlignment(attributeSet)) {
            case 0: {
                s = 3;
                break;
            }
            case 1: {
                s = 5;
                break;
            }
            case 2: {
                s = 4;
                break;
            }
            default: {
                s = 3;
            }
        }
        if (this.attributesMore[0] != s) {
            this.attributesMore[0] = s;
            this.builder.append(txtriderParagraphTags[s]);
        }
    }

    private void updateFontSize(AttributeSet attributeSet) {
        short s;
        switch (RiderStyles.getFontSize(attributeSet)) {
            case 13: {
                s = 1;
                break;
            }
            case 16: {
                s = 2;
                break;
            }
            case 11: {
                s = 0;
                break;
            }
            default: {
                s = 1;
            }
        }
        if (this.attributesMore[1] != s) {
            this.attributesMore[1] = s;
            this.builder.append(txtriderParagraphTags[s]);
        }
    }

    private void resetMarginToLeft() {
        this.attributesMore[2] = 6;
    }

    private boolean updateSingleLine(Element element, boolean bl) {
        if (RiderStyles.isComponentLine(element, 0)) {
            if (!bl) {
                this.builder.append(this.activeLineSeparator);
            }
            this.resetMarginToLeft();
            this.builder.append(txtriderParagraphTags[10]);
            return true;
        }
        return false;
    }

    private boolean updateDoubleLine(Element element, boolean bl) {
        if (RiderStyles.isComponentLine(element, 1)) {
            if (!bl) {
                this.builder.append(this.activeLineSeparator);
            }
            this.builder.append(txtriderParagraphTags[11]);
            this.resetMarginToLeft();
            return true;
        }
        return false;
    }

    private String generateImageDesc(String string, TIFileInfo tIFileInfo) {
        switch (this.textFileInfo.getPictureProcessingType()) {
            case 0: {
                return tIFileInfo.getFolderName() + "\\" + tIFileInfo.getVarName();
            }
            case 1: {
                int n = string.lastIndexOf(92) + 1;
                if (n != 0) {
                    return string.substring(n) + "\\" + tIFileInfo.getVarName();
                }
                return tIFileInfo.getFolderName() + "\\" + tIFileInfo.getVarName();
            }
            case 2: {
                return this.textFileInfo.getPictureFolder() + "\\" + tIFileInfo.getVarName();
            }
            case 4: {
                return this.textFileInfo.getFolderName() + "\\" + tIFileInfo.getVarName();
            }
        }
        return null;
    }

    private boolean updateImageComponent(Element element, boolean bl) {
        AreaImage areaImage;
        String string;
        if (RiderStyles.isImage(element) && (string = this.generateImageDesc((areaImage = RiderStyles.getImage(element)).getImagePath(), areaImage.getTIFileInfo())) != null) {
            if (!bl) {
                this.builder.append(this.activeLineSeparator);
            }
            this.resetMarginToLeft();
            this.builder.append(txtriderParagraphTags[13]).append(string);
            return true;
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class FastStack
    extends ArrayList<Object> {
        public FastStack() {
            super(5);
        }

        public void push(int n) {
            this.add(n);
        }

        public int pop() {
            return (Integer)this.remove(this.size() - 1);
        }

        public int peek() {
            int n = this.size();
            if (n == 0) {
                return -1;
            }
            return (Integer)this.get(n - 1);
        }
    }

    private final class MatchedTag {
        private boolean isSet = false;
        private final String tag;
        private final byte propertyCode;
        private boolean alreadyWas = false;

        public MatchedTag(byte by, String string) {
            this.tag = string;
            this.propertyCode = by;
        }

        public final void updateTag(AttributeSet attributeSet) {
            if (this.alreadyWas) {
                this.alreadyWas = false;
                return;
            }
            boolean bl = RiderStyles.isSet(attributeSet, this.propertyCode);
            if (bl ^ this.isSet) {
                this.isSet = bl;
                if (TextRiderProcess.this.firstStack.peek() == this.propertyCode && !this.isSet) {
                    TextRiderProcess.this.firstStack.pop();
                } else {
                    TextRiderProcess.this.firstStack.push(this.propertyCode);
                }
                TextRiderProcess.this.builder.append(this.tag);
            }
        }

        public final void updateTagFirst(AttributeSet attributeSet) {
            this.updateTag(attributeSet);
            this.alreadyWas = true;
        }
    }
}

