/*
 * Decompiled with CFR 0.152.
 */
package net.wordrider.core.managers;

import info.clearthought.layout.TableLayout;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import net.wordrider.core.actions.CreateNewFileAction;
import net.wordrider.core.actions.OpenFileAction;
import net.wordrider.core.actions.OpenKeymapAction;
import net.wordrider.core.actions.OpenRecentsAction;
import net.wordrider.core.actions.OpenSampleFileAction;
import net.wordrider.core.actions.VisitHomepageAction;
import net.wordrider.core.actions.WebAction;
import net.wordrider.core.managers.AreaManager;
import net.wordrider.core.managers.FileChangeEvent;
import net.wordrider.core.managers.interfaces.IFileChangeListener;
import net.wordrider.core.managers.interfaces.IRiderManager;
import net.wordrider.core.swing.CustomLayoutConstraints;
import net.wordrider.gui.LookAndFeels;
import net.wordrider.utilities.Swinger;

public final class DataDividerManager
implements IRiderManager,
IFileChangeListener,
PropertyChangeListener {
    private static final Logger logger = Logger.getLogger(DataDividerManager.class.getName());
    private final JSplitPane splitPane;
    private boolean isGraphicMenu = false;
    private final Component rightComponent;
    private Component graphicMenu = null;
    private JLabel labelWelcome = null;

    public DataDividerManager(JPanel jPanel, Component component, Component component2) {
        this.rightComponent = component2;
        this.splitPane = new JSplitPane(1, component, component2);
        jPanel.add((Component)this.splitPane, "Center");
        this.splitPane.setOneTouchExpandable(true);
        this.splitPane.setDividerSize(8);
    }

    public final Component getManagerComponent() {
        return this.splitPane;
    }

    public void fileWasOpened(FileChangeEvent fileChangeEvent) {
        if (this.isGraphicMenu) {
            this.splitPane.setRightComponent(this.rightComponent);
            this.isGraphicMenu = false;
        }
    }

    public void fileWasClosed(FileChangeEvent fileChangeEvent) {
        if (!((AreaManager)fileChangeEvent.getSource()).hasOpenedInstance()) {
            this.setGraphicMenu();
        }
    }

    public void setGraphicMenu() {
        if (!this.isGraphicMenu) {
            this.splitPane.setRightComponent(this.getGraphicMenu());
            this.isGraphicMenu = true;
            logger.fine("Setting graphic menu");
        }
    }

    private Component getGraphicMenu() {
        if (this.graphicMenu != null) {
            return this.graphicMenu;
        }
        UIManager.addPropertyChangeListener(this);
        TableLayout tableLayout = new TableLayout(new double[]{-2.0, -2.0, -1.0}, new double[]{-2.0, -2.0, -2.0});
        tableLayout.setHGap(10);
        tableLayout.setVGap(5);
        BackGroundPanel backGroundPanel = new BackGroundPanel(tableLayout);
        TableLayout tableLayout2 = new TableLayout(new double[]{-2.0}, new double[]{-2.0, -2.0, -2.0, -2.0, -2.0, -2.0});
        tableLayout.setHGap(10);
        tableLayout.setVGap(5);
        JPanel jPanel = new JPanel(tableLayout2);
        jPanel.setOpaque(false);
        jPanel.setBackground(null);
        TableLayout tableLayout3 = new TableLayout(new double[]{-2.0}, new double[]{-2.0, -2.0, -2.0, -2.0, -2.0, -2.0});
        tableLayout.setHGap(10);
        tableLayout.setVGap(5);
        JPanel jPanel2 = new JPanel(tableLayout3);
        jPanel2.setOpaque(false);
        jPanel2.setBackground(null);
        this.labelWelcome = Swinger.getLabel("gmenu.labelWelcome");
        this.labelWelcome.setFont(this.labelWelcome.getFont().deriveFont(1, 28.0f));
        Border border = BorderFactory.createEmptyBorder(4, 10, 4, 4);
        this.labelWelcome.setBorder(border);
        this.labelWelcome.setForeground(Color.WHITE);
        this.labelWelcome.setOpaque(true);
        this.labelWelcome.setHorizontalAlignment(2);
        this.updateLabelWelcomeColor();
        JComponent jComponent = Swinger.getGraphicItem("gmenu.itemNew", "editor.gif", CreateNewFileAction.getInstance());
        JComponent jComponent2 = Swinger.getGraphicItem("gmenu.itemOpen", "open_big.gif", OpenFileAction.getInstance());
        JComponent jComponent3 = Swinger.getGraphicItem("gmenu.itemRecent", "open_big.gif", new OpenRecentsAction());
        JComponent jComponent4 = Swinger.getGraphicItem("gmenu.itemDemo", "flash.gif", new WebAction("http://wordrider.net/download.php?file=swf/WordRider/WordRider.html"));
        JComponent jComponent5 = Swinger.getGraphicItem("gmenu.itemSample", "editor.gif", new OpenSampleFileAction());
        JComponent jComponent6 = Swinger.getGraphicItem("gmenu.itemKeymap", "adobe.gif", OpenKeymapAction.getInstance());
        JComponent jComponent7 = Swinger.getGraphicItem("gmenu.itemWeb", "011.png", VisitHomepageAction.getInstance());
        backGroundPanel.add((Component)this.labelWelcome, new CustomLayoutConstraints(0, 0, 3, 1));
        backGroundPanel.add((Component)jPanel, new CustomLayoutConstraints(0, 1));
        backGroundPanel.add((Component)jPanel2, new CustomLayoutConstraints(1, 1));
        jPanel.add((Component)Swinger.getTitleComponent2("gmenu.sectionNew"), new CustomLayoutConstraints(0, 0));
        jPanel.add((Component)jComponent, new CustomLayoutConstraints(0, 1));
        jPanel.add((Component)Swinger.getTitleComponent2("gmenu.sectionOpen"), new CustomLayoutConstraints(0, 2));
        jPanel.add((Component)jComponent2, new CustomLayoutConstraints(0, 3));
        jPanel.add((Component)jComponent3, new CustomLayoutConstraints(0, 4));
        jPanel2.add((Component)Swinger.getTitleComponent2("gmenu.sectionQuickStart"), new CustomLayoutConstraints(0, 0));
        jPanel2.add((Component)jComponent4, new CustomLayoutConstraints(0, 1));
        jPanel2.add((Component)jComponent5, new CustomLayoutConstraints(0, 2));
        jPanel2.add((Component)Swinger.getTitleComponent2("gmenu.sectionQuickLinks"), new CustomLayoutConstraints(0, 3));
        jPanel2.add((Component)jComponent6, new CustomLayoutConstraints(0, 4));
        jPanel2.add((Component)jComponent7, new CustomLayoutConstraints(0, 5));
        this.graphicMenu = backGroundPanel;
        return backGroundPanel;
    }

    private void updateLabelWelcomeColor() {
        if (this.labelWelcome != null) {
            this.labelWelcome.setBackground(UIManager.getDefaults().getColor("Menu.selectionBackground"));
            if (this.labelWelcome.isVisible()) {
                this.labelWelcome.validate();
                this.labelWelcome.repaint();
            }
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (this.graphicMenu == null) {
            return;
        }
        if (propertyChangeEvent.getPropertyName().equals("lookAndFeel")) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    LookAndFeels.updateComponentTreeUI(DataDividerManager.this.graphicMenu);
                    DataDividerManager.this.updateLabelWelcomeColor();
                }
            });
        }
    }

    private static class BackGroundPanel
    extends JPanel {
        private Image image = Swinger.getIconImage("calcbg.png");

        public BackGroundPanel(LayoutManager layoutManager) {
            super(layoutManager);
        }

        protected void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            Graphics2D graphics2D = (Graphics2D)graphics;
            Composite composite = graphics2D.getComposite();
            graphics2D.setComposite(AlphaComposite.getInstance(3, 0.5f));
            int n = this.image.getWidth(null);
            int n2 = this.image.getHeight(null);
            graphics2D.drawImage(this.image, this.getWidth() - n, this.getHeight() - n2, null);
            graphics2D.setComposite(composite);
        }
    }
}

